/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.meta.declaration;

import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.FunctionalDeclaration$impl;
import ceylon.language.meta.declaration.GenericDeclaration;
import ceylon.language.meta.model.Type;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Sequenced;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="A function declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel function\n\nBecause some functions have type parameters, getting a model requires applying type arguments to the\nfunction declaration with [[apply]] in order to be able to invoke that function. For example, here is how you would\nobtain a function model that you can invoke from a toplevel function declaration:\n\n    String foo<T>(){\n        return \"Hello, our T is: ``typeLiteral<T>()``\";\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the foo declaration in order to get the foo<Integer> function model\n        Function<String,[]> functionModel = `function foo`.apply<String,[]>(`Integer`);\n        // This will print: Hello, our T is: ceylon.language::Integer\n        print(functionModel());\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for methods\n\nFor methods it is a bit longer, because methods need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared String hello() => \"Hello\";\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the method declaration `Outer.hello`\n        Method<Outer,String,[]> methodModel = `function Outer.hello`.memberApply<Outer,String,[]>(`Outer`);\n        // We now have a Method, which needs to be applied to a containing instance in order to become an\n        // invokable function:\n        Function<String,[]> boundMethodModel = methodModel(Outer());\n        // This will print: Hello\n        print(boundMethodModel());\n    }\n")
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Annotations(modifiers=18L, value={@Annotation(value="doc", arguments={"A function declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel function\n\nBecause some functions have type parameters, getting a model requires applying type arguments to the\nfunction declaration with [[apply]] in order to be able to invoke that function. For example, here is how you would\nobtain a function model that you can invoke from a toplevel function declaration:\n\n    String foo<T>(){\n        return \"Hello, our T is: ``typeLiteral<T>()``\";\n    }\n    \n    void test(){\n        // We need to apply the Integer closed type to the foo declaration in order to get the foo<Integer> function model\n        Function<String,[]> functionModel = `function foo`.apply<String,[]>(`Integer`);\n        // This will print: Hello, our T is: ceylon.language::Integer\n        print(functionModel());\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for methods\n\nFor methods it is a bit longer, because methods need to be applied not only their type arguments but also\nthe containing type, so you should use [[memberApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared String hello() => \"Hello\";\n    }\n\n    void test(){\n        // apply the containing closed type `Outer` to the method declaration `Outer.hello`\n        Method<Outer,String,[]> methodModel = `function Outer.hello`.memberApply<Outer,String,[]>(`Outer`);\n        // We now have a Method, which needs to be applied to a containing instance in order to become an\n        // invokable function:\n        Function<String,[]> boundMethodModel = methodModel(Outer());\n        // This will print: Hello\n        print(boundMethodModel());\n    }\n"})})
@SatisfiedTypes(value={"ceylon.language.meta.declaration::GenericDeclaration"})
public interface FunctionalDeclaration
extends GenericDeclaration {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(FunctionalDeclaration.class, new TypeDescriptor[0]);

    @Ignore
    public FunctionalDeclaration$impl $ceylon$language$meta$declaration$FunctionalDeclaration$impl();

    @DocAnnotation$annotation$(description="True if the current declaration is an annotation class or function.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"True if the current declaration is an annotation class or function."})})
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean getAnnotation();

    @DocAnnotation$annotation$(description="The list of parameter declarations for this functional declaration.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"The list of parameter declarations for this functional declaration."})})
    @TypeInfo(value="ceylon.language.meta.declaration::FunctionOrValueDeclaration[]")
    public Sequential<? extends FunctionOrValueDeclaration> getParameterDeclarations();

    @DocAnnotation$annotation$(description="Gets a parameter declaration by name. Returns `null` if no such parameter exists.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Gets a parameter declaration by name. Returns `null` if no such parameter exists."})})
    @TypeInfo(value="ceylon.language.meta.declaration::FunctionOrValueDeclaration?")
    public FunctionOrValueDeclaration getParameterDeclaration(@Name(value="name") @TypeInfo(value="ceylon.language::String") String var1);

    @Ignore
    public <Return, Arguments extends Sequential<? extends Object>> Object apply(TypeDescriptor var1, TypeDescriptor var2);

    @DocAnnotation$annotation$(description="Applies the given closed type arguments to this function declaration in order to obtain a function model. \nSee [this code sample](#toplevel-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Return` or `Arguments` type arguments are not compatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed type argument values are not compatible with the actual result's type parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies the given closed type arguments to this function declaration in order to obtain a function model. \nSee [this code sample](#toplevel-sample) for an example on how to use this."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Return` or `Arguments` type arguments are not compatible with the actual result."}), @Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed type argument values are not compatible with the actual result's type parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::FunctionModel<Return,Arguments>&ceylon.language.meta.model::Applicable<Return,Arguments>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Return", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Arguments", variance=Variance.NONE, satisfies={"ceylon.language::Anything[]"}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    public <Return, Arguments extends Sequential<? extends Object>> Object apply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var3);

    @Ignore
    public <Container, Return, Arguments extends Sequential<? extends Object>> Object memberApply(TypeDescriptor var1, TypeDescriptor var2, TypeDescriptor var3, Type<? extends Object> var4);

    @DocAnnotation$annotation$(description="Applies the given closed container type and type arguments to this method declaration in order to obtain a method model. \nSee [this code sample](#member-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Container`, `Return` or `Arguments` type arguments are not compatible with the actual result."), @ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CTypeApplicationException", when="If the specified closed container type or type argument values are not compatible with the actual result's container type or type parameters.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies the given closed container type and type arguments to this method declaration in order to obtain a method model. \nSee [this code sample](#member-sample) for an example on how to use this."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Container`, `Return` or `Arguments` type arguments are not compatible with the actual result."}), @Annotation(value="throws", arguments={"TypeApplicationException", "If the specified closed container type or type argument values are not compatible with the actual result's container type or type parameters."})})
    @TypeInfo(value="ceylon.language.meta.model::FunctionModel<Return,Arguments>&ceylon.language.meta.model::Qualified<ceylon.language.meta.model::FunctionModel<Return,Arguments>,Container>", erased=true)
    @TypeParameters(value={@TypeParameter(value="Container", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing"), @TypeParameter(value="Return", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Arguments", variance=Variance.NONE, satisfies={"ceylon.language::Anything[]"}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    public <Container, Return, Arguments extends Sequential<? extends Object>> Object memberApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Ignore TypeDescriptor var3, @Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") Type<? extends Object> var4, @Name(value="typeArguments") @Sequenced @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var5);

    @Ignore
    public Object invoke();

    @Ignore
    public Sequential<? extends Type<? extends Object>> invoke$typeArguments();

    @Ignore
    public Object invoke(Sequential<? extends Type<? extends Object>> var1);

    @DocAnnotation$annotation$(description="Invokes the underlying toplevel function, by applying the specified type arguments and value arguments.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified type or value arguments are not compatible with this toplevel function.")})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Invokes the underlying toplevel function, by applying the specified type arguments and value arguments."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified type or value arguments are not compatible with this toplevel function."})})
    @TypeInfo(value="ceylon.language::Anything")
    public Object invoke(@Name(value="typeArguments") @Defaulted @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var1, @Name(value="arguments") @Sequenced @TypeInfo(value="ceylon.language::Anything[]") Sequential<? extends Object> var2);

    @Ignore
    public Object memberInvoke(Object var1);

    @Ignore
    public Sequential<? extends Type<? extends Object>> memberInvoke$typeArguments(Object var1);

    @Ignore
    public Object memberInvoke(Object var1, Sequential<? extends Type<? extends Object>> var2);

    @DocAnnotation$annotation$(description="Invokes the underlying method, by applying the specified type arguments and value arguments.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified container, type or value arguments are not compatible with this method.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Invokes the underlying method, by applying the specified type arguments and value arguments."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified container, type or value arguments are not compatible with this method."})})
    @TypeInfo(value="ceylon.language::Anything")
    public Object memberInvoke(@Name(value="container") @TypeInfo(value="ceylon.language::Object") Object var1, @Name(value="typeArguments") @Defaulted @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Anything>[]") Sequential<? extends Type<? extends Object>> var2, @Name(value="arguments") @Sequenced @TypeInfo(value="ceylon.language::Anything[]") Sequential<? extends Object> var3);
}

