/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Character;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Float;
import ceylon.language.Integer;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.maximumIntegerExponent_;
import ceylon.language.parseFloatExponent_;
import ceylon.language.parseInteger_;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8)
@Method
public final class parseFloat_ {
    private parseFloat_() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DocAnnotation$annotation$(description="The [[Float]] value of the given \n[[string representation|string]] of a decimal floating \npoint number, or `null` if the string does not represent a \ndecimal floating point number.\n\nIf the given string representation contains more digits\nthan can be represented by a `Float`, then the least \nsignificant digits are ignored.\n\nThe syntax accepted by this method is the same as the \nsyntax for a `Float` literal in the Ceylon language \nexcept that it may optionally begin with a sign \ncharacter (`+` or `-`) and may not contain grouping \nunderscore characters.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::FformatFloat", "::1.2.2:ceylon.language::FparseInteger"})})
    @TagsAnnotation$annotation$(tags={"Numbers", "Basic types"})
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The [[Float]] value of the given \n[[string representation|string]] of a decimal floating \npoint number, or `null` if the string does not represent a \ndecimal floating point number.\n\nIf the given string representation contains more digits\nthan can be represented by a `Float`, then the least \nsignificant digits are ignored.\n\nThe syntax accepted by this method is the same as the \nsyntax for a `Float` literal in the Ceylon language \nexcept that it may optionally begin with a sign \ncharacter (`+` or `-`) and may not contain grouping \nunderscore characters."}), @Annotation(value="see", arguments={"formatFloat", "parseInteger"}), @Annotation(value="tagged", arguments={"Numbers", "Basic types"})})
    @TypeInfo(value="ceylon.language::Float?")
    public static Float parseFloat(@Name(value="string") @TypeInfo(value="ceylon.language::String") java.lang.String string) {
        Integer unsigned$1479;
        long exponent;
        String rest;
        java.lang.String fractionalPart;
        java.lang.String wholePart;
        java.lang.String unsignedPart;
        long sign;
        if (String.startsWith(string, String.instance("-"))) {
            sign = -1L;
            unsignedPart = ((String)String.instance(string).spanFrom(Integer.instance(1L))).toString();
        } else if (String.startsWith(string, String.instance("+"))) {
            sign = 1L;
            unsignedPart = ((String)String.instance(string).spanFrom(Integer.instance(1L))).toString();
        } else {
            sign = 1L;
            unsignedPart = string;
        }
        Integer dot$1462 = String.firstOccurrence(unsignedPart, 46);
        if (dot$1462 != null) {
            long dot$1466 = dot$1462.longValue();
            wholePart = ((String)String.instance(unsignedPart).spanTo(Integer.instance(dot$1466 - 1L))).toString();
            java.lang.String afterWholePart = ((String)String.instance(unsignedPart).spanFrom(Integer.instance(dot$1466 + 1L))).toString();
            Integer mag$1468 = String.firstIndexWhere(afterWholePart, (Callable<? extends Boolean>)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple(false, false, -1, Character.$TypeDescriptor$), "Boolean(Character)", -1){

                @Override
                @Ignore
                public Boolean $call$(Object $param$0) {
                    Character $instance$ = (Character)$param$0;
                    return Boolean.instance($instance$.getLetter());
                }
            });
            if (mag$1468 != null) {
                long mag$1469 = mag$1468.longValue();
                fractionalPart = ((String)String.instance(afterWholePart).spanTo(Integer.instance(mag$1469 - 1L))).toString();
                rest = (String)String.instance(afterWholePart).spanFrom(Integer.instance(mag$1469));
            } else {
                fractionalPart = afterWholePart;
                rest = null;
            }
        } else {
            Integer mag$1464 = String.firstIndexWhere(unsignedPart, (Callable<? extends Boolean>)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple(false, false, -1, Character.$TypeDescriptor$), "Boolean(Character)", -1){

                @Override
                @Ignore
                public Boolean $call$(Object $param$0) {
                    Character $instance$ = (Character)$param$0;
                    return Boolean.instance($instance$.getLetter());
                }
            });
            if (mag$1464 != null) {
                long mag$1465 = mag$1464.longValue();
                wholePart = ((String)String.instance(unsignedPart).spanTo(Integer.instance(mag$1465 - 1L))).toString();
                rest = (String)String.instance(unsignedPart).spanFrom(Integer.instance(mag$1465));
            } else {
                wholePart = unsignedPart;
                rest = null;
            }
            fractionalPart = "0";
        }
        if (!String.every(wholePart, (Callable<? extends Boolean>)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple(false, false, -1, Character.$TypeDescriptor$), "Boolean(Character)", -1){

            @Override
            @Ignore
            public Boolean $call$(Object $param$0) {
                Character $instance$ = (Character)$param$0;
                return Boolean.instance($instance$.getDigit());
            }
        }) || !String.every(fractionalPart, (Callable<? extends Boolean>)new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.tuple(false, false, -1, Character.$TypeDescriptor$), "Boolean(Character)", -1){

            @Override
            @Ignore
            public Boolean $call$(Object $param$0) {
                Character $instance$ = (Character)$param$0;
                return Boolean.instance($instance$.getDigit());
            }
        })) {
            return null;
        }
        java.lang.String usableWholePart = ((String)String.instance(wholePart).measure(Integer.instance(0L), maximumIntegerExponent_.get_())).toString();
        java.lang.String usableFractionalPart = ((String)String.instance(fractionalPart).measure(Integer.instance(0L), maximumIntegerExponent_.get_() - String.getSize(usableWholePart))).toString();
        java.lang.String digits = usableWholePart + usableFractionalPart;
        long shift = String.getEmpty(usableFractionalPart) ? String.getSize(usableWholePart) - String.getSize(wholePart) : String.getSize(usableFractionalPart);
        String rest$1472 = rest;
        if (rest$1472 != null) {
            java.lang.String rest$1474 = rest$1472.toString();
            Integer magnitude$1476 = parseFloatExponent_.parseFloatExponent(rest$1474);
            if (magnitude$1476 == null) return null;
            long magnitude$1477 = magnitude$1476.longValue();
            exponent = magnitude$1477 - shift;
        } else {
            String rest$1473 = rest$1472;
            exponent = -shift;
        }
        if ((unsigned$1479 = parseInteger_.parseInteger(digits)) == null) return null;
        long unsigned$1480 = unsigned$1479.longValue();
        double signed = unsigned$1480 == 0L ? 0.0 * Integer.getFloat(sign) : Integer.getNearestFloat(sign * unsigned$1480);
        long exponentMagnitude = Integer.getMagnitude(exponent);
        if (exponentMagnitude == 0L) {
            return Float.instance(signed);
        }
        if (exponentMagnitude > maximumIntegerExponent_.get_()) return Float.instance(signed * Float.power(10.0, exponent));
        long scale = Integer.power(10L, exponentMagnitude);
        return Float.instance(exponent < 0L ? signed / (double)scale : signed * (double)scale);
    }
}

