/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AssertionError;
import ceylon.language.Character;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.maxRadix_;
import ceylon.language.minRadix_;
import ceylon.language.parseDigit_;
import ceylon.language.parseIntegerExponent_;
import ceylon.language.runtime_;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;

@Ceylon(major=8)
@Method
public final class parseInteger_ {
    private parseInteger_() {
    }

    @Ignore
    public static Integer parseInteger(java.lang.String string) {
        long $ceylontmp$radix$1506 = parseInteger_.parseInteger$radix(string);
        return parseInteger_.parseInteger(string, $ceylontmp$radix$1506);
    }

    @Ignore
    public static final long parseInteger$radix(java.lang.String string) {
        return 10L;
    }

    @DocAnnotation$annotation$(description="The [[Integer]] value of the given \n[[string representation|string]] of an integer value in the \nbase given by [[radix]], or `null` if the string does not \nrepresent an integer in that base, or if the mathematical \ninteger it represents is too large in magnitude to be \nrepresented by an instance of the class `Integer`.\n\nThe syntax accepted by this function is the same as the \nsyntax for an `Integer` literal in the Ceylon language \nexcept that it may optionally begin with a sign character \n(`+` or `-`) and may not contain grouping underscore \ncharacters.\n\nThe given `radix` specifies the base of the string \nrepresentation. The list of available digits starts from \n`0` to `9`, followed by `a` to `z`. When parsing in a \nspecific base, the first `radix` digits from the available \ndigits list is used. This function is not case sensitive; \n`a` and `A` both correspond to the digit `a` whose decimal \nvalue is `10`.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language::CAssertionError", when="if [[radix]] is not between [[minRadix]] and \n[[maxRadix]]")})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.2.2:ceylon.language::FformatInteger", "::1.2.2:ceylon.language::FparseFloat"})})
    @TagsAnnotation$annotation$(tags={"Numbers", "Basic types"})
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The [[Integer]] value of the given \n[[string representation|string]] of an integer value in the \nbase given by [[radix]], or `null` if the string does not \nrepresent an integer in that base, or if the mathematical \ninteger it represents is too large in magnitude to be \nrepresented by an instance of the class `Integer`.\n\nThe syntax accepted by this function is the same as the \nsyntax for an `Integer` literal in the Ceylon language \nexcept that it may optionally begin with a sign character \n(`+` or `-`) and may not contain grouping underscore \ncharacters.\n\nThe given `radix` specifies the base of the string \nrepresentation. The list of available digits starts from \n`0` to `9`, followed by `a` to `z`. When parsing in a \nspecific base, the first `radix` digits from the available \ndigits list is used. This function is not case sensitive; \n`a` and `A` both correspond to the digit `a` whose decimal \nvalue is `10`."}), @Annotation(value="throws", arguments={"AssertionError", "if [[radix]] is not between [[minRadix]] and \n[[maxRadix]]"}), @Annotation(value="see", arguments={"formatInteger", "parseFloat"}), @Annotation(value="tagged", arguments={"Numbers", "Basic types"})})
    @TypeInfo(value="ceylon.language::Integer?")
    public static Integer parseInteger(@Name(value="string") @TypeInfo(value="ceylon.language::String") @DocAnnotation$annotation$(description="The string representation to parse.") @Annotations(value={@Annotation(value="doc", arguments={"The string representation to parse."})}) java.lang.String string, @Name(value="radix") @Defaulted @TypeInfo(value="ceylon.language::Integer") @DocAnnotation$annotation$(description="The base, between [[minRadix]] and [[maxRadix]] \ninclusive.") @Annotations(value={@Annotation(value="doc", arguments={"The base, between [[minRadix]] and [[maxRadix]] \ninclusive."})}) long radix) {
        long start;
        boolean negative;
        long middle$1485 = radix;
        if (!(minRadix_.get_() <= middle$1485 && middle$1485 <= maxRadix_.get_())) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "minRadix <= radix <= maxRadix");
        }
        long max = runtime_.get_().getMinIntegerValue() / radix;
        Character $char$1487 = String.getFirst(string);
        if ($char$1487 != null) {
            int $char$1488 = $char$1487.intValue();
            if ($char$1488 == 45) {
                negative = true;
                start = 1L;
            } else if ($char$1488 == 43) {
                negative = false;
                start = 1L;
            } else {
                negative = false;
                start = 0L;
            }
        } else {
            return null;
        }
        long limit = negative ? runtime_.get_().getMinIntegerValue() : -runtime_.get_().getMaxIntegerValue();
        long length = String.getSize(string);
        long result = 0L;
        long digitIndex = 0L;
        long index = start;
        while (index < length) {
            Integer digit$1497;
            Character ch$1492 = null;
            ch$1492 = String.getFromFirst(string, index);
            if (ch$1492 == null) {
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "exists ch = string.getFromFirst(index)");
            }
            int ch$1493 = ch$1492.intValue();
            if (index + 1L == length && radix == 10L) {
                Character $ceylontmp$1495 = Character.instance(ch$1493);
                if (String.instance("kMGTP").contains($ceylontmp$1495)) {
                    Integer exp$1502 = parseIntegerExponent_.parseIntegerExponent(ch$1493);
                    if (exp$1502 != null) {
                        long exp$1503 = exp$1502.longValue();
                        long magnitude = Integer.power(10L, exp$1503);
                        if (limit / magnitude < result) {
                            result *= magnitude;
                            break;
                        }
                        return null;
                    }
                    return null;
                }
            }
            if ((digit$1497 = parseDigit_.parseDigit(ch$1493, radix)) != null) {
                long digit$1498 = digit$1497.longValue();
                if (result < max) {
                    return null;
                }
                if ((result *= radix) < limit + digit$1498) {
                    return null;
                }
                result -= digit$1498;
            } else {
                return null;
            }
            ++index;
            ++digitIndex;
        }
        if (digitIndex == 0L) {
            return null;
        }
        return Integer.instance(negative ? result : -result);
    }
}

