/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.serialization;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.Anything;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.Finished;
import ceylon.language.Iterable;
import ceylon.language.Iterator;
import ceylon.language.Object;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.Tuple;
import ceylon.language.impl.ElementImpl;
import ceylon.language.impl.MemberImpl;
import ceylon.language.meta.declaration.ValueDeclaration;
import ceylon.language.meta.model.ClassModel;
import ceylon.language.meta.typeLiteral_;
import ceylon.language.meta.type_;
import ceylon.language.serialization.DeserializationContext;
import ceylon.language.serialization.DeserializationException;
import ceylon.language.serialization.NativeDeque;
import ceylon.language.serialization.NativeMap;
import ceylon.language.serialization.Partial;
import ceylon.language.serialization.PartialImpl;
import ceylon.language.serialization.ReachableReference;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;

@Ceylon(major=8)
@DocAnnotation$annotation$(description="Implementation of [[DeserializationContext]] using a few native helper classes.")
@Annotations(value={@Annotation(value="doc", arguments={"Implementation of [[DeserializationContext]] using a few native helper classes."})})
@SatisfiedTypes(value={"ceylon.language.serialization::DeserializationContext<Id>"})
@TypeParameters(value={@TypeParameter(value="Id", variance=Variance.NONE, satisfies={"ceylon.language::Object"}, caseTypes={})})
class DeserializationContextImpl<Id>
implements ReifiedType,
DeserializationContext<Id>,
Serializable {
    @Ignore
    private final TypeDescriptor $reified$Id;
    @Ignore
    private final NativeMap<Id, java.lang.Object> instances;
    @Ignore
    private final NativeMap<Entry<? extends java.lang.Object, ? extends String>, java.lang.Object> memberTypeCache;

    DeserializationContextImpl(@Ignore TypeDescriptor $reified$Id) {
        this.$reified$Id = $reified$Id;
        this.instances = new NativeMap($reified$Id, Anything.$TypeDescriptor$);
        this.memberTypeCache = new NativeMap(TypeDescriptor.klass(Entry.class, Object.$TypeDescriptor$, String.$TypeDescriptor$), Object.$TypeDescriptor$);
    }

    @DocAnnotation$annotation$(description="The `Item` in the instances map is either a `Partial` or the actual instance\nthat's not ambiguous because `Partial` never leaks, so it's impossible\nfor a client to use the API to instantiate a `Partial`\nthey can only end up in the map due to our implementation.\n")
    @Annotations(value={@Annotation(value="doc", arguments={"The `Item` in the instances map is either a `Partial` or the actual instance\nthat's not ambiguous because `Partial` never leaks, so it's impossible\nfor a client to use the API to instantiate a `Partial`\nthey can only end up in the map due to our implementation.\n"})})
    @TypeInfo(value="ceylon.language.serialization::NativeMap<Id,ceylon.language::Anything>")
    private final NativeMap<Id, java.lang.Object> getInstances$priv$() {
        return this.instances;
    }

    @DocAnnotation$annotation$(description="a cache of \"attribute\" (represented as a TypeDescriptor and an attribute name)\nto its type")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"a cache of \"attribute\" (represented as a TypeDescriptor and an attribute name)\nto its type"})})
    @TypeInfo(value="ceylon.language.serialization::NativeMap<ceylon.language::Object->ceylon.language::String,ceylon.language::Object>")
    public final NativeMap<Entry<? extends java.lang.Object, ? extends String>, java.lang.Object> getMemberTypeCache() {
        return this.memberTypeCache;
    }

    @DocAnnotation$annotation$(description="Get the [[Partial]] or instance with the given id")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Get the [[Partial]] or instance with the given id"})})
    @TypeInfo(value="ceylon.language::Anything")
    public final java.lang.Object leakInstance(@Name(value="id") @TypeInfo(value="Id") Id id) {
        return this.getInstances$priv$().get(id);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public final java.lang.Object attribute(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="attribute") @TypeInfo(value="ceylon.language.meta.declaration::ValueDeclaration") ValueDeclaration attribute, @Name(value="attributeValueId") @TypeInfo(value="Id") Id attributeValueId) {
        this.attributeOrElement$priv$(instanceId, new MemberImpl(attribute), attributeValueId);
        return null;
    }

    @DocAnnotation$annotation$(description="A [[DeserializationException]] to day that the instance with the given id has already been instantiated.")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"A [[DeserializationException]] to day that the instance with the given id has already been instantiated."})})
    @TypeInfo(value="ceylon.language.serialization::DeserializationException")
    public final DeserializationException alreadyComplete(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        return new DeserializationException("instance referred to by id " + instanceId.toString() + " already complete.");
    }

    @DocAnnotation$annotation$(description="Get or create the [[Partial]] for `instanceId`; \nadd the given `attributeValueId` to its partial state.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.2.2:ceylon.language:serialization:CDeserializationException", when="If the `instanceId` corresponds to a reconstructed \ninstance or to a partial that's already been instantiated")})
    @Annotations(value={@Annotation(value="doc", arguments={"Get or create the [[Partial]] for `instanceId`; \nadd the given `attributeValueId` to its partial state."}), @Annotation(value="throws", arguments={"DeserializationException", "If the `instanceId` corresponds to a reconstructed \ninstance or to a partial that's already been instantiated"})})
    @TypeInfo(value="ceylon.language::Anything")
    private final void attributeOrElement$priv$(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="attributeOrIndex") @TypeInfo(value="ceylon.language.serialization::ReachableReference") ReachableReference attributeOrIndex, @Name(value="attributeValueId") @TypeInfo(value="Id") Id attributeValueId) {
        Partial referring;
        java.lang.Object sel$1537 = this.getInstances$priv$().get(instanceId);
        if (sel$1537 == null) {
            java.lang.Object r$1541 = sel$1537;
            PartialImpl p = new PartialImpl(instanceId);
            this.getInstances$priv$().put(instanceId, p);
            referring = p;
        } else if (sel$1537 instanceof Partial) {
            Partial r$1539 = (Partial)sel$1537;
            referring = r$1539;
            if (referring.getInstantiated()) {
                throw this.alreadyComplete(instanceId);
            }
        } else {
            java.lang.Object r$1538 = sel$1537;
            throw this.alreadyComplete(instanceId);
        }
        referring.addState(attributeOrIndex, attributeValueId);
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public final java.lang.Object element(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="index") @TypeInfo(value="ceylon.language::Integer") long index, @Name(value="elementValueId") @TypeInfo(value="Id") Id elementValueId) {
        this.attributeOrElement$priv$(instanceId, new ElementImpl(index), elementValueId);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public final java.lang.Object instance(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="clazz") @TypeInfo(value="ceylon.language.meta.model::ClassModel<ceylon.language::Anything,ceylon.language::Nothing>", erased=true) ClassModel clazz) {
        if (!clazz.getDeclaration().getSerializable()) {
            throw new DeserializationException("not serializable: " + clazz.toString());
        }
        this.getOrCreatePartial$priv$(instanceId).setClazz(clazz);
        return null;
    }

    @DocAnnotation$annotation$(description="Get or create a [[Partial]] for the given `instanceId`.")
    @Annotations(value={@Annotation(value="doc", arguments={"Get or create a [[Partial]] for the given `instanceId`."})})
    @TypeInfo(value="ceylon.language.serialization::Partial")
    private final Partial getOrCreatePartial$priv$(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        Partial partial;
        java.lang.Object sel$1543 = this.getInstances$priv$().get(instanceId);
        if (sel$1543 == null) {
            java.lang.Object r$1546 = sel$1543;
            PartialImpl p = new PartialImpl(instanceId);
            this.getInstances$priv$().put(instanceId, p);
            partial = p;
        } else if (sel$1543 instanceof Partial) {
            Partial r$1545;
            partial = r$1545 = (Partial)sel$1543;
        } else {
            java.lang.Object r$1544 = sel$1543;
            throw this.alreadyComplete(instanceId);
        }
        return partial;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public final java.lang.Object memberInstance(@Name(value="containerId") @TypeInfo(value="Id") Id containerId, @Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        java.lang.Object container;
        java.lang.Object sel$1547 = this.getInstances$priv$().get(containerId);
        if (sel$1547 == null) {
            java.lang.Object r$1549 = sel$1547;
            PartialImpl p = new PartialImpl(containerId);
            this.getInstances$priv$().put(containerId, p);
            container = p;
        } else {
            java.lang.Object r$1548;
            container = r$1548 = sel$1547;
        }
        this.getOrCreatePartial$priv$(instanceId).setContainer(container);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    public final java.lang.Object instanceValue(@Name(value="instanceId") @TypeInfo(value="Id") Id instanceId, @Name(value="instanceValue") @TypeInfo(value="ceylon.language::Anything") java.lang.Object instanceValue) {
        this.getInstances$priv$().put(instanceId, instanceValue);
        return null;
    }

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L)
    @TypeInfo(value="Instance")
    @TypeParameters(value={@TypeParameter(value="Instance", variance=Variance.NONE, satisfies={}, caseTypes={})})
    public final <Instance> Instance reconstruct(@Ignore TypeDescriptor $reified$Instance, @Name(value="instanceId") @TypeInfo(value="Id") Id instanceId) {
        NativeDeque deque = new NativeDeque();
        java.lang.Object root = this.getInstances$priv$().get(instanceId);
        if (root == null) {
            if (this.getInstances$priv$().contains(instanceId)) {
                Instance r$1553 = null;
                r$1553 = null;
                if (!Util.isReified(null, $reified$Instance)) {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Instance r=null");
                }
                Instance r$1554 = r$1553;
                return r$1554;
            }
            throw new DeserializationException("unknown id: " + instanceId.toString() + ".");
        }
        deque.pushFront(this.getInstances$priv$().get(instanceId));
        while (!deque.getEmpty()) {
            java.lang.Object r = deque.popFront();
            java.lang.Object sel$1555 = r;
            if (sel$1555 == null) {
                java.lang.Object r$1575 = sel$1555;
                throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
            }
            if (sel$1555 instanceof Partial) {
                Iterator<? extends java.lang.Object> referredId$iterator$$1563;
                Partial container$1560;
                java.lang.Object container$1559;
                Partial r$1557 = (Partial)sel$1555;
                if (r$1557.getMember() && (container$1559 = r$1557.getContainer()) instanceof Partial && !(container$1560 = (Partial)container$1559).getInstantiated()) {
                    deque.pushFront(r$1557);
                    deque.pushFront(container$1560);
                    continue;
                }
                if (!r$1557.getInstantiated()) {
                    r$1557.instantiate();
                }
                Iterable<? extends java.lang.Object, ? extends java.lang.Object> iterable$1570 = r$1557.getRefersTo();
                boolean isArray$1571 = iterable$1570 instanceof Array;
                boolean isTuple$1572 = iterable$1570 instanceof Tuple && ((Tuple)iterable$1570).$getArray$() != null;
                java.lang.Object elem$1562 = null;
                int i$1573 = 0;
                int length$1574 = isArray$1571 || isTuple$1572 ? (int)iterable$1570.getSize() : 0;
                Iterator<? extends java.lang.Object> iterator = referredId$iterator$$1563 = isTuple$1572 || isArray$1571 ? null : iterable$1570.iterator();
                while (isTuple$1572 || isArray$1571 ? i$1573 < length$1574 : !((elem$1562 = referredId$iterator$$1563.next()) instanceof Finished)) {
                    Partial referred$1569;
                    if (isArray$1571 || isTuple$1572) {
                        elem$1562 = iterable$1570.getFromFirst(i$1573++);
                    }
                    java.lang.Object referredId = elem$1562;
                    java.lang.Object referredId$1565 = null;
                    referredId$1565 = referredId;
                    if (!Util.isReified(referredId$1565, this.$reified$Id)) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Id referredId");
                    }
                    java.lang.Object referredId$1566 = referredId$1565;
                    java.lang.Object referred = this.getInstances$priv$().get(referredId$1566);
                    java.lang.Object referred$1568 = referred;
                    if (!(referred$1568 instanceof Partial) || (referred$1569 = (Partial)referred$1568).getInstantiated()) continue;
                    deque.pushFront(referred$1569);
                }
                continue;
            }
            java.lang.Object r$1556 = sel$1555;
        }
        deque.pushFront(this.getInstances$priv$().get(instanceId));
        while (!deque.getEmpty()) {
            java.lang.Object sel$1577 = deque.popFront();
            if (sel$1577 instanceof Partial) {
                Partial container$1600;
                java.lang.Object container$1599;
                Iterator<? extends java.lang.Object> referredId$iterator$$1586;
                Partial container$1583;
                java.lang.Object container$1582;
                Partial r$1579 = (Partial)sel$1577;
                if (r$1579.getMember() && (container$1582 = r$1579.getContainer()) instanceof Partial && !(container$1583 = (Partial)container$1582).getInitialized()) {
                    deque.pushFront(r$1579);
                    deque.pushFront(container$1583);
                    continue;
                }
                if (r$1579.getInitialized()) continue;
                Iterable<? extends java.lang.Object, ? extends java.lang.Object> iterable$1593 = r$1579.getRefersTo();
                boolean isArray$1594 = iterable$1593 instanceof Array;
                boolean isTuple$1595 = iterable$1593 instanceof Tuple && ((Tuple)iterable$1593).$getArray$() != null;
                java.lang.Object elem$1585 = null;
                int i$1596 = 0;
                int length$1597 = isArray$1594 || isTuple$1595 ? (int)iterable$1593.getSize() : 0;
                Iterator<? extends java.lang.Object> iterator = referredId$iterator$$1586 = isTuple$1595 || isArray$1594 ? null : iterable$1593.iterator();
                while (isTuple$1595 || isArray$1594 ? i$1596 < length$1597 : !((elem$1585 = referredId$iterator$$1586.next()) instanceof Finished)) {
                    Partial referred$1592;
                    if (isArray$1594 || isTuple$1595) {
                        elem$1585 = iterable$1593.getFromFirst(i$1596++);
                    }
                    java.lang.Object referredId = elem$1585;
                    java.lang.Object referredId$1588 = null;
                    referredId$1588 = referredId;
                    if (!Util.isReified(referredId$1588, this.$reified$Id)) {
                        throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "is Id referredId");
                    }
                    java.lang.Object referredId$1589 = referredId$1588;
                    java.lang.Object referred = this.getInstances$priv$().get(referredId$1589);
                    java.lang.Object referred$1591 = referred;
                    if (!(referred$1591 instanceof Partial) || (referred$1592 = (Partial)referred$1591).getInitialized()) continue;
                    deque.pushFront(referred$1592);
                }
                if (r$1579.getMember() && (container$1599 = r$1579.getContainer()) instanceof Partial && !(container$1600 = (Partial)container$1599).getInitialized()) {
                    deque.pushFront(container$1600);
                }
                r$1579.initialize(this.$reified$Id, this);
                continue;
            }
            java.lang.Object r$1578 = sel$1577;
        }
        java.lang.Object sel$1601 = this.getInstances$priv$().get(instanceId);
        if (sel$1601 instanceof Partial) {
            Partial r$1607 = (Partial)sel$1601;
            java.lang.Object result = r$1607.instance();
            java.lang.Object result$1609 = result;
            if (Util.isReified(result$1609, $reified$Instance)) {
                java.lang.Object result$1610 = result$1609;
                this.getInstances$priv$().put(instanceId, result$1610);
                return (Instance)result$1610;
            }
            throw new DeserializationException("instance with id " + instanceId.toString() + " has class " + type_.type(Anything.$TypeDescriptor$, result).toString() + " not assignable to given type " + typeLiteral_.typeLiteral($reified$Instance).toString());
        }
        java.lang.Object r$1602 = sel$1601;
        java.lang.Object r$1604 = r$1602;
        if (Util.isReified(r$1604, $reified$Instance)) {
            java.lang.Object r$1606 = r$1604;
            return (Instance)r$1606;
        }
        java.lang.Object r$1605 = r$1604;
        throw new DeserializationException("instance with id " + instanceId.toString() + " has class " + type_.type(Anything.$TypeDescriptor$, r$1605).toString() + " not assignable to given type " + typeLiteral_.typeLiteral($reified$Instance).toString());
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return TypeDescriptor.klass(DeserializationContextImpl.class, this.$reified$Id);
    }
}

