/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules;

import ceylon.modules.CeylonRuntimeException;
import ceylon.modules.SecurityActions;
import ceylon.modules.spi.Argument;
import ceylon.modules.spi.ArgumentType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Configuration {
    public String module;
    public String[] arguments;
    public String cwd;
    public List<String> repositories = new LinkedList<String>();
    public String systemRepository;
    public String cacheRepository;
    public String overrides;
    public boolean noDefaultRepositories;
    public String run;
    public String src;
    public String verbose;
    public boolean autoExportMavenDependencies;
    public boolean offline;
    public boolean upgradeDist = true;
    public String executable;
    public boolean cacheContent;
    public Map<String, String> impl = new HashMap<String, String>();

    public int setArgument(String name, ArgumentType type, String[] values, int i) {
        Argument argument = Argument.forArgumentName(name, type);
        if (argument == null) {
            throw new CeylonRuntimeException("Unknown argument: " + name);
        }
        if (i + argument.getRequiredValues() >= values.length) {
            throw new CeylonRuntimeException("Missing argument value: " + name);
        }
        int arg = i + 1;
        switch (argument) {
            case EXECUTABLE: {
                this.executable = values[arg];
                break;
            }
            case CACHE_CONTENT: {
                this.cacheContent = true;
                break;
            }
            case IMPLEMENTATION: {
                this.impl.put(values[arg], values[arg + 1]);
                break;
            }
            case SOURCE: {
                this.src = values[arg];
                break;
            }
            case RUN: {
                this.run = values[arg];
                break;
            }
            case CWD: {
                this.cwd = values[arg];
                break;
            }
            case SYSTEM_REPOSITORY: {
                this.systemRepository = values[arg];
                break;
            }
            case CACHE_REPOSITORY: {
                this.cacheRepository = values[arg];
                break;
            }
            case OVERRIDES: 
            case MAVEN_OVERRIDES: {
                this.overrides = values[arg];
                break;
            }
            case DOWNGRADE_DIST: {
                this.upgradeDist = false;
                break;
            }
            case NO_DEFAULT_REPOSITORIES: {
                this.noDefaultRepositories = true;
                break;
            }
            case REPOSITORY: {
                this.repositories.add(values[arg]);
                break;
            }
            case VERBOSE: {
                this.verbose = values[arg];
                break;
            }
            case AUTO_EXPORT_MAVEN_DEPENDENCIES: {
                this.autoExportMavenDependencies = true;
                break;
            }
            case OFFLINE: {
                this.offline = true;
                break;
            }
            case HELP: {
                this.printUsage(0);
                break;
            }
            case VERSION: {
                this.printVersion();
            }
        }
        return i + argument.getRequiredValues();
    }

    private void printVersion() {
        System.out.println("Version: ceylon 1.2.2 13ebb05 (Charming But Irrational)");
        SecurityActions.exit(0);
    }

    private void printUsage(int exitCode) {
        System.err.print("Usage: ceylon [options...] moduleName/version [args...]\n\n -run qualified-name: Name of a class or toplevel method to run\n                      (default: use the module descriptor)\n -rep path:           Module repository path (can be specified more than once)\n");
        System.err.print(" -src path:           Source path (default: source)\n -verbose flags:      Output messages about what the runtime is doing\n -help:               Prints help usage\n -version:            Prints version number\n moduleName/version:  Module name and version to run (required)\n");
        SecurityActions.exit(exitCode);
    }

    public void check() {
        if (this.executable == null || this.executable.isEmpty()) {
            System.err.println("Error: Missing +executable parameter\n");
            this.printUsage(1);
        }
        if (this.module == null || this.module.isEmpty()) {
            System.err.println("Error: Missing module name\n");
            this.printUsage(1);
        }
    }
}

