/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(final String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
        }
        return System.getProperty(key);
    }

    static void exit(final int status) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.exit(status);
                    return null;
                }
            });
        } else {
            System.exit(status);
        }
    }

    static <T> T instantiate(final Class<T> expectedType, final String defaultImpl) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<T>(){

                @Override
                public T run() throws Exception {
                    return SecurityActions.instantiateInternal(expectedType, defaultImpl);
                }
            });
        }
        return SecurityActions.instantiateInternal(expectedType, defaultImpl);
    }

    private static <T> T instantiateInternal(Class<T> expectedType, String defaultImpl) throws Exception {
        String impl2 = System.getProperty(expectedType.getName(), defaultImpl);
        ClassLoader cl = expectedType.getClassLoader();
        Class<?> clazz = cl.loadClass(impl2);
        Object result = clazz.newInstance();
        return expectedType.cast(result);
    }
}

