/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.api.compiler;

import ceylon.modules.api.compiler.CompilerAdapter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;

public abstract class AbstractCompilerAdapter
implements CompilerAdapter {
    private String languageSuffix;

    protected AbstractCompilerAdapter(String languageSuffix) {
        if (languageSuffix == null) {
            throw new IllegalArgumentException("Null language suffix");
        }
        this.languageSuffix = languageSuffix;
    }

    @Override
    public String languageSuffix() {
        return this.languageSuffix;
    }

    @Override
    public File findSource(File root, String name) {
        File file = new File(root, name + this.languageSuffix);
        return file.exists() ? file : null;
    }

    protected String toPath(String className) {
        return AbstractCompilerAdapter.toPath(className, this.languageSuffix);
    }

    protected static String toPath(String className, String suffix) {
        return className.replace(".", File.separator) + suffix;
    }

    protected static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

