/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.api.runtime;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

final class SecurityActions {
    SecurityActions() {
    }

    static void invokeRun(final Class<?> runClass, final String[] args) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    SecurityActions.invokeRunInternal(runClass, args);
                    return null;
                }
            });
        } else {
            SecurityActions.invokeRunInternal(runClass, args);
        }
    }

    private static void invokeRunInternal(Class<?> runClass, String[] args) throws Exception {
        try {
            Method main = runClass.getDeclaredMethod("main", String[].class);
            main.setAccessible(true);
            String[] sfa = args;
            main.invoke(null, new Object[]{sfa});
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchMethodException(runClass.getName() + "(Void)");
        }
    }

    public static ClassLoader setContextClassLoader(final ClassLoader cl) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(cl);
                    return oldClassLoader;
                }
            });
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        return oldClassLoader;
    }
}

