/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.api.util;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class ModuleVersion
implements Serializable,
Comparable<ModuleVersion> {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = ".";
    private static final String PATTERN = "[a-zA-Z0-9_-]*";
    private static final Pattern QUALIFIER_PATTERN = Pattern.compile("[a-zA-Z0-9_-]*");
    public static final ModuleVersion DEFAULT_VERSION = new ModuleVersion(0, 0, 0);
    private int major;
    private int minor;
    private int micro;
    private String qualifier;

    public static ModuleVersion valueOf(String string) {
        return ModuleVersion.parseVersion(string);
    }

    public ModuleVersion(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public ModuleVersion(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        if (qualifier == null) {
            qualifier = "";
        }
        this.qualifier = qualifier;
        this.validate();
    }

    private ModuleVersion(String version2) {
        int major;
        if (version2 == null) {
            throw new IllegalArgumentException("Null version");
        }
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer st = new StringTokenizer(version2, SEPARATOR, true);
            major = Integer.parseInt(st.nextToken().trim());
            if (st.hasMoreTokens()) {
                st.nextToken();
                minor = Integer.parseInt(st.nextToken().trim());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    micro = Integer.parseInt(st.nextToken().trim());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        qualifier = st.nextToken().trim();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("Invalid version format, too many seperators: " + version2);
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid version format: " + version2);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version format: " + version2, e);
        }
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier;
        this.validate();
    }

    protected void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("negative major: " + this.major);
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("negative minor: " + this.minor);
        }
        if (this.micro < 0) {
            throw new IllegalArgumentException("negative micro: " + this.micro);
        }
        if (!QUALIFIER_PATTERN.matcher(this.qualifier).matches()) {
            throw new IllegalArgumentException("Invalid qualifier, it must be [a-zA-Z0-9_-]*: " + this.qualifier);
        }
    }

    public static ModuleVersion parseVersion(String version2) {
        if (version2 == null) {
            return DEFAULT_VERSION;
        }
        if ((version2 = version2.trim()).length() == 0) {
            return DEFAULT_VERSION;
        }
        return new ModuleVersion(version2);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public void setMicro(int micro) {
        this.micro = micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.major).append(SEPARATOR).append(this.minor).append(SEPARATOR).append(this.micro);
        if (this.qualifier.length() > 0) {
            builder.append(SEPARATOR).append(this.qualifier);
        }
        return builder.toString();
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof ModuleVersion)) {
            return false;
        }
        ModuleVersion other = (ModuleVersion)object;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(ModuleVersion version2) {
        if (version2 == this) {
            return 0;
        }
        int result = this.major - version2.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - version2.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - version2.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(version2.qualifier);
    }
}

