/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.repository;

import ceylon.modules.api.compiler.CompilerAdapterFactory;
import ceylon.modules.jboss.repository.FileEntryResource;
import ceylon.modules.jboss.repository.SourceEntryResource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;

class SourceResourceLoader
implements ResourceLoader {
    private File sourcesRoot;
    private File classesRoot;
    private String rootName;
    private Manifest manifest;

    SourceResourceLoader(File sourcesRoot, File classesRoot, String rootName) {
        if (sourcesRoot == null) {
            throw new IllegalArgumentException("Null sources root");
        }
        if (classesRoot == null) {
            throw new IllegalArgumentException("Null classes root");
        }
        if (rootName == null) {
            throw new IllegalArgumentException("Null root name");
        }
        this.sourcesRoot = sourcesRoot;
        this.classesRoot = classesRoot;
        this.rootName = rootName;
        File manifestFile = new File(sourcesRoot, "META-INF" + File.separator + "MANIFEST.MF");
        this.manifest = SourceResourceLoader.readManifestFile(manifestFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Manifest readManifestFile(File manifestFile) {
        Manifest manifest;
        FileInputStream is = new FileInputStream(manifestFile);
        try {
            manifest = new Manifest(is);
        }
        catch (Throwable throwable) {
            try {
                SourceResourceLoader.safeClose(is);
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
        }
        SourceResourceLoader.safeClose(is);
        return manifest;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public ClassSpec getClassSpec(String name) throws IOException {
        File file = new File(this.classesRoot, name);
        if (file.exists()) {
            return this.toClassSpec(file);
        }
        CompilerAdapterFactory factory = CompilerAdapterFactory.getInstance();
        file = factory.findAndCompile(this.sourcesRoot, name, this.classesRoot);
        return file != null ? this.toClassSpec(file) : null;
    }

    protected ClassSpec toClassSpec(File file) throws IOException {
        long size = file.length();
        ClassSpec spec = new ClassSpec();
        FileInputStream is = new FileInputStream(file);
        try {
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = ((InputStream)is).read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                ((InputStream)is).close();
                spec.setBytes(bytes);
                ClassSpec classSpec = spec;
                return classSpec;
            }
            throw new IOException("Resource is too large to be a valid class file");
        }
        finally {
            SourceResourceLoader.safeClose(is);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static String fileNameOfClass(String className, String typeSuffix) {
        return className.replace('.', '/') + "." + typeSuffix;
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        PackageSpec spec = new PackageSpec();
        Manifest manifest = this.manifest;
        if (manifest == null) {
            return spec;
        }
        Attributes mainAttribute = manifest.getAttributes(name);
        Attributes entryAttribute = manifest.getAttributes(name);
        spec.setSpecTitle(SourceResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_TITLE, entryAttribute, mainAttribute));
        spec.setSpecVersion(SourceResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VERSION, entryAttribute, mainAttribute));
        spec.setSpecVendor(SourceResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VENDOR, entryAttribute, mainAttribute));
        spec.setImplTitle(SourceResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_TITLE, entryAttribute, mainAttribute));
        spec.setImplVersion(SourceResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VERSION, entryAttribute, mainAttribute));
        spec.setImplVendor(SourceResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttribute, mainAttribute));
        if (Boolean.parseBoolean(SourceResourceLoader.getDefinedAttribute(Attributes.Name.SEALED, entryAttribute, mainAttribute))) {
            spec.setSealBase(this.classesRoot.toURI().toURL());
        }
        return spec;
    }

    private static String getDefinedAttribute(Attributes.Name name, Attributes entryAttribute, Attributes mainAttribute) {
        String value;
        String string = value = entryAttribute == null ? null : entryAttribute.getValue(name);
        return value == null ? (mainAttribute == null ? null : mainAttribute.getValue(name)) : value;
    }

    @Override
    public Resource getResource(String name) {
        try {
            File file = new File(this.classesRoot, name);
            if (file.exists()) {
                return new FileEntryResource(name, file, file.toURI().toURL());
            }
            file = new File(this.sourcesRoot, name);
            if (!file.exists()) {
                return null;
            }
            return new SourceEntryResource(name, file, file.toURI().toURL(), this.classesRoot);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getLibrary(String name) {
        return null;
    }

    @Override
    public Collection<String> getPaths() {
        ArrayList<String> paths = new ArrayList<String>();
        this.buildIndex(paths, this.sourcesRoot, "");
        return paths;
    }

    private void buildIndex(List<String> index, File root, String pathBase) {
        for (File file : root.listFiles()) {
            if (!file.isDirectory()) continue;
            index.add(pathBase + file.getName());
            this.buildIndex(index, file, pathBase + file.getName() + File.separator);
        }
    }
}

