/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.jboss.runtime;

import ceylon.modules.jboss.runtime.CeylonModuleLoader;
import ceylon.modules.jboss.runtime.ModuleLocalLoader;
import ceylon.modules.jboss.runtime.Node;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.util.Collections;
import java.util.List;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;

class OnDemandLocalLoader
implements LocalLoader {
    private ModuleIdentifier target;
    private CeylonModuleLoader loader;
    private Node<ArtifactResult> root;

    OnDemandLocalLoader(ModuleIdentifier target, CeylonModuleLoader loader, Node<ArtifactResult> root) {
        this.target = target;
        this.loader = loader;
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LocalLoader doUpdate(String[] tokens) {
        Node<ArtifactResult> current = this.root;
        for (String token : tokens) {
            if ((current = current.getChild(token)) == null) {
                return null;
            }
            Node<ArtifactResult> node = current;
            synchronized (node) {
                ArtifactResult i = current.getValue();
                if (i != null) {
                    current.remove();
                    DependencySpec mds = this.loader.createModuleDependency(i, false);
                    try {
                        Module owner = this.loader.preloadModule(this.target);
                        this.loader.updateModule(owner, mds);
                        Module module = this.loader.loadModule(CeylonModuleLoader.createModuleIdentifier(i));
                        return new ModuleLocalLoader(module);
                    }
                    catch (ModuleLoadException ignored) {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        String[] tokens = name.split("\\.");
        LocalLoader ll = this.doUpdate(tokens);
        return ll != null ? ll.loadClassLocal(name, resolve) : null;
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        String[] tokens = name.split("/");
        LocalLoader ll = this.doUpdate(tokens);
        return ll != null ? ll.loadResourceLocal(name) : Collections.emptyList();
    }

    @Override
    public Package loadPackageLocal(String name) {
        String[] tokens = name.split("\\.");
        LocalLoader ll = this.doUpdate(tokens);
        return ll != null ? ll.loadPackageLocal(name) : null;
    }
}

