/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.CeylondMessages;
import com.redhat.ceylon.ceylondoc.LinkRenderer;
import com.redhat.ceylon.ceylondoc.Markup;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CeylonDoc
extends Markup {
    protected final CeylonDocTool tool;
    protected final Module module;
    protected final Map<Character, String> keyboardShortcuts = new HashMap<Character, String>();

    public CeylonDoc(Module module, CeylonDocTool tool, Writer writer) {
        super(writer);
        this.module = module;
        this.tool = tool;
    }

    protected final LinkRenderer linkRenderer() {
        return new LinkRenderer(this.tool, this.writer, this.getFromObject());
    }

    protected final void writeHeader(String title, String ... additionalCss) throws IOException {
        this.write("<!DOCTYPE html>");
        this.open("html");
        this.open("head");
        this.tag("meta charset='UTF-8'");
        this.around("title", title);
        this.tag("link href='" + this.linkRenderer().getResourceUrl("favicon.ico") + "' rel='shortcut icon'");
        this.tag("link href='" + this.linkRenderer().getResourceUrl("ceylon.css") + "' rel='stylesheet' type='text/css'");
        this.tag("link href='" + this.linkRenderer().getResourceUrl("bootstrap.min.css") + "' rel='stylesheet' type='text/css'");
        this.tag("link href='" + this.linkRenderer().getResourceUrl("ceylondoc.css") + "' rel='stylesheet' type='text/css'");
        this.tag("link href='//fonts.googleapis.com/css?family=Source+Sans+Pro|Inconsolata|Inconsolata:700|PT+Sans|PT+Sans:700' rel='stylesheet' type='text/css'");
        for (String css : additionalCss) {
            if (!css.endsWith(".css")) {
                throw new RuntimeException(CeylondMessages.msg("error.unexpectedAdditionalResource", css));
            }
            this.tag("link href='" + this.linkRenderer().getResourceUrl(css) + "' rel='stylesheet' type='text/css'");
        }
        this.close("head");
        this.open("body");
        if (!Util.isEmpty(this.tool.getHeader())) {
            this.around("header", this.tool.getHeader());
        }
    }

    protected final void writeFooter(String ... additionalJs) throws IOException {
        this.open("script type='text/javascript'");
        this.write("var resourceBaseUrl = '" + this.tool.getResourceUrl(this.getFromObject(), "") + "'");
        this.close("script");
        this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl("jquery-1.8.2.min.js") + "'", new String[0]);
        this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl("bootstrap.min.js") + "'", new String[0]);
        this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl("rainbow.min.js") + "'", new String[0]);
        this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl("ceylon.js") + "'", new String[0]);
        this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl("index.js") + "'", new String[0]);
        this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl("ceylondoc.js") + "'", new String[0]);
        for (String js : additionalJs) {
            if (!js.endsWith(".js")) {
                throw new RuntimeException(CeylondMessages.msg("error.unexpectedAdditionalResource", js));
            }
            this.around("script type='text/javascript' src='" + this.linkRenderer().getResourceUrl(js) + "'", new String[0]);
        }
        this.writeKeyboardShortcuts();
        if (!Util.isEmpty(this.tool.getFooter())) {
            this.around("footer", this.tool.getFooter());
        }
        this.close("body");
        this.close("html");
    }

    protected final void writeNavBar() throws IOException {
        this.open("div class='navbar navbar-inverse navbar-static-top'");
        this.open("div class='navbar-inner'");
        this.open("a class='module-header' href='" + this.linkRenderer().to(this.module).getUrl() + "'");
        this.around("i class='module-logo'", new String[0]);
        this.around("span class='module-label'", "module");
        this.around("span class='module-name'", this.module.getNameAsString());
        this.around("span class='module-version'", this.module.getVersion() + (this.module.isNative() ? " (" + this.module.getNativeBackends().names() + ")" : ""));
        this.close("a");
        this.open("ul class='nav pull-right'");
        this.write("<li class='divider-vertical' />");
        this.writeNavBarExpandAllCollapseAll();
        this.writeNavBarInfoMenu();
        this.close("ul");
        this.open("ul class='nav pull-right'");
        this.write("<li class='divider-vertical' />");
        this.writeNavBarIndexMenu();
        this.writeNavBarSearchMenu();
        this.writeNavBarFilterMenu();
        this.close("ul");
        this.close("div");
        this.close("div");
    }

    protected void writeNavBarExpandAllCollapseAll() throws IOException {
        this.write("<li><a class='expand-all' href='#' title='Expand All [Shortcut: + plus]'><i class='icon-expand-all'></i></a></li>");
        this.write("<li><a class='collapse-all' href='#' title='Collapse All [Shortcut: - minus]'><i class='icon-collapse-all'></i></a></li>");
    }

    protected void writeNavBarInfoMenu() throws IOException {
        this.open("li id='infoDropdown' class='dropdown'");
        this.write("<a href='#' title='Show keyboard shortcuts [Shortcut: ?]' role='button' class='dropdown-toggle' data-toggle='dropdown'><i class='icon-info'></i></a>");
        this.open("ul id='info-dropdown-panel' class='dropdown-menu'");
        this.around("h4", "Keyboard Shortcuts");
        this.write("<li class='divider'></li>");
        this.open("div class='row-fluid'");
        this.open("div id='info-common-shortcuts' class='span6'");
        this.writeKeyboardShortcutInfo("f", "Open filter by tags");
        this.writeKeyboardShortcutInfo("s", "Open search page");
        this.writeKeyboardShortcutInfo("?", "Open this information panel");
        this.close("div");
        this.open("div id='info-expand-collapse-shortcuts' class='span6'");
        this.writeKeyboardShortcutInfo("+", "Expand all");
        this.writeKeyboardShortcutInfo("-", "Collapse all");
        this.close("div");
        this.close("div");
        this.write("<li class='divider'></li>");
        this.open("div class='row-fluid'");
        this.open("div id='info-doc-shortcuts' class='span6'");
        this.around("h5", "Documentation:");
        this.writeKeyboardShortcutInfo("o", "Jump to module documentation");
        this.writeKeyboardShortcutInfo("p", "Jump to package documentation");
        this.writeKeyboardShortcutInfo("l", "Jump to aliases");
        this.writeKeyboardShortcutInfo("n", "Jump to annotations");
        this.writeKeyboardShortcutInfo("z", "Jump to initializer");
        this.writeKeyboardShortcutInfo("t", "Jump to constructors");
        if (this.getFromObject() instanceof Module || this.getFromObject() instanceof Package) {
            this.writeKeyboardShortcutInfo("v", "Jump to values");
            this.writeKeyboardShortcutInfo("f", "Jump to functions");
        } else {
            this.writeKeyboardShortcutInfo("a", "Jump to attributes");
            this.writeKeyboardShortcutInfo("m", "Jump to methods");
        }
        this.writeKeyboardShortcutInfo("i", "Jump to interfaces");
        this.writeKeyboardShortcutInfo("c", "Jump to classes");
        this.writeKeyboardShortcutInfo("e", "Jump to exceptions");
        this.close("div");
        this.open("div id='info-search-shortcuts' class='span6'");
        this.around("h5", "Search page:");
        this.writeKeyboardShortcutInfo("enter", "Jump to selected declaration");
        this.writeKeyboardShortcutInfo("esc", "Clear search query/Go to overview");
        this.writeKeyboardShortcutInfo("up", "Move selection up");
        this.writeKeyboardShortcutInfo("down", "Move selection down");
        this.close("div");
        this.close("div");
        this.close("ul");
        this.close("li");
    }

    private void writeKeyboardShortcutInfo(String key, String info) throws IOException {
        this.open("div id='" + key + "'");
        this.around("span class='key badge'", key);
        this.around("span class='info muted'", info);
        this.close("div");
    }

    protected void writeNavBarIndexMenu() throws IOException {
        this.write("<li><a href='" + this.linkRenderer().getResourceUrl("../api-index.html") + "' title='Index'></i>Index</a></li>");
    }

    protected void writeNavBarSearchMenu() throws IOException {
        this.write("<li><a href='" + this.linkRenderer().getResourceUrl("../search.html") + "' title='Search this module [Shortcut: S]'><i class='icon-search'></i>Search</a></li>");
    }

    protected void writeNavBarFilterMenu() throws IOException {
        this.open("li id='filterDropdown' class='dropdown'");
        this.write("<a href='#' title='Filter declarations by tags [Shortcut: F]' role='button' class='dropdown-toggle' data-toggle='dropdown'><i class='icon-filter'></i>Filter <span id='filterDropdownLinkInfo'></span> <b class='caret'></b></a>");
        this.open("ul id='filterDropdownPanel' class='dropdown-menu'");
        this.around("h4 id='filterDropdownPanelInfo'", "Filter declarations by tags");
        this.write("<li class='divider'></li>");
        this.write("<div id='filterDropdownPanelTags'></div>");
        this.write("<li class='divider'></li>");
        this.open("div id='filterActions'");
        this.write("<a id='filterActionAll'>All</a>");
        this.write("<a id='filterActionNone'>None</a>");
        this.write("<a id='filterActionMore'>Show more</a>");
        this.close("div");
        this.close("ul");
        this.close("li");
    }

    protected final void writeSubNavBarLink(String href, String text, char key, String tooltip) throws IOException {
        this.open("a href='" + href + "'");
        int index = text.indexOf(key);
        if (index == -1) {
            this.write("<span title='", tooltip, "'>", text, "</span>");
        } else {
            String before = text.substring(0, index);
            String after = text.substring(index + 1);
            this.write("<span title='", tooltip, " [Shortcut: ", String.valueOf(key), "]'>");
            this.write(before, "<span class='accesskey'>", String.valueOf(key), "</span>", after, "</span>");
        }
        this.close("a");
    }

    protected void writeKeyboardShortcuts() throws IOException {
        this.registerKeyboardShortcut('s', this.linkRenderer().getResourceUrl("../search.html"));
        this.registerKeyboardShortcut('o', this.linkRenderer().getResourceUrl("../index.html"));
        this.registerAdditionalKeyboardShortcuts();
        if (!this.keyboardShortcuts.isEmpty()) {
            this.open("script type='text/javascript'");
            this.write("jQuery('html').keypress(function(evt){\n");
            this.write("  evt = evt || window.event;\n");
            this.write("  var keyCode = evt.keyCode || evt.which;\n");
            this.write("  if( !evt.ctrlKey && !evt.altKey ) {\n");
            this.write("    if (keyCode == 63) {\n");
            this.write("      $('#infoDropdown > .dropdown-toggle').click();\n");
            this.write("    }\n");
            for (Map.Entry<Character, String> keyboardShortcut : this.keyboardShortcuts.entrySet()) {
                this.write("    if(keyCode == " + keyboardShortcut.getKey().charValue() + "){\n");
                this.write("      document.location = '" + keyboardShortcut.getValue() + "';\n");
                this.write("    }\n");
            }
            this.write("  }\n");
            this.write("});\n");
            this.write("enableInfoKeybordShortcut('\\\\?');\n");
            for (Map.Entry<Character, String> keyboardShortcut : this.keyboardShortcuts.entrySet()) {
                this.write("enableInfoKeybordShortcut('" + keyboardShortcut.getKey() + "');\n");
            }
            this.close("script");
        }
    }

    protected void registerAdditionalKeyboardShortcuts() throws IOException {
    }

    protected final void registerKeyboardShortcut(char c, String url) throws IOException {
        this.keyboardShortcuts.put(Character.valueOf(c), url);
    }

    protected final void writeLinkSourceCode(Object obj) throws IOException {
        String srcUrl = this.linkRenderer().getSrcUrl(obj);
        if (this.tool.isIncludeSourceCode() && srcUrl != null) {
            this.open("a class='link-source-code' href='" + srcUrl + "'");
            this.write("<i class='icon-source-code'></i>");
            this.write("Source Code");
            this.close("a");
        }
    }

    protected final void writeBy(Object obj) throws IOException {
        List<Annotation> annotations;
        if (obj instanceof Declaration) {
            annotations = ((Declaration)obj).getAnnotations();
        } else if (obj instanceof Module) {
            annotations = ((Module)obj).getAnnotations();
        } else if (obj instanceof Package) {
            annotations = ((Package)obj).getAnnotations();
        } else {
            throw new IllegalArgumentException();
        }
        ArrayList<String> authors = new ArrayList<String>();
        for (Annotation annotation : annotations) {
            if (!annotation.getName().equals("by")) continue;
            for (String author : annotation.getPositionalArguments()) {
                authors.add(author);
            }
        }
        if (!authors.isEmpty()) {
            this.open("div class='by section'");
            this.around("span class='title'", "By: ");
            this.around("span class='value'", Util.join(", ", authors));
            this.close("div");
        }
    }

    protected final <T extends Annotated & Referenceable> void writeSee(T decl) throws IOException {
        Annotation see = Util.getAnnotation(((Referenceable)decl).getUnit(), decl.getAnnotations(), "see");
        if (see == null) {
            return;
        }
        this.open("div class='see section'");
        this.around("span class='title'", "See also ");
        this.open("span class='value'");
        boolean first = true;
        for (String target : see.getPositionalArguments()) {
            if (!first) {
                this.write(", ");
            } else {
                first = false;
            }
            this.linkRenderer().to(target).withinText(true).useScope(decl).printAbbreviated(false).printTypeParameters(false).write();
        }
        this.close("span");
        this.close("div");
    }

    protected final void writeIcon(Object obj) throws IOException {
        List<String> icons = this.getIcons(obj);
        int i = 0;
        for (String icon : icons) {
            this.open("i class='" + icon + "'");
            ++i;
        }
        while (i-- > 0) {
            this.close("i");
        }
    }

    protected final List<String> getIcons(Object obj) {
        ArrayList<String> icons = new ArrayList<String>();
        if (obj instanceof Declaration) {
            Declaration decl = (Declaration)obj;
            Annotation deprecated = Util.findAnnotation(decl, "deprecated");
            if (deprecated != null) {
                icons.add("icon-decoration-deprecated");
            }
            if (decl instanceof ClassOrInterface || decl instanceof Constructor) {
                if (decl instanceof Interface) {
                    icons.add("icon-interface");
                    if (Util.isEnumerated((ClassOrInterface)decl)) {
                        icons.add("icon-decoration-enumerated");
                    }
                }
                if (decl instanceof Class) {
                    Class klass = (Class)decl;
                    if (klass.isAnonymous()) {
                        icons.add("icon-object");
                    } else {
                        icons.add("icon-class");
                    }
                    if (klass.isAbstract()) {
                        icons.add("icon-decoration-abstract");
                    }
                    if (klass.isFinal() && !klass.isAnonymous() && !klass.isAnnotation()) {
                        icons.add("icon-decoration-final");
                    }
                    if (Util.isEnumerated(klass)) {
                        icons.add("icon-decoration-enumerated");
                    }
                }
                if (decl instanceof Constructor) {
                    icons.add("icon-class");
                }
                if (!decl.isShared()) {
                    icons.add("icon-decoration-local");
                }
            }
            if (decl instanceof TypedDeclaration) {
                Declaration refinedDeclaration;
                if (decl.isShared()) {
                    icons.add("icon-shared-member");
                } else {
                    icons.add("icon-local-member");
                }
                if (decl.isFormal()) {
                    icons.add("icon-decoration-formal");
                }
                if (decl.isActual() && (refinedDeclaration = decl.getRefinedDeclaration()) != null) {
                    if (refinedDeclaration.isFormal()) {
                        icons.add("icon-decoration-impl");
                    }
                    if (refinedDeclaration.isDefault()) {
                        icons.add("icon-decoration-over");
                    }
                }
                if (((TypedDeclaration)decl).isVariable()) {
                    icons.add("icon-decoration-variable");
                }
            }
            if (decl instanceof TypeAlias || decl instanceof NothingType) {
                icons.add("icon-type-alias");
            }
            if (decl.isAnnotation()) {
                icons.add("icon-decoration-annotation");
            }
        }
        if (obj instanceof Package) {
            Package pkg = (Package)obj;
            icons.add("icon-package");
            if (!pkg.isShared()) {
                icons.add("icon-decoration-local");
            }
        }
        if (obj instanceof ModuleImport) {
            ModuleImport moduleImport = (ModuleImport)obj;
            icons.add("icon-module");
            if (moduleImport.isExport()) {
                icons.add("icon-module-exported-decoration");
            }
            if (moduleImport.isOptional()) {
                icons.add("icon-module-optional-decoration");
            }
        }
        if (obj instanceof Module) {
            icons.add("icon-module");
        }
        return icons;
    }

    protected final void writePackageNavigation(Package pkg) throws IOException {
        this.open("span class='package-identifier'");
        if (!this.module.isDefault()) {
            List<String> moduleNames = this.module.getName();
            List<String> pkgNames = pkg.getName();
            List<String> subpkgNames = pkgNames.subList(moduleNames.size(), pkgNames.size());
            this.linkRenderer().to(this.module.getRootPackage()).write();
            if (!subpkgNames.isEmpty()) {
                StringBuilder subpkgNameBuilder = new StringBuilder(this.module.getNameAsString());
                for (String subpkgName : subpkgNames) {
                    subpkgNameBuilder.append(".").append(subpkgName);
                    Package subpkg = this.module.getDirectPackage(subpkgNameBuilder.toString());
                    this.write(".");
                    if (subpkg != null) {
                        this.linkRenderer().to(subpkg).useCustomText(subpkgName).write();
                        continue;
                    }
                    this.write(subpkgName);
                }
            }
        } else {
            this.linkRenderer().to(pkg).write();
        }
        this.close("span");
    }

    protected final void writePackagesTable(String title, List<Package> packages) throws IOException {
        if (!packages.isEmpty()) {
            this.openTable("section-packages", title, 2, true);
            for (Package pkg : packages) {
                this.writePackagesTableRow(pkg);
            }
            this.closeTable();
        }
    }

    protected final void writePackagesTableRow(Package pkg) throws IOException {
        this.open("tr");
        this.open("td");
        this.writeIcon(pkg);
        if (pkg.getNameAsString().isEmpty()) {
            this.around("a class='link' href='index.html'", "default package");
        } else {
            this.around("a class='link' href='" + this.tool.getObjectUrl(this.getFromObject(), pkg) + "'", pkg.getNameAsString());
        }
        this.close("td");
        this.open("td");
        this.writeTagged(pkg);
        this.write(Util.getDocFirstLine(pkg, this.linkRenderer()));
        this.close("td");
        this.close("tr");
    }

    protected final void writeAnnotations(Referenceable referenceable) throws IOException {
        Tree.AnnotationList annotationList = null;
        Node node = this.tool.getNode(referenceable);
        if (node instanceof Tree.Declaration) {
            annotationList = ((Tree.Declaration)node).getAnnotationList();
        } else if (node instanceof Tree.ImportModule) {
            annotationList = ((Tree.ImportModule)node).getAnnotationList();
        } else if (node instanceof Tree.ModuleDescriptor) {
            annotationList = ((Tree.ModuleDescriptor)node).getAnnotationList();
        } else if (node instanceof Tree.PackageDescriptor) {
            annotationList = ((Tree.PackageDescriptor)node).getAnnotationList();
        }
        if (annotationList != null) {
            annotationList.visit(new WriteAnnotationsVisitor(referenceable));
        }
    }

    protected final <T extends Referenceable & Annotated> void writeTagged(T decl) throws IOException {
        List<String> tags = Util.getTags(decl);
        if (!tags.isEmpty()) {
            this.open("div class='tags section'");
            for (String tag : tags) {
                this.write("<a class='tag label' name='" + tag + "' href='javascript:;' title='Enable/disable tag filter'>" + tag + "</a>");
            }
            this.close("div");
        }
    }

    protected abstract Object getFromObject();

    private class WriteAnnotationsVisitor
    extends Visitor {
        private final Referenceable referenceable;
        private Tree.Annotation annotation;
        private Tree.InvocationExpression invocationExpression;
        private Tree.PositionalArgument positionalArgument;

        public WriteAnnotationsVisitor(Referenceable referenceable) {
            this.referenceable = referenceable;
        }

        @Override
        public void visit(Tree.AnnotationList that) {
            try {
                boolean containsAnnotations = false;
                for (Tree.Annotation annotation : that.getAnnotations()) {
                    if (this.isCeylonLanguageAnnotation(annotation)) continue;
                    containsAnnotations = true;
                    break;
                }
                if (containsAnnotations) {
                    CeylonDoc.this.open("div class='annotations section'");
                    CeylonDoc.this.around("span class='title'", "Annotations: ");
                    CeylonDoc.this.open("ul");
                    super.visit(that);
                    CeylonDoc.this.close("ul");
                    CeylonDoc.this.close("div");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.AnonymousAnnotation that) {
        }

        @Override
        public void visit(Tree.Annotation that) {
            try {
                if (this.isCeylonLanguageAnnotation(that)) {
                    return;
                }
                CeylonDoc.this.open("li");
                Tree.Annotation old = this.annotation;
                this.annotation = that;
                super.visit(that);
                this.annotation = old;
                CeylonDoc.this.close("li");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.MemberOrTypeExpression that) {
            try {
                CeylonDoc.this.linkRenderer().to(that.getDeclaration()).useScope(this.referenceable).printParenthesisAfterMethodName(false).write();
                super.visit(that);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.InvocationExpression that) {
            Tree.InvocationExpression old = this.invocationExpression;
            this.invocationExpression = that;
            super.visit(that);
            this.invocationExpression = old;
        }

        @Override
        public void visit(Tree.PositionalArgumentList that) {
            try {
                if (!that.getPositionalArguments().isEmpty() || this.annotation != this.invocationExpression) {
                    CeylonDoc.this.write("(");
                }
                this.positionalArgument = null;
                super.visit(that);
                this.positionalArgument = null;
                if (!that.getPositionalArguments().isEmpty() || this.annotation != this.invocationExpression) {
                    CeylonDoc.this.write(")");
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.PositionalArgument that) {
            try {
                if (this.positionalArgument != null) {
                    CeylonDoc.this.write(", ");
                }
                super.visit(that);
                this.positionalArgument = that;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.NamedArgumentList that) {
            try {
                CeylonDoc.this.write("{");
                super.visit(that);
                CeylonDoc.this.write("}");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.NamedArgument that) {
            try {
                CeylonDoc.this.write(that.getParameter().getName());
                CeylonDoc.this.write("=");
                super.visit(that);
                CeylonDoc.this.write(";");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.SequenceEnumeration that) {
            try {
                Tree.PositionalArgument old = this.positionalArgument;
                this.positionalArgument = null;
                CeylonDoc.this.write("{");
                super.visit(that);
                CeylonDoc.this.write("}");
                this.positionalArgument = old;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.Tuple that) {
            try {
                Tree.PositionalArgument old = this.positionalArgument;
                this.positionalArgument = null;
                CeylonDoc.this.write("[");
                super.visit(that);
                CeylonDoc.this.write("]");
                this.positionalArgument = old;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.Literal that) {
            try {
                CeylonDoc.this.open("span class='literal'");
                if (that instanceof Tree.StringLiteral) {
                    CeylonDoc.this.write("&quot;");
                }
                CeylonDoc.this.write(that.getText());
                if (that instanceof Tree.StringLiteral) {
                    CeylonDoc.this.write("&quot;");
                }
                CeylonDoc.this.close("span");
                super.visit(that);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.MemberLiteral that) {
            try {
                if (that instanceof Tree.ValueLiteral) {
                    CeylonDoc.this.write("`");
                    CeylonDoc.this.around("span class='keyword'", "value ");
                } else if (that instanceof Tree.FunctionLiteral) {
                    CeylonDoc.this.write("`");
                    CeylonDoc.this.around("span class='keyword'", "function ");
                }
                CeylonDoc.this.linkRenderer().to(that.getDeclaration()).useScope(this.referenceable).write();
                CeylonDoc.this.write("`");
                super.visit(that);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.TypeLiteral that) {
            try {
                if (that instanceof Tree.AliasLiteral) {
                    CeylonDoc.this.write("`");
                    CeylonDoc.this.around("span class='keyword'", "alias ");
                } else if (that instanceof Tree.ClassLiteral) {
                    CeylonDoc.this.write("`");
                    CeylonDoc.this.around("span class='keyword'", "class ");
                } else if (that instanceof Tree.InterfaceLiteral) {
                    CeylonDoc.this.write("`");
                    CeylonDoc.this.around("span class='keyword'", "interface ");
                } else if (that instanceof Tree.TypeParameterLiteral) {
                    CeylonDoc.this.write("`");
                    CeylonDoc.this.around("span class='keyword'", "given ");
                }
                CeylonDoc.this.linkRenderer().to(that.getDeclaration()).useScope(this.referenceable).write();
                CeylonDoc.this.write("`");
                super.visit(that);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.ModuleLiteral that) {
            try {
                CeylonDoc.this.write("`");
                CeylonDoc.this.around("span class='keyword'", "module ");
                CeylonDoc.this.linkRenderer().to(that.getImportPath().getModel()).useScope(this.referenceable).write();
                CeylonDoc.this.write("`");
                super.visit(that);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void visit(Tree.PackageLiteral that) {
            try {
                CeylonDoc.this.write("`");
                CeylonDoc.this.around("span class='keyword'", "package");
                CeylonDoc.this.write(" ");
                CeylonDoc.this.linkRenderer().to(that.getImportPath().getModel()).useScope(this.referenceable).write();
                CeylonDoc.this.write("`");
                super.visit(that);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isCeylonLanguageAnnotation(Tree.Annotation annotation) {
            Declaration declaration;
            return annotation.getPrimary() instanceof Tree.MemberOrTypeExpression && (declaration = ((Tree.MemberOrTypeExpression)annotation.getPrimary()).getDeclaration()).getQualifiedNameString().startsWith("ceylon.language");
        }
    }
}

