/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.ModulesClassLoader;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.LoaderJULLogger;
import com.redhat.ceylon.model.loader.impl.reflect.ReflectionModelLoader;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.mirror.MethodMirror;
import com.redhat.ceylon.model.loader.model.AnnotationProxyClass;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.loader.model.LazyFunction;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.UnknownType;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CeylonDocModelLoader
extends ReflectionModelLoader {
    ModulesClassLoader classLoader = new ModulesClassLoader(CeylonDocModelLoader.class.getClassLoader());
    Set<Module> modulesAddedToClassPath = new HashSet<Module>();
    private CeylonDocTool tool;

    public CeylonDocModelLoader(ModuleManager moduleManager, Modules modules, CeylonDocTool tool, boolean bootstrapCeylon) {
        super(moduleManager, modules, new LoaderJULLogger());
        this.tool = tool;
        this.isBootstrap = bootstrapCeylon;
    }

    @Override
    protected boolean needsLocalDeclarations() {
        return false;
    }

    @Override
    protected boolean needsPrivateMembers() {
        return false;
    }

    @Override
    public boolean isModuleInClassPath(Module module) {
        return this.modulesAddedToClassPath.contains(module);
    }

    @Override
    protected Class<?> loadClass(Module module, String name) {
        Class<?> klass = null;
        try {
            klass = this.classLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return klass;
    }

    @Override
    public void addModuleToClassPath(Module module, ArtifactResult artifact) {
        if (artifact == null || !this.modulesAddedToClassPath.add(module)) {
            return;
        }
        File file = artifact.artifact();
        this.classLoader.addJar(artifact, module, module == this.modules.getLanguageModule());
        this.log.debug("Adding jar to classpath: " + file);
        if (module instanceof LazyModule) {
            ((LazyModule)module).loadPackageList(artifact);
        }
    }

    @Override
    protected List<String> getPackageList(Module module, String packageName) {
        return this.classLoader.getPackageList(module, packageName);
    }

    @Override
    protected boolean packageExists(Module module, String packageName) {
        return this.classLoader.packageExists(module, packageName);
    }

    @Override
    public Module findModuleForClassMirror(ClassMirror classMirror) {
        String pkgName = this.getPackageNameForQualifiedClassName(classMirror);
        return this.lookupModuleByPackageName(pkgName);
    }

    @Override
    protected UnknownType.ErrorReporter makeModelErrorReporter(Module module, String message) {
        return new ModuleErrorAttacherRunnable(this.tool.getModuleSourceMapper(), module, message);
    }

    @Override
    protected void setAnnotationConstructor(LazyFunction method, MethodMirror meth) {
    }

    @Override
    protected void makeInteropAnnotationConstructorInvocation(AnnotationProxyMethod ctor, AnnotationProxyClass klass, List<Parameter> ctorParams) {
    }

    public static class ModuleErrorAttacherRunnable
    extends UnknownType.ErrorReporter {
        private Module module;
        private ModuleSourceMapper moduleSourceMapper;

        public ModuleErrorAttacherRunnable(ModuleSourceMapper moduleSourceMapper, Module module, String message) {
            super(message);
            this.moduleSourceMapper = moduleSourceMapper;
            this.module = module;
        }

        @Override
        public void reportError() {
            this.moduleSourceMapper.attachErrorToOriginalModuleImport(this.module, this.getMessage());
        }
    }
}

