/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocModelLoader;
import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.CeylondException;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.compiler.java.util.Util;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModule;
import com.redhat.ceylon.model.loader.impl.reflect.model.ReflectionModuleManager;
import com.redhat.ceylon.model.loader.mirror.ClassMirror;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyPackage;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Modules;
import com.redhat.ceylon.model.typechecker.model.Package;
import java.util.Collections;
import java.util.List;

public class CeylonDocModuleManager
extends ReflectionModuleManager {
    private List<ModuleSpec> modulesSpecs;
    private CeylonDocTool tool;
    private RepositoryManager outputRepositoryManager;
    private boolean bootstrapCeylon;

    public CeylonDocModuleManager(CeylonDocTool tool, Context context, List<ModuleSpec> modules, RepositoryManager outputRepositoryManager, boolean bootstrapCeylon, Logger log) {
        this.outputRepositoryManager = outputRepositoryManager;
        this.modulesSpecs = modules;
        this.tool = tool;
        this.bootstrapCeylon = bootstrapCeylon;
    }

    @Override
    public boolean isModuleLoadedFromSource(String moduleName) {
        for (ModuleSpec spec : this.modulesSpecs) {
            if (!spec.getName().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AbstractModelLoader createModelLoader(Modules modules) {
        return new CeylonDocModelLoader(this, modules, this.tool, this.bootstrapCeylon){

            @Override
            protected boolean isLoadedFromSource(String className) {
                return CeylonDocModuleManager.this.tool.getCompiledClasses().contains(className);
            }

            @Override
            public ClassMirror lookupNewClassMirror(Module module, String name) {
                if (CeylonDocModuleManager.this.tool.getCompiledClasses().contains(name)) {
                    this.logVerbose("Not loading " + name + " from class because we are typechecking them");
                    return null;
                }
                return super.lookupNewClassMirror(module, name);
            }

            @Override
            protected void logError(String message) {
                this.log.error(message);
            }

            @Override
            protected void logVerbose(String message) {
                this.log.debug(message);
            }

            @Override
            protected void logWarning(String message) {
                this.log.warning(message);
            }
        };
    }

    @Override
    public Package createPackage(String pkgName, Module module) {
        if ((pkgName.equals("ceylon.language") || pkgName.startsWith("ceylon.language.")) && this.isModuleLoadedFromSource("ceylon.language")) {
            return super.createPackage(pkgName, module);
        }
        LazyPackage pkg = new LazyPackage(this.getModelLoader());
        List<String> name = pkgName.isEmpty() ? Collections.emptyList() : CeylonDocModuleManager.splitModuleName(pkgName);
        pkg.setName(name);
        if (module != null) {
            module.getPackages().add(pkg);
            pkg.setModule(module);
        }
        return pkg;
    }

    @Override
    protected Module createModule(List<String> moduleName, String version2) {
        String name = Util.getName(moduleName);
        Module module = name.equals("ceylon.language") && this.isModuleLoadedFromSource("ceylon.language") ? new Module() : new ReflectionModule(this);
        module.setName(moduleName);
        module.setVersion(version2);
        if (module instanceof ReflectionModule) {
            this.setupIfJDKModule((LazyModule)module);
        }
        return module;
    }

    @Override
    public void modulesVisited() {
        try {
            super.modulesVisited();
        }
        catch (Exception x) {
            throw new CeylondException("error.languageModuleSourcesMissing", this.tool.getSourceDirs().toArray());
        }
        for (Module module : this.getModules().getListOfModules()) {
            if (!this.isModuleLoadedFromSource(module.getNameAsString())) continue;
            this.addOutputModuleToClassPath(module);
        }
    }

    private void addOutputModuleToClassPath(Module module) {
        ArtifactContext ctx = new ArtifactContext(module.getNameAsString(), module.getVersion(), ".car");
        ArtifactResult result = this.outputRepositoryManager.getArtifactResult(ctx);
        if (result != null) {
            this.getModelLoader().addModuleToClassPath(module, result);
        }
    }

    @Override
    public Backends getSupportedBackends() {
        return Backends.JAVA.merged(Backend.JavaScript);
    }
}

