/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocModuleManager;
import com.redhat.ceylon.ceylondoc.CeylonDocModuleSourceMapper;
import com.redhat.ceylon.ceylondoc.CeylondException;
import com.redhat.ceylon.ceylondoc.CeylondLogger;
import com.redhat.ceylon.ceylondoc.CeylondMessages;
import com.redhat.ceylon.ceylondoc.ClassDoc;
import com.redhat.ceylon.ceylondoc.IndexApiDoc;
import com.redhat.ceylon.ceylondoc.IndexDoc;
import com.redhat.ceylon.ceylondoc.LinkRenderer;
import com.redhat.ceylon.ceylondoc.Markup;
import com.redhat.ceylon.ceylondoc.ModuleDoc;
import com.redhat.ceylon.ceylondoc.PackageDoc;
import com.redhat.ceylon.ceylondoc.Search;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.OutputRepoUsingTool;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Hidden;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.common.tools.ModuleWildcardsHelper;
import com.redhat.ceylon.compiler.java.loader.SourceDeclarationVisitor;
import com.redhat.ceylon.compiler.typechecker.TypeChecker;
import com.redhat.ceylon.compiler.typechecker.TypeCheckerBuilder;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.compiler.typechecker.tree.Walker;
import com.redhat.ceylon.compiler.typechecker.util.ModuleManagerFactory;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Summary(value="Generates Ceylon API documentation from Ceylon source files")
@Description(value="The default module repositories are `modules` and `https://modules.ceylon-lang.org/repo/1`, and the default source directory is `source`. The default output module repository is `modules`.\n\nThe `<modules>` are the names (with an optional version) of the modules to compile the documentation of.\n\nThe documentation compiler searches for compilation units belonging to the specified modules in the specified source directories and in source archives in the specified module repositories. For each specified module, the compiler generates a set of XHTML pages in the module documentation directory (the module-doc directory) of the specified output module repository.\n\nThe compiler searches for source in the following locations:\n\n* source archives in the specified repositories, and\n* module directories in the specified source directories.\n\nIf no version identifier is specified for a module, the module is assumed to exist in a source directory.")
@RemainingSections(value="## EXAMPLE\n\nThe following would compile the `org.hibernate` module source code found in the `~/projects/hibernate/src` directory to the repository `~/projects/hibernate/build`:\n\n    ceylon doc org.hibernate/3.0.0.beta \\\n        --src ~/projects/hibernate/src \\\n        --out ~/projects/hibernate/build\n\n## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see http://ceylon-lang.org/documentation/1.2/reference/repository/tools")
public class CeylonDocTool
extends OutputRepoUsingTool {
    private static final String OPTION_SECTION = "doctool.";
    private static final String OPTION_HEADER = "doctool.header";
    private static final String OPTION_FOOTER = "doctool.footer";
    private static final String OPTION_NON_SHARED = "doctool.non-shared";
    private static final String OPTION_SOURCE_CODE = "doctool.source-code";
    private static final String OPTION_IGNORE_MISSING_DOC = "doctool.ignore-missing-doc";
    private static final String OPTION_IGNORE_MISSING_THROWS = "doctool.ignore-missing-throws";
    private static final String OPTION_IGNORE_BROKEN_LINK = "doctool.ignore-broken-link";
    private static final String OPTION_LINK = "doctool.link";
    private static final String OPTION_RESOURCE_FOLDER = "doctool.resource-folder";
    private String encoding;
    private String header;
    private String footer;
    private boolean includeNonShared;
    private boolean includeSourceCode;
    private boolean ignoreMissingDoc;
    private boolean ignoreMissingThrows;
    private boolean ignoreBrokenLink;
    private boolean browse;
    private boolean haltOnError = true;
    private boolean bootstrapCeylon;
    private String resourceFolder;
    private List<File> sourceFolders = DefaultToolOptions.getCompilerSourceDirs();
    private List<File> docFolders = DefaultToolOptions.getCompilerDocDirs();
    private List<String> moduleSpecs = Arrays.asList("*");
    private List<String> links = new LinkedList<String>();
    private TypeChecker typeChecker;
    private Module currentModule;
    private File tempDestDir;
    private final List<PhasedUnit> phasedUnits = new LinkedList<PhasedUnit>();
    private final List<Module> modules = new LinkedList<Module>();
    private final List<String> compiledClasses = new LinkedList<String>();
    private final Map<TypeDeclaration, List<Class>> subclasses = new IdentityHashMap<TypeDeclaration, List<Class>>();
    private final Map<TypeDeclaration, List<ClassOrInterface>> satisfyingClassesOrInterfaces = new IdentityHashMap<TypeDeclaration, List<ClassOrInterface>>();
    private final Map<TypeDeclaration, List<Function>> annotationConstructors = new IdentityHashMap<TypeDeclaration, List<Function>>();
    private final Map<Referenceable, PhasedUnit> modelUnitMap = new IdentityHashMap<Referenceable, PhasedUnit>();
    private final Map<Referenceable, Node> modelNodeMap = new IdentityHashMap<Referenceable, Node>();
    private final Map<Parameter, PhasedUnit> parameterUnitMap = new IdentityHashMap<Parameter, PhasedUnit>();
    private final Map<Parameter, Node> parameterNodeMap = new IdentityHashMap<Parameter, Node>();
    private final Map<String, Boolean> moduleUrlAvailabilityCache = new HashMap<String, Boolean>();
    private RepositoryManager outputRepositoryManager;

    public CeylonDocTool() {
        super(CeylondMessages.RESOURCE_BUNDLE);
        CeylonConfig config = CeylonConfig.get();
        this.header = config.getOption(OPTION_HEADER);
        this.footer = config.getOption(OPTION_FOOTER);
        this.includeNonShared = config.getBoolOption(OPTION_NON_SHARED, false);
        this.includeSourceCode = config.getBoolOption(OPTION_SOURCE_CODE, false);
        this.ignoreMissingDoc = config.getBoolOption(OPTION_IGNORE_MISSING_DOC, false);
        this.ignoreMissingThrows = config.getBoolOption(OPTION_IGNORE_MISSING_THROWS, false);
        this.ignoreBrokenLink = config.getBoolOption(OPTION_IGNORE_BROKEN_LINK, false);
        this.resourceFolder = config.getOption(OPTION_RESOURCE_FOLDER, ".resources");
        String[] linkValues = config.getOptionValues(OPTION_LINK);
        if (linkValues != null) {
            this.setLinks(Arrays.asList(linkValues));
        }
        this.log = new CeylondLogger();
    }

    @OptionArgument(argumentName="encoding")
    @Description(value="Sets the encoding used for reading source files (default: platform-specific)")
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @OptionArgument(argumentName="header")
    @Description(value="Sets the header text to be placed at the top of each page.")
    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    @OptionArgument(argumentName="footer")
    @Description(value="Sets the footer text to be placed at the bottom of each page.")
    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.footer;
    }

    @Option(longName="non-shared")
    @Description(value="Includes documentation for package-private declarations.")
    public void setIncludeNonShared(boolean includeNonShared) {
        this.includeNonShared = includeNonShared;
    }

    public boolean isIncludeNonShared() {
        return this.includeNonShared;
    }

    @Option(longName="source-code")
    @Description(value="Includes source code in the generated documentation.")
    public void setIncludeSourceCode(boolean includeSourceCode) {
        this.includeSourceCode = includeSourceCode;
    }

    public boolean isIncludeSourceCode() {
        return this.includeSourceCode;
    }

    @Option(longName="ignore-missing-doc")
    @Description(value="Do not print warnings about missing documentation.")
    public void setIgnoreMissingDoc(boolean ignoreMissingDoc) {
        this.ignoreMissingDoc = ignoreMissingDoc;
    }

    @Option(longName="ignore-missing-throws")
    @Description(value="Do not print warnings about missing throws annotation.")
    public void setIgnoreMissingThrows(boolean ignoreMissingThrows) {
        this.ignoreMissingThrows = ignoreMissingThrows;
    }

    @Option(longName="ignore-broken-link")
    @Description(value="Do not print warnings about broken links.")
    public void setIgnoreBrokenLink(boolean ignoreBrokenLink) {
        this.ignoreBrokenLink = ignoreBrokenLink;
    }

    @Hidden
    @Option(longName="bootstrap-ceylon")
    @Description(value="Is used when documenting the Ceylon language module.")
    public void setBootstrapCeylon(boolean bootstrapCeylon) {
        this.bootstrapCeylon = bootstrapCeylon;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    @OptionArgument(longName="source", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="An alias for `--src` (default: `./source`)")
    public void setSource(List<File> source) {
        this.setSourceFolders(source);
    }

    @OptionArgument(longName="src", argumentName="dir")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="A directory containing Ceylon and/or Java source code (default: `./source`)")
    public void setSourceFolders(List<File> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    @OptionArgument(longName="doc", argumentName="dirs")
    @ParsedBy(value=StandardArgumentParsers.PathArgumentParser.class)
    @Description(value="A directory containing your module documentation (default: `./doc`)")
    public void setDocFolders(List<File> docFolders) {
        this.docFolders = docFolders;
    }

    @Argument(argumentName="modules", multiplicity="*")
    public void setModuleSpecs(List<String> moduleSpecs) {
        this.moduleSpecs = moduleSpecs;
    }

    public List<String> getLinks() {
        return this.links;
    }

    @OptionArgument(longName="link", argumentName="dir-or-url")
    @Description(value="The URL or path of a module repository containing documentation for external dependencies.\n\nThe URL must use one of the supported protocols (http://, https:// or file://) or be a path to a directory. The argument can start with a module name prefix, separated from the URL by a `=` character, so that only those external modules whose name begins with the prefix will be linked using that URL.\nCan be specified multiple times.\n\nExamples:\n\n    --link https://modules.ceylon-lang.org/repo/1\n    --link ceylon.math=https://modules.ceylon-lang.org/repo/1\n    --link com.example=http://example.com/ceylondoc/")
    public void setLinks(List<String> linkArgs) {
        this.links = new ArrayList<String>();
        if (linkArgs != null) {
            for (String link : linkArgs) {
                this.links.add(this.validateLink(link));
            }
        }
    }

    private String validateLink(String link) {
        String[] linkParts = LinkRenderer.divideToPatternAndUrl(link);
        String moduleNamePattern = linkParts[0];
        String moduleRepoUrl = linkParts[1];
        if (!LinkRenderer.isHttpProtocol(moduleRepoUrl) && !LinkRenderer.isFileProtocol(moduleRepoUrl)) {
            File moduleRepoFile = new File(moduleRepoUrl);
            if (moduleRepoFile.exists() && moduleRepoFile.isDirectory()) {
                moduleRepoUrl = moduleRepoFile.toURI().toString();
            } else if (moduleNamePattern == null) {
                throw new IllegalArgumentException(CeylondMessages.msg("error.unexpectedLink", link));
            }
        }
        return moduleNamePattern != null ? moduleNamePattern + "=" + moduleRepoUrl : moduleRepoUrl;
    }

    @Override
    @Option(longName="offline")
    @Description(value="Enables offline mode that will prevent the module loader from connecting to remote repositories.")
    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @Option(longName="browse")
    @Description(value="Open module documentation in browser.")
    public void setBrowse(boolean browse) {
        this.browse = browse;
    }

    @OptionArgument(longName="resource-folder", argumentName="dir")
    @Description(value="A directory name, where the documentation resources (css, js, ...) will be placed (default: .resources)")
    public void setResourceFolder(String resourceFolder) {
        this.resourceFolder = resourceFolder;
    }

    public List<String> getCompiledClasses() {
        return this.compiledClasses;
    }

    public String getOut() {
        return this.out;
    }

    @Override
    protected List<File> getSourceDirs() {
        return this.sourceFolders;
    }

    @Override
    public void initialize(CeylonTool mainTool) {
        TypeCheckerBuilder builder = new TypeCheckerBuilder();
        for (File src : this.sourceFolders) {
            builder.addSrcDirectory(src);
        }
        RepositoryManager repository = this.getRepositoryManager();
        builder.setRepositoryManager(repository);
        this.outputRepositoryManager = this.getOutputRepositoryManager();
        List<File> srcs = FileUtil.applyCwd(this.cwd, this.sourceFolders);
        List<String> expandedModules = ModuleWildcardsHelper.expandWildcards(srcs, this.moduleSpecs, null);
        final List<ModuleSpec> modules = ModuleSpec.parseEachList(expandedModules, new ModuleSpec.Option[0]);
        builder.moduleManagerFactory(new ModuleManagerFactory(){

            @Override
            public ModuleManager createModuleManager(Context context) {
                return new CeylonDocModuleManager(CeylonDocTool.this, context, modules, CeylonDocTool.this.outputRepositoryManager, CeylonDocTool.this.bootstrapCeylon, CeylonDocTool.this.log);
            }

            @Override
            public ModuleSourceMapper createModuleManagerUtil(Context context, ModuleManager moduleManager) {
                return new CeylonDocModuleSourceMapper(context, (CeylonDocModuleManager)moduleManager, CeylonDocTool.this);
            }
        });
        LinkedList<String> moduleFilters = new LinkedList<String>();
        for (ModuleSpec spec : modules) {
            moduleFilters.add(spec.getName());
            if (!spec.getName().equals("ceylon.language") || this.bootstrapCeylon) continue;
            throw new CeylondException("error.languageModuleBootstrapOptionMissing");
        }
        builder.setModuleFilters(moduleFilters);
        String fileEncoding = this.getEncoding();
        if (fileEncoding == null) {
            fileEncoding = CeylonConfig.get("defaults.encoding");
        }
        if (fileEncoding != null) {
            builder.encoding(fileEncoding);
        }
        this.typeChecker = builder.getTypeChecker();
        this.initTypeCheckedUnits(this.typeChecker);
        this.typeChecker.process();
        if (this.haltOnError && this.typeChecker.getErrors() > 0) {
            throw new CeylondException("error.failedParsing", new Object[]{this.typeChecker.getErrors()}, null);
        }
        this.initModules(modules);
        this.initPhasedUnits();
    }

    private void initTypeCheckedUnits(TypeChecker typeChecker) {
        for (PhasedUnit unit : typeChecker.getPhasedUnits().getPhasedUnits()) {
            final String pkgName = Util.getUnitPackageName(unit);
            unit.getCompilationUnit().visit(new SourceDeclarationVisitor(){

                @Override
                public void loadFromSource(Tree.Declaration decl) {
                    CeylonDocTool.this.compiledClasses.add(Util.getQuotedFQN(pkgName, decl));
                }

                @Override
                public void loadFromSource(Tree.ModuleDescriptor that) {
                }

                @Override
                public void loadFromSource(Tree.PackageDescriptor that) {
                }
            });
        }
    }

    private void initModules(List<ModuleSpec> moduleSpecs) {
        for (ModuleSpec moduleSpec : moduleSpecs) {
            Module foundModule = null;
            for (Module module : this.typeChecker.getContext().getModules().getListOfModules()) {
                if (!module.getNameAsString().equals(moduleSpec.getName()) || moduleSpec.isVersioned() && !moduleSpec.getVersion().equals(module.getVersion())) continue;
                foundModule = module;
            }
            if (foundModule != null) {
                this.modules.add(foundModule);
                continue;
            }
            if (moduleSpec.isVersioned()) {
                throw new RuntimeException(CeylondMessages.msg("error.cantFindModule", moduleSpec.getName(), moduleSpec.getVersion()));
            }
            throw new RuntimeException(CeylondMessages.msg("error.cantFindModuleNoVersion", moduleSpec.getName()));
        }
    }

    private void initPhasedUnits() {
        for (PhasedUnit pu : this.typeChecker.getPhasedUnits().getPhasedUnits()) {
            if (!this.modules.contains(pu.getUnit().getPackage().getModule())) continue;
            this.phasedUnits.add(pu);
        }
    }

    public String getFileName(TypeDeclaration type) {
        String postfix = type instanceof Class && type.isAnonymous() ? ".object" : ".type";
        LinkedList<String> names = new LinkedList<String>();
        Scope scope = type;
        while (scope instanceof TypeDeclaration) {
            names.add(0, scope.getName());
            scope = scope.getContainer();
        }
        return Util.join(".", names) + postfix + ".html";
    }

    private File getFolder(Package pkg) {
        Module module = pkg.getModule();
        List<String> unprefixedName = module.isDefault() ? pkg.getName() : pkg.getName().subList(module.getName().size(), pkg.getName().size());
        File dir = new File(this.getApiOutputFolder(module), Util.join("/", unprefixedName));
        if (this.shouldInclude(module)) {
            FileUtil.mkdirs(dir);
        }
        return dir;
    }

    private File getFolder(TypeDeclaration type) {
        return this.getFolder(this.getPackage(type));
    }

    private File getApiOutputFolder(Module module) {
        return this.getOutputFolder(module, "api");
    }

    private File getDocOutputFolder(Module module) {
        return this.getOutputFolder(module, "doc");
    }

    private File getOutputFolder(Module module, String subDir) {
        File folder = new File(com.redhat.ceylon.compiler.java.util.Util.getModulePath(this.tempDestDir, module), "module-doc");
        if (subDir != null) {
            folder = new File(folder, subDir);
        }
        if (this.shouldInclude(module)) {
            FileUtil.mkdirs(folder);
        }
        return folder;
    }

    private File getObjectFile(Object modPgkOrDecl) throws IOException {
        File file;
        if (modPgkOrDecl instanceof TypeDeclaration) {
            TypeDeclaration type = (TypeDeclaration)modPgkOrDecl;
            String filename = this.getFileName(type);
            file = new File(this.getFolder(type), filename);
        } else if (modPgkOrDecl instanceof Module) {
            String filename = "index.html";
            file = new File(this.getApiOutputFolder((Module)modPgkOrDecl), filename);
        } else if (modPgkOrDecl instanceof Package) {
            String filename = "index.html";
            file = new File(this.getFolder((Package)modPgkOrDecl), filename);
        } else {
            throw new RuntimeException(CeylondMessages.msg("error.unexpected", modPgkOrDecl));
        }
        return file.getCanonicalFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        this.tempDestDir = Files.createTempDirectory("ceylon-doc-", new FileAttribute[0]).toFile();
        try {
            this.makeDoc();
        }
        finally {
            FileUtil.deleteQuietly(this.tempDestDir);
        }
    }

    private void makeDoc() throws IOException {
        this.buildNodesMaps();
        if (this.includeSourceCode) {
            this.copySourceFiles();
        }
        this.collectSubclasses();
        this.collectAnnotationConstructors();
        boolean documentedOne = false;
        for (Module module : this.modules) {
            if (this.isEmpty(module)) {
                this.log.warning(CeylondMessages.msg("warn.moduleHasNoDeclaration", module.getNameAsString()));
            } else {
                documentedOne = true;
            }
            this.documentModule(module);
            ArtifactContext artifactDocs = new ArtifactContext(module.getNameAsString(), module.getVersion(), "module-doc");
            File outputDocFolder = this.getDocOutputFolder(module);
            for (File docFolder : this.docFolders) {
                File moduleDocFolder = new File(docFolder, Util.join("/", module.getName()));
                if (!moduleDocFolder.exists()) continue;
                FileUtil.copyAll(moduleDocFolder, outputDocFolder);
            }
            this.repositoryRemoveArtifact(this.outputRepositoryManager, artifactDocs);
            this.repositoryPutArtifact(this.outputRepositoryManager, artifactDocs, this.getOutputFolder(module, null));
        }
        if (!documentedOne) {
            this.log.warning(CeylondMessages.msg("warn.couldNotFindAnyDeclaration", new Object[0]));
        }
        if (this.browse) {
            for (Module module : this.modules) {
                if (this.isEmpty(module)) continue;
                ArtifactContext docArtifact = new ArtifactContext(module.getNameAsString(), module.getVersion(), "module-doc");
                File docFolder = this.outputRepositoryManager.getArtifact(docArtifact);
                File docIndex = new File(docFolder, "api/index.html");
                if (!docIndex.isFile()) continue;
                try {
                    Desktop.getDesktop().browse(docIndex.toURI());
                }
                catch (Exception e) {
                    this.log.error(CeylondMessages.msg("error.unableBrowseModuleDoc", docIndex.toURI()));
                }
            }
        }
    }

    private void repositoryRemoveArtifact(RepositoryManager outputRepository, ArtifactContext artifactContext) {
        try {
            outputRepository.removeArtifact(artifactContext);
        }
        catch (Exception e) {
            throw new CeylondException("error.failedRemoveArtifact", new Object[]{artifactContext, e.getLocalizedMessage()}, e);
        }
    }

    private void repositoryPutArtifact(RepositoryManager outputRepository, ArtifactContext artifactContext, File content) {
        try {
            outputRepository.putArtifact(artifactContext, content);
        }
        catch (Exception e) {
            throw new CeylondException("error.failedWriteArtifact", new Object[]{artifactContext, e.getLocalizedMessage()}, e);
        }
    }

    private boolean isEmpty(Module module) {
        for (Package pkg : this.getPackages(module)) {
            if (pkg.getMembers().isEmpty()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void documentModule(Module module) throws IOException {
        try {
            this.currentModule = module;
            this.clearModuleUrlAvailabilityCache();
            this.doc(module);
            this.makeApiIndex(module);
            this.makeIndex(module);
            this.makeSearch(module);
            File resourcesDir = this.getResourcesDir(module);
            this.copyResource("resources/ceylondoc.css", new File(resourcesDir, "ceylondoc.css"));
            this.copyResource("resources/ceylondoc.js", new File(resourcesDir, "ceylondoc.js"));
            this.copyResource("resources/bootstrap.min.css", new File(resourcesDir, "bootstrap.min.css"));
            this.copyResource("resources/bootstrap.min.js", new File(resourcesDir, "bootstrap.min.js"));
            this.copyResource("resources/jquery-1.8.2.min.js", new File(resourcesDir, "jquery-1.8.2.min.js"));
            this.copyResource("resources/ceylon.css", new File(resourcesDir, "ceylon.css"));
            this.copyResource("resources/rainbow.min.js", new File(resourcesDir, "rainbow.min.js"));
            this.copyResource("resources/rainbow.linenumbers.js", new File(resourcesDir, "rainbow.linenumbers.js"));
            this.copyResource("resources/ceylon.js", new File(resourcesDir, "ceylon.js"));
            this.copyResource("resources/favicon.ico", new File(resourcesDir, "favicon.ico"));
            this.copyResource("resources/ceylondoc-logo.png", new File(resourcesDir, "ceylondoc-logo.png"));
            this.copyResource("resources/ceylondoc-icons.png", new File(resourcesDir, "ceylondoc-icons.png"));
            this.copyResource("resources/NOTICE.txt", new File(this.getApiOutputFolder(module), "NOTICE.txt"));
        }
        finally {
            this.currentModule = null;
        }
    }

    private void clearModuleUrlAvailabilityCache() {
        String[] moduleUrls;
        for (String moduleUrl : moduleUrls = this.moduleUrlAvailabilityCache.keySet().toArray(new String[0])) {
            if (!LinkRenderer.isFileProtocol(moduleUrl)) continue;
            this.moduleUrlAvailabilityCache.remove(moduleUrl);
        }
    }

    private void collectSubclasses() throws IOException {
        for (Module module : this.modules) {
            for (Package pkg : this.getPackages(module)) {
                for (Declaration decl : pkg.getMembers()) {
                    ArrayList<Type> satisfiedTypes;
                    Type superclass;
                    if (!this.shouldInclude(decl) || !(decl instanceof ClassOrInterface)) continue;
                    ClassOrInterface c = (ClassOrInterface)decl;
                    if (c instanceof Class && (superclass = c.getExtendedType()) != null) {
                        TypeDeclaration superdec = superclass.getDeclaration();
                        if (this.subclasses.get(superdec) == null) {
                            this.subclasses.put(superdec, new ArrayList());
                        }
                        this.subclasses.get(superdec).add((Class)c);
                    }
                    if ((satisfiedTypes = new ArrayList<Type>(c.getSatisfiedTypes())) == null || satisfiedTypes.isEmpty()) continue;
                    for (Type satisfiedType : satisfiedTypes) {
                        TypeDeclaration superdec = satisfiedType.getDeclaration();
                        if (this.satisfyingClassesOrInterfaces.get(superdec) == null) {
                            this.satisfyingClassesOrInterfaces.put(superdec, new ArrayList());
                        }
                        this.satisfyingClassesOrInterfaces.get(superdec).add(c);
                    }
                }
            }
        }
    }

    private void collectAnnotationConstructors() {
        for (Module module : this.modules) {
            for (Package pkg : this.getPackages(module)) {
                for (Declaration decl : pkg.getMembers()) {
                    if (!(decl instanceof Function) || !decl.isAnnotation() || !this.shouldInclude(decl)) continue;
                    Function annotationCtor = (Function)decl;
                    TypeDeclaration annotationType = annotationCtor.getTypeDeclaration();
                    List<Function> annotationConstructorList = this.annotationConstructors.get(annotationType);
                    if (annotationConstructorList == null) {
                        annotationConstructorList = new ArrayList<Function>();
                        this.annotationConstructors.put(annotationType, annotationConstructorList);
                    }
                    annotationConstructorList.add(annotationCtor);
                }
            }
        }
    }

    private Writer openWriter(File file) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSearch(Module module) throws IOException {
        try (Writer writer = this.openWriter(new File(this.getApiOutputFolder(module), "search.html"));){
            new Search(module, this, writer).generate();
        }
    }

    private void buildNodesMaps() {
        for (final PhasedUnit pu : this.phasedUnits) {
            Tree.CompilationUnit cu = pu.getCompilationUnit();
            Walker.walkCompilationUnit(new Visitor(){

                @Override
                public void visit(Tree.Declaration that) {
                    CeylonDocTool.this.modelUnitMap.put(that.getDeclarationModel(), pu);
                    CeylonDocTool.this.modelNodeMap.put(that.getDeclarationModel(), that);
                    super.visit(that);
                }

                @Override
                public void visit(Tree.ObjectDefinition that) {
                    if (that.getDeclarationModel() != null && that.getDeclarationModel().getTypeDeclaration() != null) {
                        TypeDeclaration typeDecl = that.getDeclarationModel().getTypeDeclaration();
                        CeylonDocTool.this.modelUnitMap.put(typeDecl, pu);
                        CeylonDocTool.this.modelNodeMap.put(typeDecl, that);
                    }
                    super.visit(that);
                }

                @Override
                public void visit(Tree.PackageDescriptor that) {
                    if (that.getImportPath() != null && that.getImportPath().getModel() != null) {
                        Referenceable model = that.getImportPath().getModel();
                        CeylonDocTool.this.modelUnitMap.put(model, pu);
                        CeylonDocTool.this.modelNodeMap.put(model, that);
                    }
                    super.visit(that);
                }

                @Override
                public void visit(Tree.ModuleDescriptor that) {
                    if (that.getImportPath() != null && that.getImportPath().getModel() != null) {
                        Referenceable model = that.getImportPath().getModel();
                        CeylonDocTool.this.modelUnitMap.put(model, pu);
                        CeylonDocTool.this.modelNodeMap.put(model, that);
                    }
                    super.visit(that);
                }

                @Override
                public void visit(Tree.SpecifierStatement that) {
                    CeylonDocTool.this.modelUnitMap.put(that.getDeclaration(), pu);
                    CeylonDocTool.this.modelNodeMap.put(that.getDeclaration(), that);
                    super.visit(that);
                }

                @Override
                public void visit(Tree.Parameter param) {
                    CeylonDocTool.this.parameterUnitMap.put(param.getParameterModel(), pu);
                    CeylonDocTool.this.parameterNodeMap.put(param.getParameterModel(), param);
                    super.visit(param);
                }
            }, cu);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copySourceFiles() throws FileNotFoundException, IOException {
        for (PhasedUnit pu : this.phasedUnits) {
            Package pkg = pu.getUnit().getPackage();
            if (!this.shouldInclude(pkg)) continue;
            File file = new File(this.getFolder(pu.getPackage()), pu.getUnitFile().getName() + ".html");
            File dir = file.getParentFile();
            if (!dir.exists() && !FileUtil.mkdirs(dir)) {
                throw new IOException(CeylondMessages.msg("error.couldNotCreateDirectory", file));
            }
            try (Writer writer = this.openWriter(file);){
                Markup markup = new Markup(writer);
                markup.write("<!DOCTYPE html>");
                markup.open("html xmlns='http://www.w3.org/1999/xhtml'");
                markup.open("head");
                markup.tag("meta charset='UTF-8'");
                markup.around("title", pu.getUnit().getFilename());
                markup.tag("link href='" + this.getResourceUrl(pkg, "favicon.ico") + "' rel='shortcut icon'");
                markup.tag("link href='" + this.getResourceUrl(pkg, "ceylon.css") + "' rel='stylesheet' type='text/css'");
                markup.tag("link href='" + this.getResourceUrl(pkg, "ceylondoc.css") + "' rel='stylesheet' type='text/css'");
                markup.tag("link href='//fonts.googleapis.com/css?family=Inconsolata' rel='stylesheet' type='text/css'");
                markup.open("script type='text/javascript'");
                markup.write("var resourceBaseUrl = '" + this.getResourceUrl(pkg, "") + "'");
                markup.close("script");
                markup.around("script src='" + this.getResourceUrl(pkg, "jquery-1.8.2.min.js") + "' type='text/javascript'", new String[0]);
                markup.around("script src='" + this.getResourceUrl(pkg, "rainbow.min.js") + "' type='text/javascript'", new String[0]);
                markup.around("script src='" + this.getResourceUrl(pkg, "rainbow.linenumbers.js") + "' type='text/javascript'", new String[0]);
                markup.around("script src='" + this.getResourceUrl(pkg, "ceylon.js") + "' type='text/javascript'", new String[0]);
                markup.around("script src='" + this.getResourceUrl(pkg, "ceylondoc.js") + "' type='text/javascript'", new String[0]);
                markup.close("head");
                markup.open("body", "pre data-language='ceylon' style='font-family: Inconsolata, Monaco, Courier, monospace'");
                try (BufferedReader input = new BufferedReader(new InputStreamReader(pu.getUnitFile().getInputStream()));){
                    String line = input.readLine();
                    while (line != null) {
                        markup.text(line, "\n");
                        line = input.readLine();
                    }
                }
                markup.close("pre", "body", "html");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doc(Module module) throws IOException {
        try (Writer rootWriter = this.openWriter(this.getObjectFile(module));){
            ModuleDoc moduleDoc = new ModuleDoc(this, rootWriter, module);
            moduleDoc.generate();
            for (Package pkg : this.getPackages(module)) {
                if (pkg.getMembers().isEmpty()) continue;
                if (!this.isRootPackage(module, pkg)) {
                    try (Writer packageWriter = this.openWriter(this.getObjectFile(pkg));){
                        new PackageDoc(this, packageWriter, pkg).generate();
                    }
                }
                for (Declaration decl : pkg.getMembers()) {
                    this.doc(decl);
                }
                if (!pkg.getNameAsString().equals("ceylon.language")) continue;
                this.docNothingType(pkg);
            }
        }
    }

    private void docNothingType(Package pkg) throws IOException {
        final Annotation nothingDoc = new Annotation();
        nothingDoc.setName("doc");
        nothingDoc.addPositionalArgment("The special type _Nothing_ represents: \n - the intersection of all types, or, equivalently \n - the empty set \n\n_Nothing_ is assignable to all other types, but has no instances. \nA reference to a member of an expression of type _Nothing_ is always an error, since there can never be a receiving instance. \n_Nothing_ is considered to belong to the module _ceylon.language_. However, it cannot be defined within the language. \n\nBecause of the restrictions imposed by Ceylon's mixin inheritance model: \n- If X and Y are classes, and X is not a subclass of Y, and Y is not a subclass of X, then the intersection type X&Y is equivalent to _Nothing_. \n- If X is an interface, the intersection type X&Nothing is equivalent to _Nothing_. \n- If X&lt;T&gt; is invariant in its type parameter T, and the distinct types A and B do not involve type parameters, then X&lt;A&gt;&X&lt;B&gt; is equivalent to _Nothing_. \n");
        NothingType nothingType = new NothingType(pkg.getUnit()){

            @Override
            public List<Annotation> getAnnotations() {
                return Collections.singletonList(nothingDoc);
            }
        };
        this.doc(nothingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeIndex(Module module) throws IOException {
        File dir = this.getResourcesDir(module);
        try (Writer writer = this.openWriter(new File(dir, "index.js"));){
            new IndexDoc(this, writer, module).generate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeApiIndex(Module module) throws IOException {
        try (Writer writer = this.openWriter(new File(this.getApiOutputFolder(module), "api-index.html"));){
            new IndexApiDoc(this, writer, module).generate();
        }
    }

    private File getResourcesDir(Module module) throws IOException {
        File dir = new File(this.getApiOutputFolder(module), this.resourceFolder);
        if (!dir.exists() && !FileUtil.mkdirs(dir)) {
            throw new IOException();
        }
        return dir;
    }

    protected boolean isRootPackage(Module module, Package pkg) {
        if (module.isDefault()) {
            return pkg.getNameAsString().isEmpty();
        }
        return pkg.getNameAsString().equals(module.getNameAsString());
    }

    private void copyResource(String path, File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists() && !FileUtil.mkdirs(dir)) {
            throw new IOException();
        }
        try (InputStream resource = this.getClass().getResourceAsStream(path);){
            this.copy(resource, file);
        }
    }

    private void copy(InputStream resource, File file) throws FileNotFoundException, IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            int read;
            byte[] buf = new byte[1024];
            while ((read = resource.read(buf)) > -1) {
                ((OutputStream)os).write(buf, 0, read);
            }
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doc(Declaration decl) throws IOException {
        if (decl instanceof TypeDeclaration && this.shouldInclude(decl)) {
            try (Writer writer = this.openWriter(this.getObjectFile(decl));){
                new ClassDoc(this, writer, (TypeDeclaration)decl).generate();
            }
        }
    }

    protected Package getPackage(Declaration decl) {
        Scope scope = decl.getContainer();
        while (!(scope instanceof Package)) {
            scope = scope.getContainer();
        }
        return (Package)scope;
    }

    protected Module getModule(Object modPkgOrDecl) {
        if (modPkgOrDecl instanceof Module) {
            return (Module)modPkgOrDecl;
        }
        if (modPkgOrDecl instanceof Package) {
            return ((Package)modPkgOrDecl).getModule();
        }
        if (modPkgOrDecl instanceof Declaration) {
            return this.getPackage((Declaration)modPkgOrDecl).getModule();
        }
        throw new RuntimeException();
    }

    List<Package> getPackages(Module module) {
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Package pkg : module.getPackages()) {
            if (!this.shouldInclude(pkg)) continue;
            packages.add(pkg);
        }
        Collections.sort(packages, Util.ReferenceableComparatorByName.INSTANCE);
        return packages;
    }

    protected boolean shouldInclude(Declaration decl) {
        if (!this.includeNonShared && !decl.isShared()) {
            return false;
        }
        return !decl.isNativeImplementation();
    }

    protected boolean shouldInclude(Package pkg) {
        return (this.includeNonShared || pkg.isShared()) && pkg.getMembers().size() > 0;
    }

    protected boolean shouldInclude(Module module) {
        return this.modules.contains(module);
    }

    private URI getAbsoluteObjectUrl(Object obj) throws IOException {
        File f = this.getObjectFile(obj);
        if (f == null) {
            throw new RuntimeException(CeylondMessages.msg("error.noPage", obj));
        }
        return f.toURI();
    }

    private URI getBaseUrl(Module module) throws IOException {
        return this.getApiOutputFolder(module).getCanonicalFile().toURI();
    }

    private URI relativize(Module module, URI uri, URI uri2) throws IOException {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException(CeylondMessages.msg("error.expectedUriToBeAbsolute", uri));
        }
        if (!uri2.isAbsolute()) {
            throw new IllegalArgumentException(CeylondMessages.msg("error.expectedUriToBeAbsolute", uri2));
        }
        URI baseUrl = this.getBaseUrl(module);
        StringBuilder sb = new StringBuilder();
        URI r = uri;
        if (!r.equals(baseUrl) && !(r = uri.resolve(URI.create(sb.toString()))).equals(baseUrl)) {
            r = uri;
        }
        while (!r.equals(baseUrl)) {
            sb.append("../");
            r = uri.resolve(URI.create(sb.toString()));
        }
        URI result = URI.create(sb.toString() + baseUrl.relativize(uri2));
        if (result.isAbsolute()) {
            // empty if block
        }
        if (!uri.resolve(result).equals(uri2)) {
            throw new RuntimeException(CeylondMessages.msg("error.failedUriRelativize", uri, uri2, result));
        }
        return result;
    }

    protected String getObjectUrl(Object from, Object to) throws IOException {
        return this.getObjectUrl(from, to, true);
    }

    protected String getObjectUrl(Object from, Object to, boolean withFragment) throws IOException {
        Module module = this.getModule(from);
        URI fromUrl = this.getAbsoluteObjectUrl(from);
        URI toUrl = this.getAbsoluteObjectUrl(to);
        String result = this.relativize(module, fromUrl, toUrl).toString();
        if (withFragment && to instanceof Package && this.isRootPackage(module, (Package)to)) {
            result = result + "#section-package";
        }
        return result;
    }

    protected String getResourceUrl(Object from, String to) throws IOException {
        Module module = this.getModule(from);
        URI fromUrl = this.getAbsoluteObjectUrl(from);
        URI toUrl = this.getBaseUrl(module).resolve(this.resourceFolder + "/" + to);
        String result = this.relativize(module, fromUrl, toUrl).toString();
        return result;
    }

    protected String getSrcUrl(Object from, Object modPkgOrDecl) throws IOException {
        String result;
        File folder;
        String filename;
        URI fromUrl = this.getAbsoluteObjectUrl(from);
        Module module = this.getModule(from);
        if (modPkgOrDecl instanceof Element) {
            Unit unit = ((Element)modPkgOrDecl).getUnit();
            filename = unit.getFilename();
            folder = this.getFolder(unit.getPackage());
        } else if (modPkgOrDecl instanceof Package) {
            filename = "package.ceylon";
            folder = this.getFolder((Package)modPkgOrDecl);
        } else if (modPkgOrDecl instanceof Module) {
            Module moduleDecl = (Module)modPkgOrDecl;
            folder = this.getApiOutputFolder(moduleDecl);
            filename = "module.ceylon";
        } else {
            throw new RuntimeException(CeylondMessages.msg("error.unexpected", modPkgOrDecl));
        }
        File srcFile = new File(folder, filename + ".html").getCanonicalFile();
        if (srcFile.exists()) {
            URI url = srcFile.toURI();
            result = this.relativize(module, fromUrl, url).toString();
        } else {
            result = null;
        }
        return result;
    }

    protected PhasedUnit getUnit(Referenceable referenceable) {
        return this.modelUnitMap.get(referenceable);
    }

    protected Node getNode(Referenceable referenceable) {
        return this.modelNodeMap.get(referenceable);
    }

    protected PhasedUnit getParameterUnit(Parameter parameter) {
        return this.parameterUnitMap.get(parameter);
    }

    protected Node getParameterNode(Parameter parameter) {
        return this.parameterNodeMap.get(parameter);
    }

    protected List<Function> getAnnotationConstructors(TypeDeclaration klass) {
        return this.annotationConstructors.get(klass);
    }

    protected List<ClassOrInterface> getSatisfyingClassesOrInterfaces(TypeDeclaration klass) {
        return this.satisfyingClassesOrInterfaces.get(klass);
    }

    protected List<Class> getSubclasses(TypeDeclaration klass) {
        return this.subclasses.get(klass);
    }

    protected Map<String, Boolean> getModuleUrlAvailabilityCache() {
        return this.moduleUrlAvailabilityCache;
    }

    protected int[] getDeclarationSrcLocation(Declaration decl) {
        Node node = this.modelNodeMap.get(decl);
        if (node == null) {
            return null;
        }
        return new int[]{node.getToken().getLine(), node.getEndToken().getLine()};
    }

    protected Module getCurrentModule() {
        return this.currentModule;
    }

    public List<Module> getDocumentedModules() {
        return this.modules;
    }

    protected TypeChecker getTypeChecker() {
        return this.typeChecker;
    }

    protected Logger getLogger() {
        return this.log;
    }

    protected void warningMissingDoc(String name, Referenceable scope) {
        if (!this.ignoreMissingDoc) {
            this.log.warning(CeylondMessages.msg("warn.missingDoc", name, this.getPosition(this.getNode(scope))));
        }
    }

    protected void warningBrokenLink(String docLinkText, Tree.DocLink docLink, Referenceable scope) {
        if (!this.ignoreBrokenLink) {
            this.log.warning(CeylondMessages.msg("warn.brokenLink", docLinkText, this.getWhere(scope), this.getPosition(docLink)));
        }
    }

    protected void warningSetterDoc(String name, Declaration scope) {
        this.log.warning(CeylondMessages.msg("warn.setterDoc", name, this.getPosition(this.getNode(scope))));
    }

    protected void warningMissingThrows(Declaration d) {
        if (this.ignoreMissingThrows) {
            return;
        }
        Scope scope = d.getScope();
        final PhasedUnit unit = this.getUnit(d);
        Node node = this.getNode(d);
        if (scope == null || unit == null || unit.getUnit() == null || node == null || !(d instanceof FunctionOrValue)) {
            return;
        }
        ArrayList<Type> documentedExceptions = new ArrayList<Type>();
        for (Annotation annotation : d.getAnnotations()) {
            if (!annotation.getName().equals("throws")) continue;
            String exceptionName = annotation.getPositionalArguments().get(0);
            Declaration exceptionDecl = scope.getMemberOrParameter(unit.getUnit(), exceptionName, null, false);
            if (!(exceptionDecl instanceof TypeDeclaration)) continue;
            documentedExceptions.add(((TypeDeclaration)exceptionDecl).getType());
        }
        final ArrayList thrownExceptions = new ArrayList();
        node.visitChildren(new Visitor(){

            @Override
            public void visit(Tree.Throw that) {
                Tree.Expression expression = that.getExpression();
                if (expression != null) {
                    thrownExceptions.add(expression.getTypeModel());
                } else {
                    thrownExceptions.add(unit.getUnit().getExceptionType());
                }
            }

            @Override
            public void visit(Tree.Declaration that) {
            }
        });
        for (Type thrownException : thrownExceptions) {
            boolean isDocumented = false;
            for (Type documentedException : documentedExceptions) {
                if (!thrownException.isSubtypeOf(documentedException)) continue;
                isDocumented = true;
                break;
            }
            if (isDocumented) continue;
            this.log.warning(CeylondMessages.msg("warn.missingThrows", thrownException.asString(), this.getWhere(d), this.getPosition(this.getNode(d))));
        }
    }

    private String getWhere(Referenceable scope) {
        String where = "";
        if (scope instanceof Module) {
            where = where + "module ";
        } else if (scope instanceof Package) {
            where = where + "package ";
        } else if (scope instanceof Class) {
            where = where + "class ";
        } else if (scope instanceof Interface) {
            where = where + "interface ";
        } else if (scope instanceof TypeAlias) {
            where = where + "type alias ";
        } else if (scope instanceof TypeParameter) {
            where = where + "type parameter ";
        } else if (scope instanceof Function) {
            where = ((Function)scope).isToplevel() ? where + "function " : where + "method ";
        } else if (scope instanceof Value) {
            where = ((Value)scope).isToplevel() ? where + "value " : (((Value)scope).isParameter() ? where + "parameter " : where + "attribute ");
        }
        where = scope instanceof Declaration ? where + ((Declaration)scope).getQualifiedNameString() : where + scope.getNameAsString();
        return where;
    }

    private String getPosition(Node node) {
        if (node != null && node.getToken() != null && node.getUnit() != null && node.getUnit().getFilename() != null) {
            return "(" + node.getUnit().getFilename() + ":" + node.getToken().getLine() + ")";
        }
        return "";
    }

    public ModuleSourceMapper getModuleSourceMapper() {
        return this.typeChecker.getPhasedUnits().getModuleSourceMapper();
    }
}

