/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.ClassOrPackageDoc;
import com.redhat.ceylon.ceylondoc.LinkRenderer;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class ClassDoc
extends ClassOrPackageDoc {
    private TypeDeclaration klass;
    private SortedMap<String, Declaration> constructors;
    private SortedMap<String, SortedSet<Function>> methods;
    private SortedMap<String, TypedDeclaration> attributes;
    private SortedMap<String, Interface> innerInterfaces;
    private SortedMap<String, Class> innerClasses;
    private SortedMap<String, Class> innerExceptions;
    private SortedMap<String, TypeAlias> innerAliases;
    private List<TypeDeclaration> superInterfaces;
    private List<TypeDeclaration> superClasses;
    private Map<MemberSpecification, Map<TypeDeclaration, SortedMap<String, Declaration>>> superclassInheritedMembers = new HashMap<MemberSpecification, Map<TypeDeclaration, SortedMap<String, Declaration>>>(2);
    private Map<MemberSpecification, Map<TypeDeclaration, SortedMap<String, Declaration>>> interfaceInheritedMembers = new HashMap<MemberSpecification, Map<TypeDeclaration, SortedMap<String, Declaration>>>(2);
    private MemberSpecification attributeSpecification = new MemberSpecification(){

        @Override
        public boolean isSatisfiedBy(Declaration decl) {
            return decl instanceof Value;
        }
    };
    private MemberSpecification methodSpecification = new MemberSpecification(){

        @Override
        public boolean isSatisfiedBy(Declaration decl) {
            return decl instanceof Function;
        }
    };
    private Comparator<Function> overloadedFunctionComperator = new Comparator<Function>(){

        @Override
        public int compare(Function f1, Function f2) {
            List<ParameterList> parameterLists1 = f1.getParameterLists();
            List<ParameterList> parameterLists2 = f2.getParameterLists();
            int result = Integer.compare(parameterLists1.size(), parameterLists2.size());
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < parameterLists1.size(); ++i) {
                List<Parameter> parameterList1 = parameterLists1.get(i).getParameters();
                List<Parameter> parameterList2 = parameterLists2.get(i).getParameters();
                result = Integer.compare(parameterList1.size(), parameterList2.size());
                if (result == 0) continue;
                return result;
            }
            String signature1 = f1.toString();
            String signature2 = f2.toString();
            result = signature1.compareTo(signature2);
            return result;
        }
    };

    public ClassDoc(CeylonDocTool tool, Writer writer, TypeDeclaration klass) throws IOException {
        super(tool.getModule(klass), tool, writer);
        this.klass = klass;
        this.loadMembers();
    }

    private void loadMembers() {
        this.constructors = new TreeMap<String, Declaration>();
        this.methods = new TreeMap<String, SortedSet<Function>>();
        this.attributes = new TreeMap<String, TypedDeclaration>();
        this.innerInterfaces = new TreeMap<String, Interface>();
        this.innerClasses = new TreeMap<String, Class>();
        this.innerExceptions = new TreeMap<String, Class>();
        this.innerAliases = new TreeMap<String, TypeAlias>();
        this.superClasses = Util.getAncestors(this.klass);
        this.superInterfaces = Util.getSuperInterfaces(this.klass);
        for (Declaration m : this.klass.getMembers()) {
            if (!this.tool.shouldInclude(m)) continue;
            if (ModelUtil.isConstructor(m)) {
                this.addTo(this.constructors, m);
                continue;
            }
            if (m instanceof Value) {
                this.addTo(this.attributes, (Value)m);
                continue;
            }
            if (m instanceof Function) {
                if (m.isAbstraction() && m.getOverloads().size() > 0) continue;
                this.addTo(this.methods, (Function)m);
                continue;
            }
            if (m instanceof Interface) {
                this.addTo(this.innerInterfaces, (Interface)m);
                continue;
            }
            if (m instanceof Class) {
                Class c = (Class)m;
                if (Util.isThrowable(c)) {
                    this.addTo(this.innerExceptions, c);
                    continue;
                }
                this.addTo(this.innerClasses, c);
                continue;
            }
            if (!(m instanceof TypeAlias)) continue;
            this.addTo(this.innerAliases, (TypeAlias)m);
        }
        Collections.sort(this.superInterfaces, Util.ReferenceableComparatorByName.INSTANCE);
        this.loadInheritedMembers(this.attributeSpecification, this.superClasses, this.superclassInheritedMembers);
        this.loadInheritedMembers(this.methodSpecification, this.superClasses, this.superclassInheritedMembers);
        this.loadInheritedMembers(this.attributeSpecification, this.superInterfaces, this.interfaceInheritedMembers);
        this.loadInheritedMembers(this.methodSpecification, this.superInterfaces, this.interfaceInheritedMembers);
    }

    private <T extends Declaration> void addTo(SortedMap<String, T> map, T decl) {
        map.put(Util.getDeclarationName(decl), decl);
        for (String alias : decl.getAliases()) {
            map.put(alias, decl);
        }
    }

    private void addTo(SortedMap<String, SortedSet<Function>> map, Function decl) {
        String declName = Util.getDeclarationName(decl);
        SortedSet<Function> overloadedDeclSet = (TreeSet<Function>)map.get(declName);
        if (overloadedDeclSet == null) {
            overloadedDeclSet = new TreeSet<Function>(this.overloadedFunctionComperator);
            map.put(declName, overloadedDeclSet);
        }
        overloadedDeclSet.add(decl);
        for (String alias : decl.getAliases()) {
            overloadedDeclSet = (SortedSet)map.get(alias);
            if (overloadedDeclSet == null) {
                overloadedDeclSet = new TreeSet<Function>(this.overloadedFunctionComperator);
                map.put(alias, overloadedDeclSet);
            }
            overloadedDeclSet.add(decl);
        }
    }

    private void loadInheritedMembers(MemberSpecification specification, List<TypeDeclaration> superClassOrInterfaceList, Map<MemberSpecification, Map<TypeDeclaration, SortedMap<String, Declaration>>> superClassOrInterfaceInheritedMemebers) {
        LinkedHashMap inheritedMembersMap = new LinkedHashMap();
        for (TypeDeclaration superClassOrInterface : superClassOrInterfaceList) {
            TreeMap<String, Declaration> inheritedMembers = new TreeMap<String, Declaration>();
            for (Declaration member : superClassOrInterface.getMembers()) {
                if (!specification.isSatisfiedBy(member) || !this.tool.shouldInclude(member)) continue;
                inheritedMembers.put(Util.getDeclarationName(member), member);
                for (String alias : member.getAliases()) {
                    inheritedMembers.put(alias, member);
                }
            }
            if (inheritedMembers.isEmpty()) continue;
            inheritedMembersMap.put(superClassOrInterface, inheritedMembers);
        }
        superClassOrInterfaceInheritedMemebers.put(specification, inheritedMembersMap);
    }

    private boolean isObject() {
        return this.klass instanceof Class && this.klass.isAnonymous();
    }

    private boolean hasInitializer() {
        return this.klass instanceof Class && !this.isObject() && this.constructors.isEmpty();
    }

    private boolean hasAnyAttributes() {
        return !this.attributes.isEmpty() || !this.interfaceInheritedMembers.get(this.attributeSpecification).isEmpty() || !this.superclassInheritedMembers.get(this.attributeSpecification).isEmpty();
    }

    private boolean hasAnyMethods() {
        return !this.methods.isEmpty() || !this.interfaceInheritedMembers.get(this.methodSpecification).isEmpty() || !this.superclassInheritedMembers.get(this.methodSpecification).isEmpty();
    }

    private String getClassLabel() {
        if (this.klass.isDynamic()) {
            return "dynamic";
        }
        if (this.klass instanceof Interface) {
            return "interface";
        }
        if (this.klass.isAnnotation()) {
            return "annotation";
        }
        if (this.isObject()) {
            return "object";
        }
        return "class";
    }

    public void generate() throws IOException {
        this.writeHeader(Util.capitalize(this.getClassLabel()) + " " + this.klass.getName(), new String[0]);
        this.writeNavBar();
        this.writeSubNavBar();
        this.open("div class='container-fluid'");
        this.writeDescription();
        if (this.hasInitializer()) {
            this.writeInitializer((Class)this.klass);
        }
        if (!this.constructors.isEmpty()) {
            this.writeConstructors();
        }
        if (this.hasAnyAttributes()) {
            this.open("div id='section-attributes'");
            this.writeAttributes();
            this.writeInheritedMembers(this.attributeSpecification, "Inherited Attributes", "Attributes inherited from: ");
            this.close("div");
        }
        if (this.hasAnyMethods()) {
            this.open("div id='section-methods'");
            this.writeMethods();
            this.writeInheritedMembers(this.methodSpecification, "Inherited Methods", "Methods inherited from: ");
            this.close("div");
        }
        this.writeInnerTypes(this.innerAliases, "section-nested-aliases", "Nested Aliases");
        this.writeInnerTypes(this.innerInterfaces, "section-nested-interfaces", "Nested Interfaces");
        this.writeInnerTypes(this.innerClasses, "section-nested-classes", "Nested Classes");
        this.writeInnerTypes(this.innerExceptions, "section-nested-exceptions", "Nested Exceptions");
        this.close("div");
        this.writeFooter(new String[0]);
    }

    private void writeSubNavBar() throws IOException {
        Package pkg = this.tool.getPackage(this.klass);
        this.open("div class='sub-navbar'");
        this.writeLinkSourceCode(this.klass);
        this.open("div class='sub-navbar-inner'");
        this.open("span class='sub-navbar-package'");
        this.writeIcon(pkg);
        this.writePackageNavigation(pkg);
        this.close("span");
        this.write("<br/>");
        this.writeClassSignature();
        this.close("div");
        this.open("div class='sub-navbar-menu'");
        this.writeSubNavBarLink(this.linkRenderer().to(this.module).getUrl(), "Overview", 'O', "Jump to module documentation");
        this.writeSubNavBarLink(this.linkRenderer().to(pkg).getUrl(), "Package", 'P', "Jump to package documentation");
        if (this.hasInitializer()) {
            this.writeSubNavBarLink("#section-initializer", "Initializer", 'z', "Jump to initializer");
        }
        if (!this.constructors.isEmpty()) {
            this.writeSubNavBarLink("#section-constructors", "Constructors", 't', "Jump to constructors");
        }
        if (this.hasAnyAttributes()) {
            this.writeSubNavBarLink("#section-attributes", "Attributes", 'A', "Jump to attributes");
        }
        if (this.hasAnyMethods()) {
            this.writeSubNavBarLink("#section-methods", "Methods", 'M', "Jump to methods");
        }
        if (!this.innerAliases.isEmpty()) {
            this.writeSubNavBarLink("#section-nested-aliases", "Nested Aliases", 'l', "Jump to nested aliases");
        }
        if (!this.innerInterfaces.isEmpty()) {
            this.writeSubNavBarLink("#section-nested-interfaces", "Nested Interfaces", 'I', "Jump to nested interfaces");
        }
        if (!this.innerClasses.isEmpty()) {
            this.writeSubNavBarLink("#section-nested-classes", "Nested Classes", 'C', "Jump to nested classes");
        }
        if (!this.innerExceptions.isEmpty()) {
            this.writeSubNavBarLink("#section-nested-exceptions", "Nested Exceptions", 'E', "Jump to nested exceptions");
        }
        if (this.isObject()) {
            this.writeSubNavBarLink(this.linkRenderer().to(this.klass.getContainer()).useAnchor(this.klass.getName()).getUrl(), "Singleton object declaration", '\u0000', "Jump to singleton object declaration");
        }
        this.close("div");
        this.close("div");
    }

    private void writeClassSignature() throws IOException {
        this.open("span class='sub-navbar-label'");
        this.write(this.getClassLabel());
        this.close("span");
        this.writeIcon(this.klass);
        this.open("span class='sub-navbar-name'");
        this.writeQualifyingType(this.klass);
        this.open("span class='type-identifier'");
        this.write(this.klass.getName());
        this.close("span");
        this.writeTypeParameters(this.klass.getTypeParameters(), this.klass);
        this.close("span");
        this.writeInheritance(this.klass);
        this.writeTypeParametersConstraints(this.klass.getTypeParameters(), this.klass);
    }

    private void writeQualifyingType(TypeDeclaration klass) throws IOException {
        if (klass.isClassOrInterfaceMember()) {
            TypeDeclaration container = (TypeDeclaration)klass.getContainer();
            this.writeQualifyingType(container);
            this.linkRenderer().to(container).useScope(klass).write();
            this.write(".");
        }
    }

    private void writeDescription() throws IOException {
        this.open("div class='class-description'");
        this.writeTagged(this.klass);
        this.writeTabs();
        this.close("div");
    }

    private void writeTabs() throws IOException {
        boolean hasTypeHierarchy = this.klass instanceof Class;
        boolean hasSupertypeHierarchy = this.klass instanceof Class || !Util.isEmpty(this.klass.getSatisfiedTypes());
        boolean hasSubtypeHierarchy = !Util.isEmpty(this.tool.getSubclasses(this.klass)) || !Util.isEmpty(this.tool.getSatisfyingClassesOrInterfaces(this.klass));
        this.open("div class='type-tabs section'");
        this.open("div class='tabbable'");
        this.open("ul class='nav nav-tabs'");
        this.writeTabNav("tabDocumentation", "Documentation", "icon-documentation", true, true, false);
        this.writeTabNav("tabTypeHierarchy", "Type Hierarchy", "icon-type-hierarchy", false, hasTypeHierarchy, false);
        this.writeTabNav("tabSupertypeHierarchy", "Supertype Hierarchy", "icon-supertype-hierarchy", false, hasSupertypeHierarchy, false);
        this.writeTabNav("tabSubtypeHierarchy", "Subtype Hierarchy", "icon-subtype-hierarchy", false, hasSubtypeHierarchy, Util.isEnumerated(this.klass));
        this.close("ul");
        this.open("div class='tab-content'");
        this.open("div class='tab-pane active' id='tabDocumentation'");
        this.writeAnnotationConstructors();
        this.around("div class='doc'", Util.getDoc(this.klass, this.linkRenderer()));
        this.writeBy(this.klass);
        this.writeSee(this.klass);
        this.close("div");
        this.open("div class='tab-pane' id='tabTypeHierarchy'");
        if (hasTypeHierarchy) {
            this.writeTypeHierarchy();
        } else {
            this.write("<p class='muted'><i>no type hierarchy</i></p>");
        }
        this.close("div");
        this.open("div class='tab-pane' id='tabSupertypeHierarchy'");
        if (hasSupertypeHierarchy) {
            this.writeSuperTypeHierarchy(Collections.singletonList(this.klass), 0);
        } else {
            this.write("<p class='muted'><i>no supertypes hierarchy</i></p>");
        }
        this.close("div");
        this.open("div class='tab-pane' id='tabSubtypeHierarchy'");
        if (hasSubtypeHierarchy) {
            this.writeSubtypesHierarchy(Collections.singletonList(this.klass), 0);
        } else {
            this.write("<p class='muted'><i>no subtypes hierarchy</i></p>");
        }
        this.close("div");
        this.close("div");
        this.close("div");
        this.close("div");
    }

    private void writeTabNav(String id, String name, String icon, boolean isActive, boolean isEnabled, boolean isEnumerated) throws IOException {
        this.write("<li" + (isActive ? " class='active'" : "") + ">");
        this.write("<a id='" + id + "Nav' href='#" + id + "' data-toggle='tab'>");
        this.write("<i class='" + icon + (isEnabled ? "" : "-disabled") + "'></i>");
        if (isEnumerated) {
            this.around("span class='label label-info' title='Enumerated type with an &quot;of&quot; clause'", "Enumerated");
            this.write(" ");
        }
        this.write("<span" + (isEnabled ? "" : " class='disabled'") + ">" + name + "</span>");
        this.write("</a>");
        this.write("</li>");
    }

    private void writeTypeHierarchy() throws IOException {
        LinkedList<Type> superTypes = new LinkedList<Type>();
        superTypes.add(this.klass.getType());
        for (Type type = this.klass.getExtendedType(); type != null; type = type.getExtendedType()) {
            superTypes.add(0, type);
        }
        int level = 0;
        for (Type superType : superTypes) {
            this.writeTypeHierarchyLevel(superType.getDeclaration(), level < superTypes.size() - 1);
            if (!Util.isEmpty(superType.getSatisfiedTypes())) {
                this.write("<a class='hint' title='Go to the Supertype Hierarchy' onClick='$(\"#tabSupertypeHierarchyNav\").tab(\"show\");'> ...and other supertypes</a>");
            }
            this.open("div class='subhierarchy'");
            ++level;
        }
        while (level-- > 0) {
            this.close("div");
            this.close("li", "ul");
        }
    }

    private void writeSuperTypeHierarchy(List<TypeDeclaration> types, int level) throws IOException {
        if (types.size() > 1) {
            Collections.sort(types, Util.ReferenceableComparatorByName.INSTANCE);
        }
        Iterator<TypeDeclaration> i$ = types.iterator();
        while (i$.hasNext()) {
            TypeDeclaration type;
            List<TypeDeclaration> supertypes = this.collectSupertypes(type = i$.next());
            this.writeTypeHierarchyLevel(type, !supertypes.isEmpty());
            this.open("div class='subhierarchy'");
            this.writeSuperTypeHierarchy(supertypes, level + 1);
            this.close("div");
            this.close("li", "ul");
        }
    }

    private void writeSubtypesHierarchy(List<TypeDeclaration> types, int level) throws IOException {
        if (types.size() > 1) {
            Collections.sort(types, Util.ReferenceableComparatorByName.INSTANCE);
        }
        Iterator<TypeDeclaration> i$ = types.iterator();
        while (i$.hasNext()) {
            TypeDeclaration type;
            List<TypeDeclaration> subtypes = this.collectSubtypes(type = i$.next());
            this.writeTypeHierarchyLevel(type, !subtypes.isEmpty());
            if (level == 0 && Util.isEnumerated(type)) {
                this.around("span class='keyword'", " of");
            }
            this.open("div class='subhierarchy'");
            this.writeSubtypesHierarchy(subtypes, level + 1);
            this.close("div");
            this.close("li", "ul");
        }
    }

    private void writeTypeHierarchyLevel(TypeDeclaration type, boolean hasSublevels) throws IOException {
        this.open("ul class='hierarchy-level'", "li");
        if (hasSublevels) {
            this.write("<span class='hierarchy-arrow-container' title='Click for expand/collapse'><span class='hierarchy-arrow-down'></span></span>");
        } else {
            this.write("<span class='hierarchy-arrow-none'></span>");
        }
        this.writeIcon(type);
        this.linkRenderer().to(type).useScope(this.klass).withinText(true).printTypeParameters(false).printAbbreviated(false).write();
    }

    private List<TypeDeclaration> collectSupertypes(TypeDeclaration type) {
        List<Type> satisfiedTypes;
        ArrayList<TypeDeclaration> supertypes = new ArrayList<TypeDeclaration>();
        if (type instanceof Class && type.getExtendedType() != null) {
            supertypes.add(type.getExtendedType().getDeclaration());
        }
        if ((satisfiedTypes = type.getSatisfiedTypes()) != null) {
            for (Type satisfiedType : satisfiedTypes) {
                supertypes.add(satisfiedType.getDeclaration());
            }
        }
        return supertypes;
    }

    private List<TypeDeclaration> collectSubtypes(TypeDeclaration type) {
        List<ClassOrInterface> satisfyingClassesOrInterfaces;
        ArrayList<TypeDeclaration> subtypes = new ArrayList<TypeDeclaration>();
        List<Class> subclasses = this.tool.getSubclasses(type);
        if (subclasses != null) {
            subtypes.addAll(subclasses);
        }
        if ((satisfyingClassesOrInterfaces = this.tool.getSatisfyingClassesOrInterfaces(type)) != null) {
            subtypes.addAll(satisfyingClassesOrInterfaces);
        }
        return subtypes;
    }

    private void writeListOnSummary(String cssClass, String title, List<?> types) throws IOException {
        if (!Util.isEmpty(types)) {
            this.open("div class='" + cssClass + " section'");
            this.around("span class='title'", title);
            boolean first = true;
            for (Object type : types) {
                if (!first) {
                    this.write(", ");
                } else {
                    first = false;
                }
                if (type instanceof TypedDeclaration) {
                    TypedDeclaration decl = (TypedDeclaration)type;
                    this.linkRenderer().to(decl).useScope(this.klass).write();
                    continue;
                }
                if (type instanceof ClassOrInterface) {
                    ClassOrInterface coi = (ClassOrInterface)type;
                    this.linkRenderer().to(coi).useScope(this.klass).printAbbreviated(!Util.isAbbreviatedType(coi)).write();
                    continue;
                }
                Type pt = (Type)type;
                this.linkRenderer().to(pt).useScope(this.klass).printAbbreviated(!Util.isAbbreviatedType(pt.getDeclaration())).write();
            }
            this.close("div");
        }
    }

    private void writeAnnotationConstructors() throws IOException {
        List<Function> annotationConstructors;
        if (this.klass.isAnnotation() && (annotationConstructors = this.tool.getAnnotationConstructors(this.klass)) != null) {
            Collections.sort(annotationConstructors, Util.ReferenceableComparatorByName.INSTANCE);
            this.writeListOnSummary("annotationConstructors", "Annotation Constructors: ", annotationConstructors);
        }
    }

    private void writeInheritedMembers(MemberSpecification specification, String tableTitle, String rowTitle) throws IOException {
        boolean first = true;
        Map<TypeDeclaration, SortedMap<String, Declaration>> superClassInheritedMembersMap = this.superclassInheritedMembers.get(specification);
        ArrayList<TypeDeclaration> superClasses = new ArrayList<TypeDeclaration>(this.superclassInheritedMembers.get(specification).keySet());
        Collections.sort(superClasses, Util.ReferenceableComparatorByName.INSTANCE);
        for (TypeDeclaration superClass : superClasses) {
            SortedMap<String, Declaration> inheritedMembers = superClassInheritedMembersMap.get(superClass);
            if (first) {
                first = false;
                this.openTable(null, tableTitle, 1, false);
            }
            this.writeInheritedMembersRow(rowTitle, superClass, inheritedMembers);
        }
        Map<TypeDeclaration, SortedMap<String, Declaration>> superInterfaceInheritedMembersMap = this.interfaceInheritedMembers.get(specification);
        ArrayList<TypeDeclaration> superInterfaces = new ArrayList<TypeDeclaration>(superInterfaceInheritedMembersMap.keySet());
        Collections.sort(superInterfaces, Util.ReferenceableComparatorByName.INSTANCE);
        for (TypeDeclaration superInterface : superInterfaces) {
            SortedMap<String, Declaration> members = superInterfaceInheritedMembersMap.get(superInterface);
            if (members == null || members.isEmpty()) continue;
            if (first) {
                first = false;
                this.openTable(null, tableTitle, 1, false);
            }
            this.writeInheritedMembersRow(rowTitle, superInterface, members);
        }
        if (!first) {
            this.closeTable();
        }
    }

    private void writeInheritedMembersRow(String title, TypeDeclaration superType, SortedMap<String, Declaration> members) throws IOException {
        this.open("tr", "td");
        this.write(title);
        this.writeIcon(superType);
        this.linkRenderer().to(superType).useScope(this.klass).withinText(true).write();
        this.open("div class='inherited-members'");
        boolean first = true;
        for (Map.Entry<String, Declaration> entry : members.entrySet()) {
            if (!first) {
                this.write(", ");
            } else {
                first = false;
            }
            String name = entry.getKey();
            Declaration member = entry.getValue();
            boolean alias = Util.nullSafeCompare(name, Util.getDeclarationName(member)) != 0;
            LinkRenderer linkRenderer = this.linkRenderer().withinText(true).to(member).useScope(this.klass).printMemberContainerName(false);
            if (alias) {
                StringBuilder sb = new StringBuilder();
                sb.append("<code><span class='");
                if (member instanceof TypeDeclaration) {
                    sb.append("type-");
                }
                sb.append("identifier'>");
                sb.append(name);
                sb.append("</span></code>");
                linkRenderer.useCustomText(sb.toString());
            }
            linkRenderer.write();
        }
        this.close("div");
        this.close("td", "tr");
    }

    private void writeInnerTypes(Map<String, ? extends TypeDeclaration> innerTypeDeclarations, String id, String title) throws IOException {
        if (!innerTypeDeclarations.isEmpty()) {
            this.openTable(id, title, 2, true);
            for (Map.Entry<String, ? extends TypeDeclaration> entry : innerTypeDeclarations.entrySet()) {
                TypeDeclaration innerTypeDeclaration = entry.getValue();
                String name = entry.getKey();
                if (innerTypeDeclaration instanceof ClassOrInterface) {
                    ClassOrInterface innerClassOrInterface = (ClassOrInterface)innerTypeDeclaration;
                    this.tool.doc(innerClassOrInterface);
                    this.doc(name, innerClassOrInterface);
                }
                if (!(innerTypeDeclaration instanceof TypeAlias)) continue;
                TypeAlias innerAlias = (TypeAlias)innerTypeDeclaration;
                this.doc(name, innerAlias);
            }
            this.closeTable();
        }
    }

    private void writeInitializer(Class klass) throws IOException {
        this.openTable("section-initializer", "Initializer", 1, true);
        this.open("tr", "td");
        this.writeParameterLinksIfRequired(klass);
        this.writeIcon(klass);
        this.open("code class='decl-label'");
        this.write(klass.getName());
        this.writeParameterList(klass, klass);
        this.close("code");
        this.open("div class='description'");
        this.writeParameters(klass);
        this.writeThrows(klass);
        this.close("div");
        this.close("td", "tr");
        this.closeTable();
    }

    private void writeConstructors() throws IOException {
        if (this.constructors.isEmpty()) {
            return;
        }
        this.openTable("section-constructors", "Constructors", 2, true);
        for (Map.Entry<String, Declaration> entry : this.constructors.entrySet()) {
            this.doc(entry.getKey(), entry.getValue());
        }
        this.closeTable();
    }

    private void writeAttributes() throws IOException {
        if (this.attributes.isEmpty()) {
            return;
        }
        this.openTable(null, "Attributes", 2, true);
        for (Map.Entry<String, TypedDeclaration> entry : this.attributes.entrySet()) {
            this.doc(entry.getKey(), entry.getValue());
        }
        this.closeTable();
    }

    private void writeMethods() throws IOException {
        if (this.methods.isEmpty()) {
            return;
        }
        this.openTable(null, "Methods", 2, true);
        for (Map.Entry<String, SortedSet<Function>> entry : this.methods.entrySet()) {
            int index = 1;
            for (Function f : entry.getValue()) {
                String id = null;
                if (index > 1) {
                    id = entry.getKey() + "_" + index;
                }
                this.doc(id, entry.getKey(), f);
                ++index;
            }
        }
        this.closeTable();
    }

    @Override
    protected void registerAdditionalKeyboardShortcuts() throws IOException {
        this.registerKeyboardShortcut('p', "index.html");
        if (this.hasAnyAttributes()) {
            this.registerKeyboardShortcut('a', "#section-attributes");
        }
        if (this.hasInitializer()) {
            this.registerKeyboardShortcut('z', "#section-initializer");
        }
        if (!this.constructors.isEmpty()) {
            this.registerKeyboardShortcut('t', "#section-constructors");
        }
        if (this.hasAnyMethods()) {
            this.registerKeyboardShortcut('m', "#section-methods");
        }
        if (!this.innerAliases.isEmpty()) {
            this.registerKeyboardShortcut('l', "#section-nested-aliases");
        }
        if (!this.innerInterfaces.isEmpty()) {
            this.registerKeyboardShortcut('i', "#section-nested-interfaces");
        }
        if (!this.innerClasses.isEmpty()) {
            this.registerKeyboardShortcut('c', "#section-nested-classes");
        }
        if (!this.innerExceptions.isEmpty()) {
            this.registerKeyboardShortcut('e', "#section-nested-exceptions");
        }
    }

    @Override
    protected Object getFromObject() {
        return this.klass;
    }

    private static interface MemberSpecification {
        public boolean isSatisfiedBy(Declaration var1);
    }
}

