/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.loader.impl.reflect.CachedTOCJars;
import com.redhat.ceylon.model.typechecker.model.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

class ModulesClassLoader
extends ClassLoader {
    private CachedTOCJars jars = new CachedTOCJars();

    public ModulesClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        byte[] contents = this.jars.getContents(path);
        if (contents != null) {
            return this.defineClass(name, contents, 0, contents.length);
        }
        return super.findClass(name);
    }

    public void addJar(ArtifactResult artifact, Module module, boolean skipContents) {
        this.jars.addJar(artifact, module, skipContents);
    }

    public boolean packageExists(Module module, String name) {
        String moduleName = module.getNameAsString();
        if (JDKUtils.isJDKModule(moduleName)) {
            return JDKUtils.isJDKPackage(moduleName, name);
        }
        if (JDKUtils.isOracleJDKModule(moduleName)) {
            return JDKUtils.isOracleJDKPackage(moduleName, name);
        }
        return this.jars.packageExists(module, name);
    }

    public List<String> getPackageList(Module module, String name) {
        String moduleName = module.getNameAsString();
        if (JDKUtils.isJDKModule(moduleName) || JDKUtils.isOracleJDKModule(moduleName)) {
            return this.getJDKPackageList(name);
        }
        return this.jars.getPackageList(module, name);
    }

    private List<String> getJDKPackageList(String name) {
        File rtJar = this.findRtJar("sun.boot.class.path");
        if (rtJar == null) {
            rtJar = this.findRtJar("java.class.path");
        }
        if (rtJar == null) {
            return Collections.emptyList();
        }
        String path = name.replace('.', '/') + "/";
        LinkedList<String> ret = new LinkedList<String>();
        try (JarInputStream is = new JarInputStream(new FileInputStream(rtJar));){
            JarEntry entry;
            while ((entry = is.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || !entryName.startsWith(path)) continue;
                ret.add(entryName);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to load rt.jar", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load rt.jar", e);
        }
        return ret;
    }

    private File findRtJar(String property) {
        String path = System.getProperty(property);
        if (path == null) {
            return null;
        }
        for (String entry : path.split(File.pathSeparator)) {
            File file = new File(entry);
            if (!file.exists() || !file.isFile() || !file.getName().toLowerCase().equals("rt.jar")) continue;
            return file;
        }
        return null;
    }
}

