/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactCallback;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ArtifactCallbackStream
extends FilterInputStream {
    private static final ThreadLocal<ArtifactCallback> TL = new ThreadLocal();
    private ArtifactCallback callback;

    public static void setCallback(ArtifactCallback callback) {
        if (callback != null) {
            TL.set(callback);
        } else {
            TL.remove();
        }
    }

    public static ArtifactCallback getCallback() {
        return TL.get();
    }

    public ArtifactCallbackStream(ArtifactCallback callback, InputStream in) {
        super(in);
        this.callback = callback;
    }

    @Override
    public int read() throws IOException {
        return this.read(new byte[1]);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        this.callback.read(b, read == -1 ? 0 : read);
        return read;
    }
}

