/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactCallback;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;

public class ArtifactContext
implements Serializable,
ContentOptions {
    public static final String CAR = ".car";
    public static final String JAR = ".jar";
    public static final String JS_MODEL = "-model.js";
    public static final String JS = ".js";
    public static final String DART = ".dart";
    public static final String DART_MODEL = "-dartmodel.json";
    public static final String RESOURCES = "module-resources";
    public static final String SRC = ".src";
    public static final String LEGACY_SRC = "-sources.jar";
    public static final String DOCS = "module-doc";
    public static final String MODULE_PROPERTIES = "module.properties";
    public static final String MODULE_XML = "module.xml";
    public static final String SHA1 = ".sha1";
    public static final String INFO = ".info";
    public static final String SCRIPTS_ZIPPED = ".scripts.zip";
    public static final String ZIP = ".zip";
    private static final String[] fileSuffixes = new String[]{".car", ".jar", "-model.js", ".js", ".dart", "-dartmodel.json", "module-resources", ".src", "-sources.jar", "module-doc", ".scripts.zip"};
    private static final String[] composedSuffixes = new String[]{".zip", ".sha1"};
    private static final String[] fileNames = new String[]{"module.properties", "module.xml"};
    private static final String[] directoryNames = new String[]{"module-resources", "module-doc"};
    private String name;
    private String version;
    private String[] suffixes = new String[]{".car"};
    private boolean localOnly;
    private boolean ignoreSHA;
    private boolean ignoreCache;
    private boolean throwErrorIfMissing;
    private boolean forceOperation;
    private boolean forceDescriptorCheck;
    private boolean ignoreDependencies;
    private ArtifactCallback callback;
    private Repository repository;

    public static final String[] allSuffixes() {
        ArrayList<String> all = new ArrayList<String>(fileSuffixes.length + fileNames.length + directoryNames.length);
        all.addAll(Arrays.asList(fileSuffixes));
        all.addAll(Arrays.asList(fileNames));
        all.addAll(Arrays.asList(directoryNames));
        String[] tmp = new String[all.size()];
        return all.toArray(tmp);
    }

    public ArtifactContext(String name, String version2) {
        this.name = name;
        this.version = version2;
    }

    public ArtifactContext(String name, String version2, String ... suffixes) {
        this(name, version2);
        this.suffixes = suffixes;
    }

    private ArtifactContext(String name, String version2, Repository repository, String ... suffixes) {
        this(name, version2);
        this.suffixes = suffixes;
        this.repository = repository;
    }

    public ArtifactContext() {
    }

    private static boolean isShaAllowed(String suffix) {
        return !MODULE_PROPERTIES.equals(suffix) && !MODULE_XML.equals(suffix) && !suffix.endsWith(SHA1) && !ArtifactContext.isDirectoryName(suffix);
    }

    public ArtifactContext getSha1Context() {
        if (this.suffixes.length == 1 && ArtifactContext.isShaAllowed(this.suffixes[0])) {
            String[] sha1Suffixes = new String[]{this.suffixes[0] + SHA1};
            return new ArtifactContext(this.name, this.version, sha1Suffixes);
        }
        return null;
    }

    public ArtifactContext getZipContext() {
        if (this.suffixes.length == 1 && !this.suffixes[0].endsWith(ZIP) && ArtifactContext.isDirectoryName(this.suffixes[0])) {
            String[] sha1Suffixes = new String[]{this.suffixes[0] + ZIP};
            return new ArtifactContext(this.name, this.version, sha1Suffixes);
        }
        return null;
    }

    public ArtifactContext getSuffixContext(String ... suffixes) {
        ArtifactContext ac = this.copy();
        ac.setSuffixes(suffixes);
        return ac;
    }

    public ArtifactContext getDocsContext() {
        return this.getSuffixContext(DOCS);
    }

    public ArtifactContext getResourcesContext() {
        return this.getSuffixContext(RESOURCES);
    }

    public ArtifactContext getModuleProperties() {
        return this.getSuffixContext(MODULE_PROPERTIES);
    }

    public ArtifactContext getModuleXml() {
        return this.getSuffixContext(MODULE_XML);
    }

    public ArtifactContext getSibling(ArtifactResult result, String ... suffixes) {
        ArtifactContext sibling = new ArtifactContext(result.name(), result.version(), result.repository(), suffixes);
        sibling.copySettingsFrom(this);
        return sibling;
    }

    public void toNode(Node node) {
        if (node instanceof OpenNode) {
            OpenNode on = (OpenNode)node;
            on.addNode(INFO, this);
        }
    }

    public static ArtifactContext fromNode(Node node) {
        Node ac = node instanceof OpenNode ? ((OpenNode)node).peekChild(INFO) : node.getChild(INFO);
        return ac != null ? ac.getValue(ArtifactContext.class) : null;
    }

    public static void removeNode(Node node) {
        OpenNode on;
        if (node instanceof OpenNode && (on = (OpenNode)node).peekChild(INFO) != null) {
            on.removeNode(INFO);
        }
    }

    public boolean isMaven() {
        return this.name != null && (this.name.startsWith("maven:") || this.name.indexOf(58) != -1);
    }

    public String getName() {
        if (this.name != null && this.name.startsWith("maven:")) {
            return this.name.substring("maven:".length());
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        this.version = version2;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(String ... suffixes) {
        this.suffixes = suffixes;
    }

    public String getSingleSuffix() {
        if (this.suffixes.length != 1) {
            throw new RepositoryException("ArtifactContext should have a single suffix");
        }
        return this.suffixes[0];
    }

    public static String getSuffixFromNode(Node node) {
        String fileName = node.getLabel();
        return ArtifactContext.getSuffixFromFilename(fileName);
    }

    public static String getSuffixFromFilename(String fileName) {
        String suffix = ArtifactContext.getSuffixFromFilename_(fileName);
        if (SHA1.equals(suffix)) {
            return (fileName = fileName.substring(0, fileName.length() - 5)).isEmpty() ? SHA1 : ArtifactContext.getSuffixFromFilename(fileName) + SHA1;
        }
        if (ZIP.equals(suffix)) {
            return (fileName = fileName.substring(0, fileName.length() - 4)).isEmpty() ? ZIP : ArtifactContext.getSuffixFromFilename(fileName) + ZIP;
        }
        return suffix;
    }

    private static String getSuffixFromFilename_(String fileName) {
        for (String suffix : fileNames) {
            if (!fileName.equals(suffix)) continue;
            return suffix;
        }
        for (String suffix : directoryNames) {
            if (!fileName.equals(suffix)) continue;
            return suffix;
        }
        for (String suffix : fileSuffixes) {
            if (!fileName.endsWith(suffix)) continue;
            return suffix;
        }
        for (String suffix : composedSuffixes) {
            if (!fileName.endsWith(suffix)) continue;
            return suffix;
        }
        throw new RepositoryException("Unknown suffix in " + fileName);
    }

    public static String getArtifactName(String name, String version2, String suffix) {
        if (suffix.endsWith(SHA1)) {
            return ArtifactContext.getArtifactName(name, version2, suffix.substring(0, suffix.length() - 5)) + SHA1;
        }
        if (ArtifactContext.isDirectoryName(suffix) || ArtifactContext.isFullName(suffix)) {
            return suffix;
        }
        if ("default".equals(name)) {
            return name + suffix;
        }
        return name + "-" + version2 + suffix;
    }

    public static boolean isDirectoryName(String fileName) {
        for (String suffix : directoryNames) {
            if (!fileName.equals(suffix)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFullName(String fileName) {
        for (String suffix : fileNames) {
            if (!fileName.equals(suffix)) continue;
            return true;
        }
        for (String suffix : directoryNames) {
            if (!fileName.equals(suffix + ZIP) && !fileName.equals(suffix + ZIP + SHA1)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public void setLocalOnly(boolean localOnly) {
        this.localOnly = localOnly;
    }

    public boolean isIgnoreSHA() {
        return this.ignoreSHA;
    }

    public void setIgnoreSHA(boolean ignoreSHA) {
        this.ignoreSHA = ignoreSHA;
    }

    public boolean isIgnoreCache() {
        return this.ignoreCache;
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.ignoreCache = ignoreCache;
    }

    public boolean isThrowErrorIfMissing() {
        return this.throwErrorIfMissing;
    }

    public void setThrowErrorIfMissing(boolean throwErrorIfMissing) {
        this.throwErrorIfMissing = throwErrorIfMissing;
    }

    public boolean isForceOperation() {
        return this.forceOperation;
    }

    public void setForceOperation(boolean forceOperation) {
        this.forceOperation = forceOperation;
    }

    public boolean isForceDescriptorCheck() {
        return this.forceDescriptorCheck;
    }

    public void setForceDescriptorCheck(boolean forceDescriptorCheck) {
        this.forceDescriptorCheck = forceDescriptorCheck;
    }

    public boolean isIgnoreDependencies() {
        return this.ignoreDependencies;
    }

    public void setIgnoreDependencies(boolean ignoreDependencies) {
        this.ignoreDependencies = ignoreDependencies;
    }

    public ArtifactCallback getCallback() {
        return this.callback;
    }

    public void setCallback(ArtifactCallback callback) {
        this.callback = callback;
    }

    public Repository getSearchRepository() {
        return this.repository;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getName()).append("-").append(this.getVersion());
        if (this.suffixes.length == 1 && !ArtifactContext.isDirectoryName(this.suffixes[0]) && !ArtifactContext.isFullName(this.suffixes[0])) {
            str.append(this.suffixes[0]);
        } else {
            str.append("(");
            boolean first = true;
            for (String s : this.suffixes) {
                if (!first) {
                    str.append("|");
                }
                str.append(s);
                first = false;
            }
            str.append(")");
        }
        return str.toString();
    }

    @Override
    public boolean forceOperation() {
        return this.isForceOperation();
    }

    @Override
    public boolean forceDescriptorCheck() {
        return this.isForceDescriptorCheck();
    }

    public ArtifactContext copy() {
        ArtifactContext ac = new ArtifactContext(this.name, this.version, this.suffixes);
        ac.copySettingsFrom(this);
        ac.repository = this.repository;
        return ac;
    }

    public ArtifactContext copySettingsFrom(ArtifactContext ac) {
        this.localOnly = ac.localOnly;
        this.ignoreSHA = ac.ignoreSHA;
        this.ignoreCache = ac.ignoreCache;
        this.throwErrorIfMissing = ac.throwErrorIfMissing;
        this.forceOperation = ac.forceOperation;
        this.forceDescriptorCheck = ac.forceDescriptorCheck;
        this.ignoreDependencies = ac.ignoreDependencies;
        this.callback = ac.callback;
        return ac;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArtifactContext)) {
            return false;
        }
        ArtifactContext other = (ArtifactContext)obj;
        return Objects.equals(this.getName(), other.getName()) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
        hash = 37 * hash + (this.version != null ? this.version.hashCode() : 0);
        return hash;
    }
}

