/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyOverride;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ArtifactOverrides {
    private static final Logger log = Logger.getLogger(ArtifactOverrides.class.getName());
    private ArtifactContext owner;
    private Set<DependencyOverride> add = new HashSet<DependencyOverride>();
    private Set<DependencyOverride> remove = new HashSet<DependencyOverride>();
    private Map<String, Boolean> share = new HashMap<String, Boolean>();
    private Map<String, Boolean> optional = new HashMap<String, Boolean>();
    private DependencyOverride replace;
    private String filter;

    public ArtifactOverrides(ArtifactContext owner) {
        this.owner = owner;
    }

    public void addShareOverride(ArtifactContext context, boolean share) {
        this.share.put(context.getName(), share);
    }

    public void addOptionalOverride(ArtifactContext context, boolean optional) {
        this.optional.put(context.getName(), optional);
    }

    public boolean isShareOverridden(ArtifactContext context) {
        return this.share.containsKey(context.getName());
    }

    public boolean isShared(ArtifactContext context) {
        Boolean ret = this.share.get(context.getName());
        return ret != null && ret != false;
    }

    public boolean isOptionalOverridden(ArtifactContext context) {
        return this.optional.containsKey(context.getName());
    }

    public boolean isOptional(ArtifactContext context) {
        Boolean ret = this.optional.get(context.getName());
        return ret != null && ret != false;
    }

    public void addOverride(DependencyOverride override) {
        switch (override.getType()) {
            case ADD: {
                this.add.add(override);
                break;
            }
            case REMOVE: {
                this.remove.add(override);
                break;
            }
            case REPLACE: {
                if (this.replace != null) {
                    log.warning(String.format("Replace for %s is already defined: %s, current: %s", this.owner, this.replace.getArtifactContext(), override.getArtifactContext()));
                }
                this.replace = override;
            }
        }
    }

    public ArtifactContext getOwner() {
        return this.owner;
    }

    public Set<DependencyOverride> getAdd() {
        return this.add;
    }

    public boolean isRemoved(ArtifactContext mc) {
        for (DependencyOverride override : this.remove) {
            if (!override.matches(mc)) continue;
            return true;
        }
        return false;
    }

    public boolean isAddedOrUpdated(ArtifactContext mc) {
        for (DependencyOverride override : this.add) {
            if (!override.matchesName(mc)) continue;
            return true;
        }
        return false;
    }

    public DependencyOverride getReplace() {
        return this.replace;
    }

    public String getFilter() {
        return this.filter;
    }

    void setFilter(String filter) {
        this.filter = filter;
    }
}

