/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import java.util.Comparator;

public class DebianVersionComparator
implements Comparator<String> {
    public static final DebianVersionComparator INSTANCE = new DebianVersionComparator();

    @Override
    public int compare(String a, String b) {
        return DebianVersionComparator.compareVersions(a, b);
    }

    public static int compareVersions(String versionAString, String versionBString) {
        char[] versionA = versionAString.toCharArray();
        char[] versionB = versionBString.toCharArray();
        int aStart = 0;
        int aEnd = 0;
        int bStart = 0;
        int bEnd = 0;
        while (true) {
            if (aEnd < versionA.length && !Character.isDigit(versionA[aEnd])) {
                ++aEnd;
                continue;
            }
            while (bEnd < versionB.length && !Character.isDigit(versionB[bEnd])) {
                ++bEnd;
            }
            int compare = DebianVersionComparator.compare(versionA, aStart, aEnd, versionB, bStart, bEnd);
            if (compare != 0) {
                return compare;
            }
            if (aEnd == versionA.length && bEnd == versionB.length) {
                return 0;
            }
            if (aEnd == versionA.length) {
                return -1;
            }
            if (bEnd == versionB.length) {
                return 1;
            }
            int a = 0;
            int b = 0;
            while (aEnd < versionA.length && Character.isDigit(versionA[aEnd])) {
                a = a * 10 + (versionA[aEnd] - 48);
                ++aEnd;
            }
            while (bEnd < versionB.length && Character.isDigit(versionB[bEnd])) {
                b = b * 10 + (versionB[bEnd] - 48);
                ++bEnd;
            }
            compare = Integer.compare(a, b);
            if (compare != 0) {
                return compare;
            }
            if (aEnd == versionA.length && bEnd == versionB.length) {
                return 0;
            }
            if (aEnd == versionA.length) {
                return -1;
            }
            if (bEnd == versionB.length) break;
        }
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int compare(char[] a, int aStart, int aEnd, char[] b, int bStart, int bEnd) {
        while (aStart < aEnd && bStart < bEnd) {
            int ret;
            char aChar = a[aStart];
            char bChar = b[bStart];
            if (Character.isAlphabetic(aChar)) {
                if (!Character.isAlphabetic(bChar)) return -1;
                ret = Character.compare(aChar, bChar);
                if (ret != 0) {
                    return ret;
                }
            } else {
                if (Character.isAlphabetic(bChar)) {
                    return 1;
                }
                ret = Character.compare(aChar, bChar);
                if (ret != 0) {
                    return ret;
                }
            }
            ++aStart;
            ++bStart;
        }
        if (aStart == aEnd && bStart == bEnd) {
            return 0;
        }
        if (aStart != aEnd) return 1;
        return -1;
    }

    public static String[] orderVersions(String versionA, String versionB) {
        if (DebianVersionComparator.compareVersions(versionA, versionB) > 0) {
            String permute = versionA;
            versionA = versionB;
            versionB = permute;
        }
        return new String[]{versionA, versionB};
    }
}

