/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.DependencyResolver;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DependencyResolvers {
    private final List<DependencyResolver> resolvers = new CopyOnWriteArrayList<DependencyResolver>();

    public void addResolver(DependencyResolver resolver) {
        this.addResolver(resolver, this.resolvers.size());
    }

    public void addResolver(DependencyResolver resolver, int index) {
        this.resolvers.add(index, resolver);
    }

    public void removeResolver(DependencyResolver resolver) {
        this.resolvers.remove(resolver);
    }

    public ModuleInfo resolve(ArtifactResult result, Overrides overrides) {
        for (DependencyResolver dr : this.resolvers) {
            ModuleInfo info = dr.resolve(result, overrides);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    public Node descriptor(Node artifact) {
        for (DependencyResolver dr : this.resolvers) {
            Node descriptor = dr.descriptor(artifact);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public String toString() {
        return this.resolvers.toString();
    }
}

