/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import java.util.Comparator;

public class MavenVersionComparator
implements Comparator<String> {
    public static final MavenVersionComparator INSTANCE = new MavenVersionComparator();

    @Override
    public int compare(String a, String b) {
        return MavenVersionComparator.compareVersions(a, b);
    }

    public static int compareVersions(String versionAString, String versionBString) {
        char[] versionA = versionAString.toCharArray();
        char[] versionB = versionBString.toCharArray();
        int aStart = 0;
        int aEnd = 0;
        int bStart = 0;
        int bEnd = 0;
        int aLevel = 0;
        int bLevel = 0;
        while (aEnd != versionA.length || bEnd != versionB.length) {
            int compare;
            char c;
            boolean aString = false;
            boolean bString = false;
            boolean aNumber = false;
            boolean bNumber = false;
            long a = 0L;
            long b = 0L;
            while (aEnd < versionA.length && !MavenVersionComparator.isSeparator(versionA[aEnd])) {
                c = versionA[aEnd];
                if (!aString && !aNumber) {
                    if (Character.isDigit(c)) {
                        aNumber = true;
                        a = versionA[aEnd] - 48;
                    } else {
                        aString = true;
                    }
                } else if (aNumber) {
                    if (!Character.isDigit(c)) break;
                    a = a * 10L + (long)(versionA[aEnd] - 48);
                } else if (aString && Character.isDigit(c)) break;
                ++aEnd;
            }
            while (bEnd < versionB.length && !MavenVersionComparator.isSeparator(versionB[bEnd])) {
                c = versionB[bEnd];
                if (!bString && !bNumber) {
                    if (Character.isDigit(c)) {
                        bNumber = true;
                        b = versionB[bEnd] - 48;
                    } else {
                        bString = true;
                    }
                } else if (bNumber) {
                    if (!Character.isDigit(c)) break;
                    b = b * 10L + (long)(versionB[bEnd] - 48);
                } else if (bString && Character.isDigit(c)) break;
                ++bEnd;
            }
            if ((compare = MavenVersionComparator.compare(versionA, aStart, aEnd, aNumber, aString, a, aLevel, versionB, bStart, bEnd, bNumber, bString, b, bLevel)) != 0) {
                return compare;
            }
            if (aEnd < versionA.length && versionA[aEnd] == '-') {
                ++aLevel;
            }
            if (bEnd < versionB.length && versionB[bEnd] == '-') {
                ++bLevel;
            }
            if (aEnd < versionA.length && MavenVersionComparator.isSeparator(versionA[aEnd])) {
                ++aEnd;
            }
            if (bEnd >= versionB.length || MavenVersionComparator.isSeparator(versionB[bEnd])) {
                // empty if block
            }
            aStart = aEnd;
            bStart = ++bEnd;
        }
        return 0;
    }

    private static boolean isSeparator(char c) {
        return c == '.' || c == '-';
    }

    private static int compare(char[] a, int aStart, int aEnd, boolean aNumber, boolean aString, long aValue, int aLevel, char[] b, int bStart, int bEnd, boolean bNumber, boolean bString, long bValue, int bLevel) {
        if (aLevel > bLevel) {
            if (bNumber) {
                return -1;
            }
            if (bString) {
                return 1;
            }
        } else if (aLevel < bLevel) {
            if (aNumber) {
                return 1;
            }
            if (aString) {
                return -1;
            }
        }
        if (aNumber) {
            if (bNumber) {
                return Long.compare(aValue, bValue);
            }
            if (bString) {
                return 1;
            }
            if (aValue == 0L) {
                return 0;
            }
            return 1;
        }
        if (aString) {
            if (bNumber) {
                return -1;
            }
            return MavenVersionComparator.compareStrings(a, aStart, aEnd, b, bStart, bEnd);
        }
        if (bNumber) {
            if (bValue == 0L) {
                return 0;
            }
            return -1;
        }
        if (bString) {
            return MavenVersionComparator.compareStrings(a, aStart, aEnd, b, bStart, bEnd);
        }
        return 0;
    }

    private static int compareStrings(char[] a, int aStart, int aEnd, char[] b, int bStart, int bEnd) {
        int specialWeightA = MavenVersionComparator.getSpecialWeight(a, aStart, aEnd);
        int specialWeightB = MavenVersionComparator.getSpecialWeight(b, bStart, bEnd);
        if (specialWeightA >= 0) {
            if (specialWeightB >= 0) {
                return Integer.compare(specialWeightA, specialWeightB);
            }
            return -1;
        }
        if (specialWeightB >= 0) {
            return 1;
        }
        while (aStart < aEnd && bStart < bEnd) {
            char aChar = a[aStart];
            char bChar = b[bStart];
            int ret = Character.compare(aChar, bChar);
            if (ret != 0) {
                return ret;
            }
            ++aStart;
            ++bStart;
        }
        if (aStart == aEnd && bStart == bEnd) {
            return 0;
        }
        if (aStart == aEnd) {
            return -1;
        }
        return 1;
    }

    private static int getSpecialWeight(char[] chars, int start, int end) {
        if (start == end) {
            return 5;
        }
        if (MavenVersionComparator.equalsIgnoreCase("alpha", chars, start, end) || MavenVersionComparator.equalsIgnoreCase("a", chars, start, end)) {
            return 0;
        }
        if (MavenVersionComparator.equalsIgnoreCase("beta", chars, start, end) || MavenVersionComparator.equalsIgnoreCase("b", chars, start, end)) {
            return 1;
        }
        if (MavenVersionComparator.equalsIgnoreCase("milestone", chars, start, end) || MavenVersionComparator.equalsIgnoreCase("m", chars, start, end)) {
            return 2;
        }
        if (MavenVersionComparator.equalsIgnoreCase("cr", chars, start, end) || MavenVersionComparator.equalsIgnoreCase("rc", chars, start, end)) {
            return 3;
        }
        if (MavenVersionComparator.equalsIgnoreCase("snapshot", chars, start, end)) {
            return 4;
        }
        if (MavenVersionComparator.equalsIgnoreCase("ga", chars, start, end) || MavenVersionComparator.equalsIgnoreCase("final", chars, start, end)) {
            return 5;
        }
        if (MavenVersionComparator.equalsIgnoreCase("sp", chars, start, end)) {
            return 6;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(String string, char[] chars, int start, int end) {
        if (end - start != string.length()) {
            return false;
        }
        int i = 0;
        while (start < end) {
            char aChar = chars[start];
            char bChar = string.charAt(i);
            int ret = Character.compare(Character.toLowerCase(aChar), Character.toLowerCase(bChar));
            if (ret != 0) {
                return false;
            }
            ++start;
            ++i;
        }
        return true;
    }

    public static String[] orderVersions(String versionA, String versionB) {
        if (MavenVersionComparator.compareVersions(versionA, versionB) > 0) {
            String permute = versionA;
            versionA = versionB;
            versionB = permute;
        }
        return new String[]{versionA, versionB};
    }
}

