/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

public final class ModuleDependencyInfo
implements Comparable<ModuleDependencyInfo> {
    private String name;
    private String version;
    private boolean optional;
    private boolean shared;

    public ModuleDependencyInfo(String name, String version2, boolean optional, boolean shared) {
        this.name = name;
        this.version = version2;
        this.optional = optional;
        this.shared = shared;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isExport() {
        return this.shared;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependencyInfo that = (ModuleDependencyInfo)o;
        return that.name.equals(this.name) && that.version.equals(this.version) && that.shared == this.shared && that.optional == this.optional;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(ModuleDependencyInfo that) {
        int res = this.name.compareTo(that.name);
        if (res == 0 && (res = this.version.compareTo(that.version)) == 0 && (res = Boolean.compare(this.shared, that.shared)) == 0) {
            res = Boolean.compare(this.optional, that.optional);
        }
        return res;
    }

    public String toString() {
        return (this.shared ? "shared " : "") + (this.optional ? "optional " : "") + this.getModuleName();
    }

    public String getModuleName() {
        return this.name + "/" + this.version;
    }
}

