/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import java.util.Arrays;

public class ModuleQuery {
    protected String name;
    protected Type type;
    protected Retrieval retrieval;
    private Long start;
    private Long count;
    private long[] pagingInfo;
    private Integer jvmBinaryMajor;
    private Integer jvmBinaryMinor;
    private Integer jsBinaryMajor;
    private Integer jsBinaryMinor;
    private String memberName;
    private boolean memberSearchPackageOnly;
    private boolean memberSearchExact;

    public ModuleQuery(String name, Type type) {
        this(name, type, Retrieval.ANY);
    }

    public ModuleQuery(String name, Type type, Retrieval retrieval) {
        this.name = name;
        this.type = type;
        this.retrieval = retrieval;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Retrieval getRetrieval() {
        return this.retrieval;
    }

    public void setRetrieval(Retrieval retrieval) {
        this.retrieval = retrieval;
    }

    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public boolean isPaging() {
        return this.count != null || this.start != null;
    }

    public void setPagingInfo(long[] pagingInfo) {
        this.pagingInfo = pagingInfo;
    }

    public long[] getPagingInfo() {
        return this.pagingInfo;
    }

    public Integer getJvmBinaryMajor() {
        return this.jvmBinaryMajor;
    }

    public void setJvmBinaryMajor(Integer binaryMajor) {
        this.jvmBinaryMajor = binaryMajor;
    }

    public Integer getJvmBinaryMinor() {
        return this.jvmBinaryMinor;
    }

    public void setJvmBinaryMinor(Integer binaryMinor) {
        this.jvmBinaryMinor = binaryMinor;
    }

    public Integer getJsBinaryMajor() {
        return this.jsBinaryMajor;
    }

    public void setJsBinaryMajor(Integer binaryMajor) {
        this.jsBinaryMajor = binaryMajor;
    }

    public Integer getJsBinaryMinor() {
        return this.jsBinaryMinor;
    }

    public void setJsBinaryMinor(Integer binaryMinor) {
        this.jsBinaryMinor = binaryMinor;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public boolean isMemberSearchPackageOnly() {
        return this.memberSearchPackageOnly;
    }

    public void setMemberSearchPackageOnly(boolean memberSearchPackageOnly) {
        this.memberSearchPackageOnly = memberSearchPackageOnly;
    }

    public boolean isMemberSearchExact() {
        return this.memberSearchExact;
    }

    public void setMemberSearchExact(boolean memberSearchExact) {
        this.memberSearchExact = memberSearchExact;
    }

    public String toString() {
        return "ModuleQuery[name=" + this.name + ",type=" + (Object)((Object)this.type) + "]";
    }

    public static enum Retrieval {
        ANY,
        ALL;

    }

    public static enum Type {
        SRC(".src"),
        CAR(".car"),
        JAR(".jar"),
        JVM(".car", ".jar"),
        JS(".js"),
        DART(".dart"),
        CODE(".car", ".jar", ".js"),
        CEYLON_CODE(".car", ".js"),
        ALL(ArtifactContext.allSuffixes());

        private String[] suffixes;

        private Type(String ... suffixes) {
            this.suffixes = suffixes;
        }

        public String[] getSuffixes() {
            return this.suffixes;
        }

        public boolean includes(String ... suffs) {
            return Arrays.asList(this.suffixes).containsAll(Arrays.asList(suffs));
        }
    }
}

