/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.VersionComparator;
import java.util.Arrays;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class ModuleVersionDetails
implements Comparable<ModuleVersionDetails> {
    private String module;
    private String version;
    private String doc;
    private String license;
    private boolean remote;
    private String origin;
    private NavigableSet<String> authors = new TreeSet<String>();
    private NavigableSet<ModuleDependencyInfo> dependencies = new TreeSet<ModuleDependencyInfo>();
    private NavigableSet<ModuleVersionArtifact> artifactTypes = new TreeSet<ModuleVersionArtifact>();
    private NavigableSet<String> members = new TreeSet<String>();

    public ModuleVersionDetails(String module, String version2) {
        assert (version2 != null);
        this.module = module;
        this.version = version2;
    }

    public ModuleVersionDetails(String module, String version2, String doc, String license, String ... by) {
        this(module, version2);
        this.doc = doc;
        this.license = license;
        this.authors.addAll(Arrays.asList(by));
    }

    public ModuleVersionDetails(String module, String version2, String doc, String license, Set<String> authors, Set<ModuleDependencyInfo> dependencies, Set<ModuleVersionArtifact> artifactTypes, boolean remote, String origin) {
        this(module, version2);
        this.doc = doc;
        this.license = license;
        this.authors.addAll(authors);
        this.dependencies.addAll(dependencies);
        this.artifactTypes.addAll(artifactTypes);
        this.remote = remote;
        this.origin = origin;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version2) {
        assert (version2 != null);
        this.version = version2;
    }

    public String getDoc() {
        return this.doc;
    }

    public void setDoc(String doc) {
        this.doc = doc;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public NavigableSet<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(SortedSet<String> authors) {
        this.authors.clear();
        this.authors.addAll(authors);
    }

    public NavigableSet<ModuleDependencyInfo> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(SortedSet<ModuleDependencyInfo> dependencies) {
        this.dependencies.clear();
        this.dependencies.addAll(dependencies);
    }

    public NavigableSet<ModuleVersionArtifact> getArtifactTypes() {
        return this.artifactTypes;
    }

    public void setArtifactTypes(SortedSet<ModuleVersionArtifact> types) {
        this.artifactTypes.clear();
        this.artifactTypes.addAll(types);
    }

    public NavigableSet<String> getMembers() {
        return this.members;
    }

    public void setMembers(Set<String> members) {
        this.members.clear();
        this.members.addAll(members);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModuleVersionDetails) {
            return this.version.equals(((ModuleVersionDetails)obj).version);
        }
        return false;
    }

    @Override
    public int compareTo(ModuleVersionDetails o) {
        return VersionComparator.compareVersions(this.version, o.version);
    }

    public String toString() {
        return "ModuleVersionDetails[ " + this.module + "/" + this.version + ", doc: " + (this.doc != null ? (this.doc.length() > 10 ? this.doc.substring(0, 10) + "..." : this.doc) : null) + ", license: " + this.license + ", by: " + this.authors + ", deps: " + this.dependencies + ", artifacts: " + this.artifactTypes + ", remote: " + this.remote + ", origin: " + this.origin + "]";
    }
}

