/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.xml.MXParser;
import org.jboss.modules.xml.XmlPullParser;
import org.w3c.dom.Node;

public final class PathFilterParser {
    private static final Method parseFilterList;

    public static com.redhat.ceylon.model.cmr.PathFilter parse(String filter) throws IOException {
        if (filter.startsWith("<exports>") || filter.startsWith("<filter>")) {
            int end = filter.indexOf(62);
            filter = filter.substring(0, end) + " xmlns=\"urn:jboss:module:1.0\"" + filter.substring(end);
        }
        return PathFilterParser.parse(new ByteArrayInputStream(filter.getBytes()));
    }

    public static com.redhat.ceylon.model.cmr.PathFilter parse(InputStream inputStream) throws IOException {
        try {
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(inputStream, null);
            com.redhat.ceylon.model.cmr.PathFilter pathFilter = PathFilterParser.parseFilter(parser);
            return pathFilter;
        }
        catch (Exception e) {
            throw new IOException("Error parsing filter.", e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static com.redhat.ceylon.model.cmr.PathFilter parseFilter(XmlPullParser parser) throws Exception {
        parser.nextTag();
        MultiplePathFilterBuilder builder = PathFilters.multiplePathFilterBuilder(true);
        parseFilterList.invoke(null, parser, builder);
        return new ModulesPathFilter(builder.create());
    }

    public static String convertNodeToString(Node node) throws TransformerException {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter sw = new StringWriter();
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    static {
        try {
            Class<?> mxpClass = PathFilterParser.class.getClassLoader().loadClass("org.jboss.modules.ModuleXmlParser");
            parseFilterList = mxpClass.getDeclaredMethod("parseFilterList", XmlPullParser.class, MultiplePathFilterBuilder.class);
            parseFilterList.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ModulesPathFilter
    implements com.redhat.ceylon.model.cmr.PathFilter {
        private PathFilter filter;

        private ModulesPathFilter(PathFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean accept(String path) {
            return this.filter.accept(path);
        }
    }
}

