/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.PathFilterParser;
import com.redhat.ceylon.cmr.impl.JarUtils;
import com.redhat.ceylon.langtools.classfile.Annotation;
import com.redhat.ceylon.langtools.classfile.Attributes;
import com.redhat.ceylon.langtools.classfile.BootstrapMethods_attribute;
import com.redhat.ceylon.langtools.classfile.ClassFile;
import com.redhat.ceylon.langtools.classfile.Code_attribute;
import com.redhat.ceylon.langtools.classfile.ConstantPool;
import com.redhat.ceylon.langtools.classfile.ConstantPoolException;
import com.redhat.ceylon.langtools.classfile.Descriptor;
import com.redhat.ceylon.langtools.classfile.Field;
import com.redhat.ceylon.langtools.classfile.Instruction;
import com.redhat.ceylon.langtools.classfile.Method;
import com.redhat.ceylon.langtools.classfile.RuntimeVisibleAnnotations_attribute;
import com.redhat.ceylon.langtools.classfile.Signature;
import com.redhat.ceylon.langtools.classfile.Signature_attribute;
import com.redhat.ceylon.langtools.classfile.Type;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.PathFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassFileScanner {
    private File jarFile;
    private boolean isPublicApi;
    private boolean ignoreAnnotations;
    private Set<String> jarClassNames;
    Set<String> externalClasses;
    Set<String> publicApiExternalClasses;
    private Type.Visitor<Object, Object> typeVisitor = new Type.Visitor<Object, Object>(){

        @Override
        public Object visitSimpleType(Type.SimpleType type, Object p) {
            return null;
        }

        @Override
        public Object visitArrayType(Type.ArrayType type, Object p) {
            if (type.elemType != null) {
                type.elemType.accept(this, p);
            }
            return null;
        }

        @Override
        public Object visitMethodType(Type.MethodType type, Object p) {
            if (type.returnType != null) {
                type.returnType.accept(this, p);
            }
            if (type.paramTypes != null) {
                for (Type type2 : type.paramTypes) {
                    type2.accept(this, p);
                }
            }
            if (type.typeParamTypes != null) {
                for (Type type3 : type.typeParamTypes) {
                    type3.accept(this, p);
                }
            }
            return null;
        }

        @Override
        public Object visitClassSigType(Type.ClassSigType type, Object p) {
            if (type.superclassType != null) {
                type.superclassType.accept(this, p);
            }
            if (type.superinterfaceTypes != null) {
                for (Type interf : type.superinterfaceTypes) {
                    interf.accept(this, p);
                }
            }
            if (type.typeParamTypes != null) {
                for (Type.TypeParamType typeParam : type.typeParamTypes) {
                    typeParam.accept(this, p);
                }
            }
            return null;
        }

        @Override
        public Object visitClassType(Type.ClassType type, Object p) {
            if (type.outerType != null) {
                type.outerType.accept(this, p);
            }
            if (type.typeArgs != null) {
                for (Type typeArg : type.typeArgs) {
                    typeArg.accept(this, p);
                }
            }
            ClassFileScanner.this.recordBinaryName(type.getBinaryName());
            return null;
        }

        @Override
        public Object visitTypeParamType(Type.TypeParamType type, Object p) {
            if (type.classBound != null) {
                type.classBound.accept(this, p);
            }
            if (type.interfaceBounds != null) {
                for (Type bound : type.interfaceBounds) {
                    bound.accept(this, p);
                }
            }
            return null;
        }

        @Override
        public Object visitWildcardType(Type.WildcardType type, Object p) {
            if (type.boundType != null) {
                type.boundType.accept(this, p);
            }
            return null;
        }
    };
    private Annotation.element_value.Visitor<Object, ConstantPool> annotationVisitor = new Annotation.element_value.Visitor<Object, ConstantPool>(){

        @Override
        public Object visitPrimitive(Annotation.Primitive_element_value ev, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitEnum(Annotation.Enum_element_value ev, ConstantPool p) {
            try {
                String signature = p.getUTF8Value(ev.type_name_index);
                ClassFileScanner.this.recordFieldSignature(signature);
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitClass(Annotation.Class_element_value ev, ConstantPool p) {
            try {
                String signature = p.getUTF8Value(ev.class_info_index);
                ClassFileScanner.this.recordFieldSignature(signature);
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitAnnotation(Annotation.Annotation_element_value ev, ConstantPool p) {
            if (ev.annotation_value != null) {
                ClassFileScanner.this.visitAnnotation(ev.annotation_value, p);
            }
            return null;
        }

        @Override
        public Object visitArray(Annotation.Array_element_value ev, ConstantPool p) {
            if (ev.values != null) {
                for (Annotation.element_value val : ev.values) {
                    val.accept(this, p);
                }
            }
            return null;
        }
    };
    protected ConstantPool.Visitor<Object, ConstantPool> constantPoolVisitor = new ConstantPool.Visitor<Object, ConstantPool>(){

        @Override
        public Object visitClass(ConstantPool.CONSTANT_Class_info info, ConstantPool p) {
            try {
                ClassFileScanner.this.recordBinaryName(info.getName());
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitDouble(ConstantPool.CONSTANT_Double_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitFieldref(ConstantPool.CONSTANT_Fieldref_info info, ConstantPool p) {
            try {
                p.get(info.class_index).accept(this, p);
                p.get(info.name_and_type_index).accept(this, p);
            }
            catch (ConstantPool.InvalidIndex e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitFloat(ConstantPool.CONSTANT_Float_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitInteger(ConstantPool.CONSTANT_Integer_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitInterfaceMethodref(ConstantPool.CONSTANT_InterfaceMethodref_info info, ConstantPool p) {
            try {
                p.get(info.class_index).accept(this, p);
                p.get(info.name_and_type_index).accept(this, p);
            }
            catch (ConstantPool.InvalidIndex e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitInvokeDynamic(ConstantPool.CONSTANT_InvokeDynamic_info info, ConstantPool p) {
            try {
                p.get(info.name_and_type_index).accept(this, p);
            }
            catch (ConstantPool.InvalidIndex e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitLong(ConstantPool.CONSTANT_Long_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitNameAndType(ConstantPool.CONSTANT_NameAndType_info info, ConstantPool p) {
            try {
                String signature = info.getType();
                if (signature.startsWith("(")) {
                    ClassFileScanner.this.recordMethodSignature(signature);
                } else {
                    ClassFileScanner.this.recordFieldSignature(signature);
                }
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitMethodref(ConstantPool.CONSTANT_Methodref_info info, ConstantPool p) {
            try {
                p.get(info.class_index).accept(this, p);
                p.get(info.name_and_type_index).accept(this, p);
            }
            catch (ConstantPool.InvalidIndex e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitMethodHandle(ConstantPool.CONSTANT_MethodHandle_info info, ConstantPool p) {
            try {
                info.getCPRefInfo().accept(this, p);
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitMethodType(ConstantPool.CONSTANT_MethodType_info info, ConstantPool p) {
            try {
                String signature = info.getType();
                ClassFileScanner.this.recordMethodSignature(signature);
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
            return null;
        }

        @Override
        public Object visitString(ConstantPool.CONSTANT_String_info info, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitUtf8(ConstantPool.CONSTANT_Utf8_info info, ConstantPool p) {
            return null;
        }
    };
    private Instruction.KindVisitor<Object, ConstantPool> codeVisitor = new Instruction.KindVisitor<Object, ConstantPool>(){

        @Override
        public Object visitNoOperands(Instruction instr, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitArrayType(Instruction instr, Instruction.TypeKind kind, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitBranch(Instruction instr, int offset, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitConstantPoolRef(Instruction instr, int index, ConstantPool p) {
            this.visitConstantPoolRef(index, p);
            return null;
        }

        private void visitConstantPoolRef(int index, ConstantPool p) {
            try {
                ConstantPool.CPInfo entry = p.get(index);
                entry.accept(ClassFileScanner.this.constantPoolVisitor, p);
            }
            catch (ConstantPoolException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object visitConstantPoolRefAndValue(Instruction instr, int index, int value, ConstantPool p) {
            this.visitConstantPoolRef(index, p);
            return null;
        }

        @Override
        public Object visitLocal(Instruction instr, int index, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitLocalAndValue(Instruction instr, int index, int value, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitLookupSwitch(Instruction instr, int default_2, int npairs, int[] matches, int[] offsets, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitTableSwitch(Instruction instr, int default_2, int low, int high, int[] offsets, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitValue(Instruction instr, int value, ConstantPool p) {
            return null;
        }

        @Override
        public Object visitUnknown(Instruction instr, ConstantPool p) {
            return null;
        }
    };

    public ClassFileScanner(File jarFile, boolean ignoreAnnotations) throws IOException {
        this.externalClasses = new TreeSet<String>();
        this.publicApiExternalClasses = new TreeSet<String>();
        this.jarClassNames = JarUtils.gatherClassnamesFromJar(jarFile);
        this.jarFile = jarFile;
        this.ignoreAnnotations = ignoreAnnotations;
    }

    protected void recordFieldSignature(String signature) {
        String name = this.binaryNameToClassName(true, signature);
        this.recordTypeNameUsage(name);
    }

    protected void recordBinaryName(String binaryName) {
        String name = this.binaryNameToClassName(false, binaryName);
        this.recordTypeNameUsage(name);
    }

    private void recordTypeNameUsage(String name) {
        if (name != null && !this.jarClassNames.contains(name)) {
            if (name.startsWith("javax.inject")) {
                "".toString();
            }
            this.externalClasses.add(name);
            if (this.isPublicApi) {
                this.publicApiExternalClasses.add(name);
            }
        }
    }

    private void checkPublicApi(ClassFile classFile) throws ConstantPoolException, Descriptor.InvalidDescriptor {
        Type type;
        Object signature;
        boolean publicType;
        this.isPublicApi = publicType = classFile.access_flags.is(1);
        Signature_attribute signatureAttribute = (Signature_attribute)classFile.getAttribute("Signature");
        if (signatureAttribute != null) {
            Signature signature2 = signatureAttribute.getParsedSignature();
            Type type2 = signature2.getType(classFile.constant_pool);
            type2.accept(this.typeVisitor, null);
        } else {
            if (classFile.super_class != 0) {
                String binaryName = classFile.getSuperclassName();
                this.recordBinaryName(binaryName);
            }
            for (int i = 0; i < classFile.interfaces.length; ++i) {
                String binaryName = classFile.getInterfaceName(i);
                this.recordBinaryName(binaryName);
            }
        }
        this.visitAnnotations(classFile.attributes, classFile.constant_pool);
        for (Field field : classFile.fields) {
            this.isPublicApi = publicType && (field.access_flags.is(1) || field.access_flags.is(4));
            signatureAttribute = (Signature_attribute)field.attributes.get("Signature");
            if (signatureAttribute != null) {
                signature = signatureAttribute.getParsedSignature();
                type = ((Signature)signature).getType(classFile.constant_pool);
                type.accept(this.typeVisitor, null);
            } else {
                signature = field.descriptor.getValue(classFile.constant_pool);
                this.recordFieldSignature((String)signature);
            }
            this.visitAnnotations(field.attributes, classFile.constant_pool);
        }
        for (Method method : classFile.methods) {
            this.isPublicApi = publicType && (method.access_flags.is(1) || method.access_flags.is(4));
            signatureAttribute = (Signature_attribute)method.attributes.get("Signature");
            if (signatureAttribute != null) {
                signature = signatureAttribute.getParsedSignature();
                type = ((Signature)signature).getType(classFile.constant_pool);
                type.accept(this.typeVisitor, null);
            } else {
                signature = method.descriptor.getValue(classFile.constant_pool);
                this.recordMethodSignature((String)signature);
            }
            this.visitAnnotations(method.attributes, classFile.constant_pool);
            this.isPublicApi = false;
            this.visitCode(method.attributes, classFile.constant_pool);
        }
        this.isPublicApi = false;
        this.visitBootstrapMethods(classFile.attributes, classFile.constant_pool);
    }

    private void visitBootstrapMethods(Attributes attributes, ConstantPool constant_pool) throws ConstantPool.InvalidIndex {
        BootstrapMethods_attribute bootstrapMethods = (BootstrapMethods_attribute)attributes.get("BootstrapMethods");
        if (bootstrapMethods != null && bootstrapMethods.bootstrap_method_specifiers != null) {
            for (BootstrapMethods_attribute.BootstrapMethodSpecifier specifier : bootstrapMethods.bootstrap_method_specifiers) {
                constant_pool.get(specifier.bootstrap_method_ref).accept(this.constantPoolVisitor, constant_pool);
                if (specifier.bootstrap_arguments == null) continue;
                for (int arg : specifier.bootstrap_arguments) {
                    constant_pool.get(arg).accept(this.constantPoolVisitor, constant_pool);
                }
            }
        }
    }

    private void visitCode(Attributes attributes, ConstantPool constant_pool) {
        Code_attribute code = (Code_attribute)attributes.get("Code");
        if (code != null) {
            for (Instruction instr : code.getInstructions()) {
                instr.accept(this.codeVisitor, constant_pool);
            }
        }
    }

    private void visitAnnotations(Attributes attributes, ConstantPool constant_pool) throws ConstantPoolException {
        if (this.ignoreAnnotations) {
            return;
        }
        RuntimeVisibleAnnotations_attribute annotations = (RuntimeVisibleAnnotations_attribute)attributes.get("RuntimeVisibleAnnotations");
        if (annotations != null) {
            for (Annotation annotation : annotations.annotations) {
                this.visitAnnotation(annotation, constant_pool);
            }
        }
    }

    private void visitAnnotation(Annotation annotation, ConstantPool constant_pool) {
        String annotationTypeSignature;
        try {
            annotationTypeSignature = constant_pool.getUTF8Value(annotation.type_index);
        }
        catch (ConstantPool.InvalidIndex | ConstantPool.UnexpectedEntry e) {
            throw new RuntimeException(e);
        }
        this.recordFieldSignature(annotationTypeSignature);
        for (Annotation.element_value_pair elementValuePair : annotation.element_value_pairs) {
            elementValuePair.value.accept(this.annotationVisitor, constant_pool);
        }
    }

    private void recordMethodSignature(String signature) {
        int i = 0;
        block4: while (i < signature.length()) {
            switch (signature.charAt(i++)) {
                case '(': 
                case ')': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': 
                case '[': {
                    continue block4;
                }
                case 'L': {
                    int sep = signature.indexOf(59, i);
                    if (sep == -1) {
                        throw new RuntimeException("Invalid signature: " + signature);
                    }
                    this.recordBinaryName(signature.substring(i, sep));
                    i = sep + 1;
                    continue block4;
                }
            }
            throw new RuntimeException("Invalid signature: " + signature);
        }
    }

    private String binaryNameToClassName(boolean isSignature, String name) {
        while (name.startsWith("[")) {
            name = name.substring(1, name.length());
            isSignature = true;
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        } else if (isSignature) {
            if (name.equals("B") || name.equals("C") || name.equals("D") || name.equals("F") || name.equals("I") || name.equals("J") || name.equals("S") || name.equals("Z") || name.equals("V")) {
                return null;
            }
            throw new RuntimeException("Don't know how to handle binary type: " + name);
        }
        name = name.replace('/', '.');
        return name;
    }

    Usage removeMatchingClasses(Set<String> importedClasses) {
        boolean used = this.externalClasses.removeAll(importedClasses);
        boolean usedInPublicApi = this.publicApiExternalClasses.removeAll(importedClasses);
        return Usage.fromBooleans(used, usedInPublicApi);
    }

    Usage removeMatchingJdkClasses(String jdkModule) {
        Iterator<String> iterator = this.externalClasses.iterator();
        boolean used = false;
        boolean usedInPublicApi = false;
        while (iterator.hasNext()) {
            String className = iterator.next();
            String pkgName = this.getPackageFromClass(className);
            if (!JDKUtils.isJDKPackage(jdkModule, pkgName) && !JDKUtils.isOracleJDKPackage(jdkModule, pkgName)) continue;
            iterator.remove();
            used = true;
            usedInPublicApi |= this.publicApiExternalClasses.remove(className);
        }
        return Usage.fromBooleans(used, usedInPublicApi);
    }

    private Set<String> getPackagesFromClasses(Set<String> classes) {
        TreeSet<String> packages = new TreeSet<String>();
        for (String className : classes) {
            String pkg = this.getPackageFromClass(className);
            if (pkg.isEmpty()) continue;
            packages.add(pkg);
        }
        return packages;
    }

    private String getPackageFromClass(String className) {
        int p = className.lastIndexOf(46);
        if (p >= 0) {
            return className.substring(0, p);
        }
        return "";
    }

    private Set<String> getDefaultPackageClasses(Set<String> classes) {
        TreeSet<String> defclasses = new TreeSet<String>();
        for (String className : classes) {
            int p = className.lastIndexOf(46);
            if (p >= 0) continue;
            defclasses.add(className);
        }
        return defclasses;
    }

    Set<String> gatherJdkModules(Set<String> packages) {
        TreeSet<String> jdkModules = new TreeSet<String>();
        HashSet<String> newPackages = new HashSet<String>();
        for (String pkg : packages) {
            String mod = JDKUtils.getJDKModuleNameForPackage(pkg);
            if (mod != null) {
                jdkModules.add(mod);
                continue;
            }
            newPackages.add(pkg);
        }
        packages.clear();
        packages.addAll(newPackages);
        return jdkModules;
    }

    public void scan(ModuleInfo moduleInfo) throws IOException {
        PathFilter pathFilter = null;
        if (moduleInfo != null && moduleInfo.getFilter() != null) {
            pathFilter = PathFilterParser.parse(moduleInfo.getFilter());
        }
        try (ZipFile zf = new ZipFile(this.jarFile);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().toLowerCase().endsWith(".class") || pathFilter != null && !pathFilter.accept(entry.getName())) continue;
                InputStream is = zf.getInputStream(entry);
                Throwable throwable = null;
                try {
                    try {
                        ClassFile classFile = ClassFile.read(is);
                        this.isPublicApi = false;
                        this.checkPublicApi(classFile);
                    }
                    catch (ConstantPoolException e) {
                        e.printStackTrace();
                    }
                    catch (Descriptor.InvalidDescriptor e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    public Usage removeMatchingPackages(List<Pattern> patterns) {
        boolean used = false;
        boolean usedInPublicApi = false;
        for (Pattern pattern : patterns) {
            Iterator<String> it = this.externalClasses.iterator();
            while (it.hasNext()) {
                String klass = it.next();
                String pkg = this.getPackageFromClass(klass);
                if (!pattern.matcher(pkg).matches()) continue;
                it.remove();
                used = true;
                usedInPublicApi |= this.publicApiExternalClasses.remove(klass);
            }
        }
        return Usage.fromBooleans(used, usedInPublicApi);
    }

    public boolean hasExternalClasses() {
        return !this.externalClasses.isEmpty();
    }

    public Set<String> getExternalPackages() {
        return this.getPackagesFromClasses(this.externalClasses);
    }

    public Set<String> getPublicApiExternalPackages() {
        return this.getPackagesFromClasses(this.publicApiExternalClasses);
    }

    public Set<String> getDefaultPackageClasses() {
        return this.getDefaultPackageClasses(this.externalClasses);
    }

    public Set<String> getPublicApiDefaultPackageClasses() {
        return this.getDefaultPackageClasses(this.publicApiExternalClasses);
    }

    public Set<String> getExternalClasses() {
        return this.externalClasses;
    }

    public Set<String> getPublicApiExternalClasses() {
        return this.publicApiExternalClasses;
    }

    static enum Usage {
        Unused,
        Used,
        UsedInPublicApi;


        public static Usage fromBooleans(boolean used, boolean usedInPublicApi) {
            return usedInPublicApi ? UsedInPublicApi : (used ? Used : Unused);
        }
    }
}

