/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.ShaSigner;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;

public class ModuleCopycat {
    private RepositoryManager srcRepoman;
    private RepositoryManager dstRepoman;
    private CopycatFeedback feedback;
    private Logger log;
    private Set<String> copiedModules;
    private int count;
    private int maxCount;

    public ModuleCopycat(RepositoryManager srcRepoman, RepositoryManager dstRepoman) {
        this(srcRepoman, dstRepoman, null);
    }

    public ModuleCopycat(RepositoryManager srcRepoman, RepositoryManager dstRepoman, CopycatFeedback feedback) {
        this(srcRepoman, dstRepoman, new CMRJULLogger(), feedback);
    }

    public ModuleCopycat(RepositoryManager srcRepoman, RepositoryManager dstRepoman, Logger log, CopycatFeedback feedback) {
        assert (srcRepoman != null);
        assert (dstRepoman != null);
        assert (log != null);
        this.srcRepoman = srcRepoman;
        this.dstRepoman = dstRepoman;
        this.feedback = feedback;
        this.log = log;
        this.copiedModules = new HashSet<String>();
    }

    public void copyModules(List<ArtifactContext> contexts) throws Exception {
        this.count = 0;
        this.maxCount = contexts.size();
        for (ArtifactContext context : contexts) {
            this.copyModuleInternal(context);
        }
    }

    public void copyModule(ArtifactContext context) throws Exception {
        this.count = 0;
        this.maxCount = 1;
        this.copyModuleInternal(context);
    }

    private void copyModuleInternal(ArtifactContext context) throws Exception {
        assert (context != null);
        if (!JDKUtils.isJDKModule(context.getName()) && !JDKUtils.isOracleJDKModule(context.getName())) {
            String module = ModuleUtil.makeModuleName(context.getName(), context.getVersion());
            if (!this.copiedModules.add(module)) {
                if (this.feedback != null) {
                    this.feedback.beforeCopyModule(context, this.count++, this.maxCount);
                }
                if (this.feedback != null) {
                    this.feedback.afterCopyModule(context, this.count, this.maxCount, false);
                }
                return;
            }
            Collection<ModuleVersionDetails> versions = this.getModuleVersions(this.srcRepoman, context.getName(), context.getVersion(), ModuleQuery.Type.ALL, null, null, null, null);
            if (!versions.isEmpty()) {
                ArtifactContext depContext = context.copy();
                ModuleVersionDetails ver = versions.iterator().next();
                boolean copyModule = true;
                if (this.feedback != null) {
                    copyModule = this.feedback.beforeCopyModule(context, this.count++, this.maxCount);
                }
                boolean copiedModule = false;
                if (copyModule) {
                    List<ArtifactResult> results = this.srcRepoman.getArtifactResults(context);
                    int artCnt = 0;
                    for (ArtifactResult r : results) {
                        boolean copied;
                        boolean copyArtifact = true;
                        if (this.feedback != null) {
                            copyArtifact = this.feedback.beforeCopyArtifact(context, r, artCnt++, results.size());
                        }
                        boolean bl = copied = copyArtifact && this.copyArtifact(context, r);
                        if (this.feedback != null) {
                            this.feedback.afterCopyArtifact(context, r, artCnt, results.size(), copied);
                        }
                        copiedModule |= copied;
                    }
                }
                if (this.feedback != null) {
                    this.feedback.afterCopyModule(context, this.count, this.maxCount, copiedModule);
                }
                if (copyModule && !context.isIgnoreDependencies()) {
                    this.maxCount += this.countNonJdkDeps(ver.getDependencies());
                    for (ModuleDependencyInfo dep : ver.getDependencies()) {
                        ModuleSpec depModule = new ModuleSpec(dep.getName(), dep.getVersion());
                        ArtifactContext copyContext = depContext.copy();
                        copyContext.setName(depModule.getName());
                        copyContext.setVersion(depModule.getVersion());
                        this.copyModuleInternal(copyContext);
                    }
                }
            } else if (this.feedback != null) {
                this.feedback.notFound(context);
            }
        }
    }

    private int countNonJdkDeps(NavigableSet<ModuleDependencyInfo> dependencies) {
        int cnt = 0;
        for (ModuleDependencyInfo dep : dependencies) {
            if (JDKUtils.isJDKModule(dep.getName()) || JDKUtils.isOracleJDKModule(dep.getName())) continue;
            ++cnt;
        }
        return cnt;
    }

    private Collection<ModuleVersionDetails> getModuleVersions(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        ModuleVersionQuery query = new ModuleVersionQuery(name, version2, type);
        if (jvmBinaryMajor != null) {
            query.setJvmBinaryMajor(jvmBinaryMajor);
        }
        if (jvmBinaryMinor != null) {
            query.setJvmBinaryMinor(jvmBinaryMinor);
        }
        if (jsBinaryMajor != null) {
            query.setJsBinaryMajor(jsBinaryMajor);
        }
        if (jsBinaryMinor != null) {
            query.setJsBinaryMinor(jsBinaryMinor);
        }
        ModuleVersionResult result = repoMgr.completeVersions(query);
        NavigableMap<String, ModuleVersionDetails> versionMap = result.getVersions();
        return versionMap.values();
    }

    private boolean copyArtifact(ArtifactContext orgac, ArtifactResult ar) throws Exception {
        ArtifactContext ac = orgac.copy();
        String suffix = ArtifactContext.getSuffixFromFilename(ar.artifact().getName());
        ac.setSuffixes(suffix);
        this.dstRepoman.putArtifact(ac, ar.artifact());
        this.signArtifact(ac, ar.artifact());
        return true;
    }

    private void signArtifact(ArtifactContext context, File jarFile) {
        ShaSigner.signArtifact(this.dstRepoman, context, jarFile, this.log);
    }

    public static interface CopycatFeedback {
        public boolean beforeCopyModule(ArtifactContext var1, int var2, int var3) throws Exception;

        public void afterCopyModule(ArtifactContext var1, int var2, int var3, boolean var4) throws Exception;

        public boolean beforeCopyArtifact(ArtifactContext var1, ArtifactResult var2, int var3, int var4) throws Exception;

        public void afterCopyArtifact(ArtifactContext var1, ArtifactResult var2, int var3, int var4, boolean var5) throws Exception;

        public void notFound(ArtifactContext var1) throws Exception;
    }
}

