/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.ceylon.RepoUsingTool;
import com.redhat.ceylon.cmr.ceylon.ShaSigner;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.OptionArgument;
import java.io.File;
import java.util.ResourceBundle;

public abstract class OutputRepoUsingTool
extends RepoUsingTool {
    protected String out;
    protected String user;
    protected String pass;
    private RepositoryManager outrm;
    private String resolvedOutputRepo;
    public static final String DOCSECTION_CONFIG_COMPILER = "## Configuration file\n\nThe compile tool accepts the following options from the Ceylon configuration file: `defaults.offline`, `defaults.encoding`, `compiler.source`, `compiler.resource` and `repositories` (the equivalent options on the command line always have precedence).";
    public static final String DOCSECTION_REPOSITORIES = "## Repositories\n\nRepositories like those specified with the `--rep` or `--out` options can be file paths, HTTP urls to remote servers or can be names of repositories when prepended with a `+` symbol. These names refer to repositories defined in the configuration file or can be any of the following predefined names `+SYSTEM`, `+CACHE`, `+LOCAL`, `+USER`, `+REMOTE` or `+MAVEN`. For more information see http://ceylon-lang.org/documentation/1.2/reference/repository/tools";

    public OutputRepoUsingTool(ResourceBundle bundle) {
        super(bundle);
    }

    @OptionArgument(shortName=111, argumentName="url")
    @Description(value="Specifies the output module repository (which must be publishable). (default: `./modules`)")
    public void setOut(String out) {
        this.out = out;
    }

    @OptionArgument(argumentName="name")
    @Description(value="Sets the user name for use with an authenticated output repository (no default).")
    public void setUser(String user) {
        this.user = user;
    }

    @OptionArgument(argumentName="secret")
    @Description(value="Sets the password for use with an authenticated output repository (no default).")
    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    protected CeylonUtils.CeylonRepoManagerBuilder createRepositoryManagerBuilder(boolean forInput) {
        return super.createRepositoryManagerBuilder(forInput).outRepo(this.out).user(this.user).password(this.pass);
    }

    @Override
    protected CeylonUtils.CeylonRepoManagerBuilder createRepositoryManagerBuilderNoOut(boolean forInput) {
        CeylonUtils.CeylonRepoManagerBuilder repoManagerBuilder = super.createRepositoryManagerBuilderNoOut(forInput);
        if (forInput && this.doNotReadFromOutputRepo()) {
            this.getOutputRepositoryManager();
            repoManagerBuilder.avoidRepo(this.resolvedOutputRepo);
        }
        return repoManagerBuilder;
    }

    protected CeylonUtils.CeylonRepoManagerBuilder createOutputRepositoryManagerBuilder() {
        return super.createRepositoryManagerBuilder(false).outRepo(this.out).user(this.user).password(this.pass);
    }

    protected synchronized RepositoryManager getOutputRepositoryManager() {
        if (this.outrm == null) {
            CeylonUtils.CeylonRepoManagerBuilder rmb = this.createOutputRepositoryManagerBuilder();
            this.outrm = rmb.buildOutputManager();
            this.resolvedOutputRepo = rmb.getResolvedOutRepo();
        }
        return this.outrm;
    }

    protected boolean doNotReadFromOutputRepo() {
        return false;
    }

    protected void signArtifact(ArtifactContext context, File jarFile) {
        ShaSigner.signArtifact(this.getOutputRepositoryManager(), context, jarFile, this.log);
    }
}

