/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.ceylon;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ContentFinder;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.util.JarUtils;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.Messages;
import com.redhat.ceylon.common.ModuleDescriptorReader;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.common.tool.ArgumentParser;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.ParsedBy;
import com.redhat.ceylon.common.tool.StandardArgumentParsers;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolFactory;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.ToolUsageError;
import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.CeylonToolLoader;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.ResourceBundle;
import java.util.TreeSet;

public abstract class RepoUsingTool
extends CeylonBaseTool {
    protected List<URI> repo;
    protected String systemRepo;
    protected String cacheRepo;
    protected String overrides;
    protected int timeout = -1;
    protected boolean noDefRepos;
    protected boolean offline;
    protected Logger log;
    private RepositoryManager rm;
    private Appendable out = System.out;
    private Appendable error = System.err;
    protected ResourceBundle bundle;
    private static final List<String> EMPTY_STRINGS = new ArrayList<String>(0);
    private static final List<URI> EMPTY_URIS = new ArrayList<URI>(0);
    protected static final String COMPILE_NEVER = "never";
    protected static final String COMPILE_ONCE = "once";
    protected static final String COMPILE_CHECK = "check";
    protected static final String COMPILE_FORCE = "force";

    public RepoUsingTool(ResourceBundle bundle) {
        this.bundle = bundle;
        this.log = this.createLogger();
    }

    protected Logger createLogger() {
        return new CMRJULLogger();
    }

    public List<String> getRepositoryAsStrings() {
        if (this.repo != null) {
            ArrayList<String> result = new ArrayList<String>(this.repo.size());
            for (URI uri : this.repo) {
                result.add(uri.toString());
            }
            return result;
        }
        return EMPTY_STRINGS;
    }

    public void setRepositoryAsStrings(List<String> repo) throws Exception {
        if (repo != null) {
            ArrayList<URI> result = new ArrayList<URI>(repo.size());
            for (String r : repo) {
                result.add(StandardArgumentParsers.URI_PARSER.parse(r, this));
            }
            this.setRepository(result);
        } else {
            this.setRepository(EMPTY_URIS);
        }
    }

    @OptionArgument(longName="rep", argumentName="url")
    @Description(value="Specifies a module repository containing dependencies. Can be specified multiple times. (default: `modules`, `~/.ceylon/repo`, `https://modules.ceylon-lang.org/repo/1`)")
    public void setRepository(List<URI> repo) {
        this.repo = repo;
    }

    @OptionArgument(longName="sysrep", argumentName="url")
    @Description(value="Specifies the system repository containing essential modules. (default: `$CEYLON_HOME/repo`)")
    public void setSystemRepository(String systemRepo) {
        this.systemRepo = systemRepo;
    }

    @OptionArgument(longName="cacherep", argumentName="url")
    @Description(value="Specifies the folder to use for caching downloaded modules. (default: `~/.ceylon/cache`)")
    public void setCacheRepository(String cacheRepo) {
        this.cacheRepo = cacheRepo;
    }

    @OptionArgument(longName="maven-overrides", argumentName="url")
    @Description(value="Specifies the XML file to use to load Maven artifact overrides. See http://ceylon-lang.org/documentation/current/reference/repository/maven/ for information. Deprecated: use --overrides.")
    @Deprecated
    public void setMavenOverrides(String mavenOverrides) {
        this.overrides = mavenOverrides;
    }

    @OptionArgument(longName="overrides", argumentName="url")
    @Description(value="Specifies the XML file to use to load module overrides. See http://ceylon-lang.org/documentation/current/reference/repository/maven/ for information. *Experimental*.")
    public void setOverrides(String overrides) {
        this.overrides = overrides;
    }

    @Option(longName="no-default-repositories")
    @Description(value="Indicates that the default repositories should not be used.")
    public void setNoDefRepos(boolean noDefRepos) {
        this.noDefRepos = noDefRepos;
    }

    @Option(shortName=76, longName="offline")
    @Description(value="Enables offline mode that will prevent connections to remote repositories.")
    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    @ParsedBy(value=TimeoutParser.class)
    @OptionArgument(shortName=84, longName="timeout", argumentName="seconds")
    @Description(value="Sets the timeout for connections to remote repositories, use 0 for no timeout (default: 20).")
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setOut(Appendable out) {
        this.out = out;
    }

    protected boolean needsSystemRepo() {
        return true;
    }

    protected CeylonUtils.CeylonRepoManagerBuilder createRepositoryManagerBuilder(boolean forInput) {
        return this.createRepositoryManagerBuilderNoOut(forInput);
    }

    protected CeylonUtils.CeylonRepoManagerBuilder createRepositoryManagerBuilderNoOut(boolean forInput) {
        CeylonUtils.CeylonRepoManagerBuilder rmb = CeylonUtils.repoManager().cwd(this.cwd).overrides(this.overrides).noSystemRepo(!this.needsSystemRepo() && this.noDefRepos).noCacheRepo(this.noDefRepos && this.offline).systemRepo(this.systemRepo).cacheRepo(this.cacheRepo).noDefaultRepos(this.noDefRepos).userRepos(this.getRepositoryAsStrings()).offline(this.offline).timeout(this.timeout).isJDKIncluded(this.includeJDK()).logger(this.log);
        return rmb;
    }

    protected boolean includeJDK() {
        return false;
    }

    protected synchronized RepositoryManager getRepositoryManager() {
        return this.getRepositoryManager(true);
    }

    protected synchronized RepositoryManager getRepositoryManager(boolean upgradeDist) {
        if (this.rm == null) {
            CeylonUtils.CeylonRepoManagerBuilder rmb = this.createRepositoryManagerBuilder(true);
            rmb.upgradeDist(upgradeDist);
            this.rm = rmb.buildManager();
        }
        return this.rm;
    }

    protected ModuleVersionQuery getModuleVersionQuery(String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        ModuleVersionQuery query = new ModuleVersionQuery(name, version2, type);
        if (jvmBinaryMajor != null) {
            query.setJvmBinaryMajor(jvmBinaryMajor);
        }
        if (jvmBinaryMinor != null) {
            query.setJvmBinaryMinor(jvmBinaryMinor);
        }
        if (jsBinaryMajor != null) {
            query.setJsBinaryMajor(jsBinaryMajor);
        }
        if (jsBinaryMinor != null) {
            query.setJsBinaryMinor(jsBinaryMinor);
        }
        return query;
    }

    protected Collection<ModuleVersionDetails> getModuleVersions(String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        return this.getModuleVersions(this.getRepositoryManager(), name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
    }

    protected Collection<ModuleVersionDetails> getModuleVersions(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) {
        ModuleVersionQuery query = this.getModuleVersionQuery(name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
        ModuleVersionResult result = repoMgr.completeVersions(query);
        NavigableMap<String, ModuleVersionDetails> versionMap = result.getVersions();
        return versionMap.values();
    }

    protected String checkModuleVersionsOrShowSuggestions(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) throws IOException {
        return this.checkModuleVersionsOrShowSuggestions(repoMgr, name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor, COMPILE_NEVER);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String checkModuleVersionsOrShowSuggestions(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor, String compileFlags) throws IOException {
        boolean suggested;
        Collection<ModuleVersionDetails> versions;
        block36: {
            ModuleVersionDetails srcVersion;
            boolean allowCompilation;
            boolean checkCompilation;
            boolean forceCompilation;
            block35: {
                ModuleVersionDetails compiledVersion;
                block34: {
                    if (compileFlags == null || compileFlags.isEmpty()) {
                        compileFlags = COMPILE_NEVER;
                    }
                    forceCompilation = compileFlags.contains(COMPILE_FORCE);
                    checkCompilation = compileFlags.contains(COMPILE_CHECK);
                    allowCompilation = forceCompilation || checkCompilation || compileFlags.contains(COMPILE_ONCE);
                    versions = null;
                    if (ModuleUtil.isDefaultModule(name) || version2 != null) {
                        ArtifactContext ac = new ArtifactContext(name, version2, type.getSuffixes());
                        ac.setIgnoreDependencies(true);
                        ac.setThrowErrorIfMissing(false);
                        ArtifactResult result = repoMgr.getArtifactResult(ac);
                        if (result != null) {
                            if (forceCompilation || checkCompilation) {
                                versions = Collections.singletonList(new ModuleVersionDetails(name, result.version()));
                                break block34;
                            } else {
                                if (result.version() == null) return "";
                                String string = result.version();
                                return string;
                            }
                        }
                        if (ModuleUtil.isDefaultModule(name) && !allowCompilation) {
                            String err = this.getModuleNotFoundErrorMessage(repoMgr, name, version2);
                            throw new ToolUsageError(err);
                        }
                    }
                }
                suggested = false;
                if (version2 == null && !ModuleUtil.isDefaultModule(name) && versions == null && (versions = this.findCompiledVersions(repoMgr, name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor)) != null && versions.size() == 1 && (compiledVersion = versions.iterator().next()) != null && compiledVersion.getVersion() != null) {
                    if (!forceCompilation) {
                        if (!checkCompilation) return compiledVersion.getVersion();
                    }
                    versions = Collections.singleton(compiledVersion);
                }
                srcVersion = null;
                if ((allowCompilation || versions != null && versions.size() > 1) && (srcVersion = this.getVersionFromSource(name)) != null && version2 == null) {
                    if (versions == null) {
                        versions = Collections.emptyList();
                    } else {
                        for (ModuleVersionDetails mvd : versions) {
                            if (!this.sameVersion(name, mvd.getVersion(), srcVersion.getVersion())) continue;
                            if (!forceCompilation) {
                                if (!checkCompilation) return mvd.getVersion();
                            }
                            versions = Collections.singleton(mvd);
                        }
                    }
                }
                if (versions == null) {
                    versions = this.getModuleVersions(repoMgr, name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                    if (version2 != null && !versions.isEmpty()) {
                        boolean partialMatch = false;
                        ModuleVersionDetails exactMatch = null;
                        for (ModuleVersionDetails v : versions) {
                            if (version2.equals(v.getVersion())) {
                                exactMatch = v;
                                continue;
                            }
                            if (!v.getVersion().startsWith(version2)) continue;
                            partialMatch = true;
                        }
                        if (exactMatch != null && !partialMatch) {
                            versions = Collections.singletonList(exactMatch);
                        }
                    }
                }
                if (version2 == null || !versions.isEmpty() && !this.exactSingleMatch(versions, version2)) break block35;
                if (versions.isEmpty() || forceCompilation || this.shouldRecompile(checkCompilation, repoMgr, name, version2, type)) {
                    if (allowCompilation && srcVersion != null) {
                        if (version2.equals(srcVersion.getVersion())) {
                            if (!this.runCompiler(repoMgr, name, type)) {
                                throw new ToolUsageError(Messages.msg(this.bundle, "compilation.failed", new Object[0]));
                            }
                        } else {
                            suggested = true;
                        }
                        versions = Arrays.asList(srcVersion);
                    }
                    if (versions.isEmpty()) {
                        versions = this.getModuleVersions(repoMgr, name, null, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                        suggested = true;
                    }
                }
                break block36;
            }
            if (allowCompilation && (versions.isEmpty() || this.onlyRemote(versions) || forceCompilation || checkCompilation) && srcVersion != null && (version2 == null || version2.equals(srcVersion.getVersion()))) {
                String srcver = srcVersion.getVersion();
                if (!(checkCompilation && !this.shouldRecompile(checkCompilation, repoMgr, name, srcver, type) || this.runCompiler(repoMgr, name, type))) {
                    throw new ToolUsageError(Messages.msg(this.bundle, "compilation.failed", new Object[0]));
                }
                versions = Arrays.asList(srcVersion);
            }
        }
        if (versions.isEmpty()) {
            String err = this.getModuleNotFoundErrorMessage(repoMgr, name, version2);
            throw new ToolUsageError(err);
        }
        if (versions.size() <= 1 && !this.inexactSingleMatch(versions, version2) && !suggested) {
            if (!ModuleUtil.isDefaultModule(name)) return versions.iterator().next().getVersion();
            return "";
        }
        StringBuilder err = new StringBuilder();
        if (version2 == null) {
            err.append(Messages.msg(this.bundle, "missing.version", name));
        } else {
            err.append(Messages.msg(this.bundle, "version.not.found", version2, name));
        }
        err.append("\n");
        err.append(Messages.msg(this.bundle, "try.versions", new Object[0]));
        boolean first = true;
        Iterator<ModuleVersionDetails> i$ = versions.iterator();
        while (true) {
            if (!i$.hasNext()) {
                err.append("\n");
                throw new ToolUsageError(err.toString());
            }
            ModuleVersionDetails mvd = i$.next();
            if (!first) {
                err.append(", ");
            }
            err.append(mvd.getVersion());
            if (mvd.isRemote()) {
                err.append(" (*)");
            }
            first = false;
        }
    }

    private boolean sameVersion(String name, String version1, String version2) {
        if (ModuleUtil.isDefaultModule(name)) {
            return version1 == null && version2 == null;
        }
        return version1 != null && version2 != null && version1.equals(version2);
    }

    private boolean exactSingleMatch(Collection<ModuleVersionDetails> versions, String version2) {
        return version2 != null && versions.size() == 1 && version2.equals(versions.iterator().next().getVersion());
    }

    private boolean inexactSingleMatch(Collection<ModuleVersionDetails> versions, String version2) {
        return version2 != null && versions.size() == 1 && !version2.equals(versions.iterator().next().getVersion());
    }

    private Collection<ModuleVersionDetails> findCompiledVersions(RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type, Integer jvmBinaryMajor, Integer jvmBinaryMinor, Integer jsBinaryMajor, Integer jsBinaryMinor) throws IOException {
        String outRepo = DefaultToolOptions.getCompilerOutputRepo();
        if (outRepo != null) {
            File outDir = new File(outRepo);
            ContentFinder rep = null;
            List<CmrRepository> repositories = repoMgr.getRepositories();
            for (CmrRepository repository : repositories) {
                File repoFile;
                ContentHandle content;
                ContentStore service;
                OpenNode root = repository.getRoot();
                if (root.isRemote() || root.hasBinaries() || (service = root.getService(ContentStore.class)) == null || (content = service.peekContent(root)) == null || content.hasBinaries() || (repoFile = content.getContentAsFile()) == null || !FileUtil.sameFile(repoFile, outDir)) continue;
                rep = repository;
                break;
            }
            if (rep != null && rep.isSearchable()) {
                ModuleVersionQuery query = this.getModuleVersionQuery(name, version2, type, jvmBinaryMajor, jvmBinaryMinor, jsBinaryMajor, jsBinaryMinor);
                ModuleVersionResult result = new ModuleVersionResult(query.getName());
                rep.completeVersions(query, result);
                NavigableMap<String, ModuleVersionDetails> outRepoVersions = result.getVersions();
                if (!outRepoVersions.isEmpty()) {
                    return outRepoVersions.values();
                }
            }
        }
        return null;
    }

    protected String getModuleNotFoundErrorMessage(RepositoryManager repoMgr, String name, String version2) {
        return this.getModuleNotFoundErrorMessage(repoMgr, name, version2, "module.not.found");
    }

    protected String getModuleNotFoundErrorMessage(RepositoryManager repoMgr, String name, String version2, String msgkeyNotFound) {
        StringBuilder err = new StringBuilder();
        err.append(Messages.msg(this.bundle, msgkeyNotFound, name, version2));
        err.append("\n");
        boolean fullySearchable = true;
        for (CmrRepository repo : repoMgr.getRepositories()) {
            if (version2 != null || repo.isSearchable()) {
                err.append("    ");
                err.append(repo.getDisplayString());
                err.append("\n");
                continue;
            }
            fullySearchable = false;
        }
        if (version2 == null && !fullySearchable) {
            err.append(Messages.msg(this.bundle, "missing.version.suggestion", new Object[0]));
        }
        return err.toString();
    }

    private boolean shouldRecompile(boolean checkCompilation, RepositoryManager repoMgr, String name, String version2, ModuleQuery.Type type) throws IOException {
        if (checkCompilation) {
            ArtifactContext ac = new ArtifactContext(name, version2, type.getSuffixes());
            ac.setIgnoreDependencies(true);
            ac.setThrowErrorIfMissing(false);
            File artifile = repoMgr.getArtifact(ac);
            if (artifile == null) {
                return true;
            }
            long oldestArtifact = type == ModuleQuery.Type.JVM ? JarUtils.oldestFileTime(artifile) : artifile.lastModified();
            long newestSource = this.getNewestLastmodified(name);
            if (newestSource > oldestArtifact) {
                return true;
            }
        }
        return false;
    }

    private long getNewestLastmodified(String name) throws IOException {
        final long[] newest = new long[]{-1L};
        List<File> srcDirs = this.getSourceDirs();
        for (File srcDir : srcDirs) {
            File moduleDir = ModuleUtil.moduleToPath(srcDir, name);
            if (!moduleDir.isDirectory() || !moduleDir.canRead()) continue;
            Files.walkFileTree(moduleDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (newest[0] == -1L || file.toFile().lastModified() > newest[0]) {
                        newest[0] = file.toFile().lastModified();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return newest[0];
    }

    private boolean onlyRemote(Collection<ModuleVersionDetails> versions) {
        for (ModuleVersionDetails version2 : versions) {
            if (version2.isRemote()) continue;
            return false;
        }
        return true;
    }

    protected ModuleVersionDetails getVersionFromSource(String name) {
        try {
            List<File> srcDirs = this.getSourceDirs();
            for (File srcDir : srcDirs) {
                try {
                    ModuleDescriptorReader mdr = new ModuleDescriptorReader(name, this.applyCwd(srcDir));
                    String module = mdr.getModuleName();
                    String version2 = mdr.getModuleVersion();
                    ModuleVersionDetails mvd = new ModuleVersionDetails(module != null ? module : "", version2 != null ? version2 : "");
                    mvd.setLicense(mdr.getModuleLicense());
                    List<String> by = mdr.getModuleAuthors();
                    if (by != null) {
                        mvd.getAuthors().addAll(by);
                    }
                    TreeSet<ModuleDependencyInfo> dependencies = new TreeSet<ModuleDependencyInfo>();
                    for (Object[] dep : mdr.getModuleImports()) {
                        dependencies.add(new ModuleDependencyInfo((String)dep[0], (String)dep[1], (Boolean)dep[2], (Boolean)dep[3]));
                    }
                    mvd.setDependencies(dependencies);
                    mvd.setRemote(false);
                    mvd.setOrigin("Local source folder");
                    return mvd;
                }
                catch (ModuleDescriptorReader.NoSuchModuleException noSuchModuleException) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected List<File> getSourceDirs() {
        return DefaultToolOptions.getCompilerSourceDirs();
    }

    protected boolean isSourceModule(String name, String version2, List<File> srcDirs) {
        for (File srcDir : srcDirs) {
            if (!this.isSourceModule(srcDir, name, version2)) continue;
            return true;
        }
        return false;
    }

    private boolean isSourceModule(File srcDir, String name, String version2) {
        try {
            ModuleDescriptorReader mdr = new ModuleDescriptorReader(name, srcDir);
            String declaredVersion = mdr.getModuleVersion();
            return name.equals("default") || version2.equals(declaredVersion);
        }
        catch (ModuleDescriptorReader.NoSuchModuleException x) {
            return false;
        }
    }

    protected List<ModuleSpec> getSourceModules(List<File> srcDirs) {
        HashMap<String, ModuleSpec> modules = new HashMap<String, ModuleSpec>();
        for (File srcDir : srcDirs) {
            this.collectModules(srcDir, srcDir, modules);
        }
        ArrayList<ModuleSpec> ret = new ArrayList<ModuleSpec>(modules.size());
        ret.addAll(modules.values());
        return ret;
    }

    private void collectModules(File sourceRoot, File sourceFile, Map<String, ModuleSpec> modules) {
        if (sourceFile.isDirectory()) {
            File moduleFile = new File(sourceFile, "module.ceylon");
            if (moduleFile.exists()) {
                this.collectModule(sourceRoot, sourceFile, modules);
                return;
            }
            for (File f : sourceFile.listFiles()) {
                this.collectModules(sourceRoot, f, modules);
            }
        } else {
            String name = sourceFile.getName().toLowerCase();
            if ((name.endsWith(".ceylon") || name.endsWith(".java") || name.endsWith(".js")) && !modules.containsKey("default")) {
                modules.put("default", new ModuleSpec("default", null));
            }
        }
    }

    private void collectModule(File sourceRoot, File sourceFile, Map<String, ModuleSpec> modules) {
        File relativeFile = FileUtil.relativeFile(sourceRoot, sourceFile);
        String name = relativeFile.getPath().replace(File.separatorChar, '.');
        if (modules.containsKey(name)) {
            return;
        }
        try {
            ModuleDescriptorReader mdr = new ModuleDescriptorReader(name, sourceRoot);
            String version2 = mdr.getModuleVersion();
            if (version2 != null) {
                modules.put(name, new ModuleSpec(name, version2));
            }
        }
        catch (ModuleDescriptorReader.NoSuchModuleException x) {
            x.printStackTrace();
        }
    }

    private boolean runCompiler(RepositoryManager repoMgr, String name, ModuleQuery.Type type) {
        String toolName;
        ArrayList<String> args = new ArrayList<String>();
        if (this.systemRepo != null) {
            args.add("--sysrep");
            args.add(this.systemRepo);
        }
        if (this.cacheRepo != null) {
            args.add("--cacherep");
            args.add(this.cacheRepo);
        }
        if (this.repo != null) {
            for (URI r : this.repo) {
                args.add("--rep");
                args.add(r.toString());
            }
        }
        if (this.offline) {
            args.add("--offline");
        }
        if (this.verbose != null) {
            args.add("--verbose=" + this.verbose);
        }
        args.add(name);
        ToolFactory pluginFactory = new ToolFactory();
        CeylonToolLoader pluginLoader = new CeylonToolLoader();
        if (type == ModuleQuery.Type.JVM) {
            toolName = "compile";
        } else if (type == ModuleQuery.Type.JS) {
            toolName = "compile-js";
        } else if (type == ModuleQuery.Type.DART) {
            toolName = "compile-dart";
        } else {
            throw new IllegalArgumentException("Unknown compile flags passed");
        }
        ToolModel model = pluginLoader.loadToolModel(toolName);
        Object tool = pluginFactory.bindArguments(model, (CeylonTool)pluginLoader.instance("", null), args);
        try {
            this.msg("compiling", name).newline();
            tool.run();
            repoMgr.refresh(false);
            if (repoMgr == this.rm) {
                this.rm = null;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public RepoUsingTool errorMsg(String msgKey, Object ... msgArgs) throws IOException {
        this.error.append(Messages.msg(this.bundle, msgKey, msgArgs));
        this.error.append(System.lineSeparator());
        return this;
    }

    public RepoUsingTool msg(Appendable out, String msgKey, Object ... msgArgs) throws IOException {
        out.append(Messages.msg(this.bundle, msgKey, msgArgs));
        return this;
    }

    public RepoUsingTool msg(String msgKey, Object ... msgArgs) throws IOException {
        return this.msg(this.out, msgKey, msgArgs);
    }

    public RepoUsingTool append(Appendable out, Object s) throws IOException {
        out.append(String.valueOf(s));
        return this;
    }

    public RepoUsingTool append(Object s) throws IOException {
        return this.append(this.out, s);
    }

    public RepoUsingTool errorAppend(Object s) throws IOException {
        return this.append(this.error, s);
    }

    public RepoUsingTool newline(Appendable out) throws IOException {
        out.append(System.lineSeparator());
        return this;
    }

    public RepoUsingTool newline() throws IOException {
        return this.newline(this.out);
    }

    public RepoUsingTool errorNewline() throws IOException {
        return this.newline(this.error);
    }

    public RepoUsingTool flush() throws IOException {
        if (this.out instanceof Flushable) {
            ((Flushable)((Object)this.out)).flush();
        }
        if (this.error instanceof Flushable) {
            ((Flushable)((Object)this.error)).flush();
        }
        return this;
    }

    public Appendable getOutAppendable() {
        return this.out;
    }

    public static class TimeoutParser
    implements ArgumentParser<Integer> {
        @Override
        public Integer parse(String argument, Tool tool) {
            int fact = 1000;
            if (argument.endsWith("ms")) {
                argument = argument.substring(0, argument.length() - 2);
                fact = 1;
            }
            return Integer.valueOf(argument) * fact;
        }
    }
}

