/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.ImportType;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.model.cmr.VisibilityType;
import java.io.File;

public abstract class AbstractArtifactResult
implements ArtifactResult {
    private String name;
    private String version;
    private volatile File artifact;
    private volatile boolean checked;
    private PathFilter filter;
    private Repository repository;

    protected AbstractArtifactResult(Repository repository, String name, String version2) {
        this.repository = repository;
        this.name = name;
        this.version = version2;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public ImportType importType() {
        return ImportType.UNDEFINED;
    }

    @Override
    public VisibilityType visibilityType() {
        File file;
        if (this.type() == ArtifactResultType.CEYLON && (file = this.artifact()) != null && file.getName().endsWith(".car")) {
            return VisibilityType.STRICT;
        }
        return VisibilityType.LOOSE;
    }

    @Override
    public File artifact() throws RepositoryException {
        if (this.artifact == null && !this.checked) {
            this.checked = true;
            this.artifact = this.artifactInternal();
        }
        return this.artifact;
    }

    protected abstract File artifactInternal();

    @Override
    public PathFilter filter() {
        return this.filter;
    }

    protected void setFilterInternal(PathFilter filter) {
        this.filter = filter;
    }

    public String toString() {
        if (this.artifact() != null) {
            try {
                String suffix = ArtifactContext.getSuffixFromFilename(this.artifact().getName());
                return "[Artifact result: " + this.name + "/" + this.version + " (" + suffix + ")]";
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return "[Artifact result: " + this.name + "/" + this.version + "]";
    }

    @Override
    public Repository repository() {
        return this.repository;
    }
}

