/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.MarkerNode;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentTransformer;
import com.redhat.ceylon.cmr.spi.MergeStrategy;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractOpenNode
implements OpenNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NODE_MARKER = "#marker#";
    protected static final ContentHandle HANDLE_MARKER = new ContentHandle(){

        @Override
        public boolean hasBinaries() {
            return false;
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            return null;
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            return null;
        }

        @Override
        public File getContentAsFile() throws IOException {
            return null;
        }

        @Override
        public long getLastModified() throws IOException {
            return -1L;
        }

        @Override
        public long getSize() throws IOException {
            return -1L;
        }

        @Override
        public void clean() {
        }
    };
    private String label;
    private Object value;
    private final ConcurrentMap<String, OpenNode> parents = new ConcurrentHashMap<String, OpenNode>();
    private final ConcurrentMap<String, OpenNode> children = new ConcurrentHashMap<String, OpenNode>();
    private final transient Map<Class<?>, Object> services = new WeakHashMap();

    public AbstractOpenNode() {
    }

    public AbstractOpenNode(String label, Object value) {
        this.label = label;
        this.value = value;
    }

    protected <T> T findService(Class<T> serviceType) {
        T service = this.getService(serviceType);
        if (service != null) {
            return service;
        }
        for (Node node : this.getParents()) {
            AbstractOpenNode dn;
            T ps;
            if (!(node instanceof AbstractOpenNode) || (ps = (dn = (AbstractOpenNode)node).findService(serviceType)) == null) continue;
            this.addService(serviceType, ps);
            return ps;
        }
        throw new IllegalArgumentException("No such service [" + serviceType + "] found in node chain!");
    }

    @Override
    public synchronized <T> void addService(Class<T> serviceType, T service) {
        if (serviceType == null) {
            throw new IllegalArgumentException("Null service type");
        }
        if (service != null) {
            this.services.put(serviceType, service);
        } else {
            this.services.remove(serviceType);
        }
    }

    @Override
    public synchronized <T> T getService(Class<T> serviceType) {
        return serviceType.cast(this.services.get(serviceType));
    }

    protected OpenNode putChildIfAbsent(String label, OpenNode child) {
        return this.children.putIfAbsent(label, child);
    }

    protected OpenNode putParentIfAbsent(String label, OpenNode parent) {
        return this.parents.putIfAbsent(label, parent);
    }

    @Override
    public void link(OpenNode child) {
        if (child == null) {
            throw new IllegalArgumentException("Null node!");
        }
        OpenNode previous = this.children.putIfAbsent(child.getLabel(), child);
        if (previous == null) {
            if (child instanceof AbstractOpenNode) {
                AbstractOpenNode dn = (AbstractOpenNode)child;
                dn.parents.put(this.getLabel(), this);
            }
        } else {
            MergeStrategy ms = this.findService(MergeStrategy.class);
            ms.conflict(previous, child);
        }
    }

    @Override
    public OpenNode addNode(String label) {
        return this.addNode(label, null);
    }

    @Override
    public OpenNode createNode(String label) {
        return this.getNode(label, true);
    }

    @Override
    public Node removeNode(String label) {
        Node node = this.getChild(label);
        if (node != null) {
            this.children.remove(label);
            this.children.remove(label + NODE_MARKER);
        }
        return node;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public <T> T getValue(Class<T> valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Null value type");
        }
        return valueType.cast(this.value);
    }

    @Override
    public OpenNode peekChild(String label) {
        return (OpenNode)this.children.get(label);
    }

    @Override
    public Node getChild(String label) {
        OpenNode child = (OpenNode)this.children.get(label);
        if (child == null) {
            String markerLabel = label + NODE_MARKER;
            OpenNode marker = (OpenNode)this.children.get(markerLabel);
            if (marker == null) {
                child = this.getNode(label, false);
                this.children.put(markerLabel, new MarkerNode(label, child));
            } else {
                return marker.getValue(Node.class);
            }
        }
        return child;
    }

    protected OpenNode getNode(String label, boolean create) {
        OpenNode child;
        StructureBuilder builder = this.findService(StructureBuilder.class);
        OpenNode openNode = child = create ? builder.create(this, label) : builder.find(this, label);
        if (child != null) {
            child = this.put(this.children, label, child);
        }
        return child;
    }

    protected OpenNode put(ConcurrentMap<String, OpenNode> map, String label, OpenNode child) {
        OpenNode previous = map.putIfAbsent(label, child);
        if (previous == null) {
            if (child instanceof AbstractOpenNode) {
                AbstractOpenNode dn = (AbstractOpenNode)child;
                dn.parents.put(this.getLabel(), this);
            }
        } else {
            child = previous;
        }
        return child;
    }

    @Override
    public Iterable<? extends Node> getChildren() {
        if (!this.children.containsKey(NODE_MARKER)) {
            this.children.put(NODE_MARKER, new MarkerNode());
            ConcurrentHashMap<String, OpenNode> tmp = new ConcurrentHashMap<String, OpenNode>();
            for (OpenNode openNode : this.findService(StructureBuilder.class).find(this)) {
                this.put(tmp, openNode.getLabel(), openNode);
            }
            this.children.putAll(tmp);
            return tmp.values();
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : this.children.values()) {
            if (node instanceof MarkerNode) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public void refresh(boolean recurse) {
        Iterator iter = this.children.entrySet().iterator();
        while (iter.hasNext()) {
            String key;
            Map.Entry entry = iter.next();
            if (recurse) {
                ((OpenNode)entry.getValue()).refresh(recurse);
            }
            if (!(key = (String)entry.getKey()).endsWith(NODE_MARKER)) continue;
            iter.remove();
        }
    }

    @Override
    public <T> T getContent(Class<T> contentType) throws IOException {
        if (contentType == null) {
            throw new IllegalArgumentException("Null content type!");
        }
        if (InputStream.class.equals(contentType)) {
            return (T)this.getInputStream();
        }
        ContentTransformer ct = this.findService(ContentTransformer.class);
        if (ct != null) {
            return ct.transform(contentType, new LazyInputStream());
        }
        return IOUtils.fromStream(contentType, this.getInputStream());
    }

    @Override
    public Node getParent(String label) {
        return (Node)this.parents.get(label);
    }

    @Override
    public Iterable<? extends Node> getParents() {
        return this.parents.values();
    }

    public String toString() {
        return "[" + this.getLabel() + "]";
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Node)) {
            return false;
        }
        Node dn = (Node)obj;
        if (!this.label.equals(dn.getLabel())) {
            return false;
        }
        for (Node node : this.getParents()) {
            for (Node node2 : dn.getParents()) {
                if (!node.equals(node2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getStoreDisplayString() {
        return "";
    }

    protected class LazyInputStream
    extends InputStream {
        private InputStream delegate;

        protected LazyInputStream() {
        }

        private InputStream getDelegate() throws IOException {
            if (this.delegate == null) {
                InputStream is = AbstractOpenNode.this.getInputStream();
                if (is == null) {
                    throw new IllegalArgumentException("Null input stream!");
                }
                this.delegate = is;
            }
            return this.delegate;
        }

        @Override
        public int read() throws IOException {
            return this.getDelegate().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.getDelegate().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.getDelegate().read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.getDelegate().skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.getDelegate().available();
        }

        @Override
        public void mark(int readlimit) {
            try {
                this.getDelegate().mark(readlimit);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void reset() throws IOException {
            this.getDelegate().reset();
        }

        @Override
        public boolean markSupported() {
            try {
                return this.getDelegate().markSupported();
            }
            catch (IOException ignored) {
                return false;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.delegate != null) {
                this.delegate.close();
            }
        }
    }
}

