/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ContentFinderDelegate;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.AbstractContentStore;
import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.log.Logger;

public abstract class AbstractRemoteContentStore
extends AbstractContentStore
implements ContentFinderDelegate {
    protected AbstractRemoteContentStore(Logger log, boolean offline, int timeout) {
        super(log, offline, timeout);
    }

    @Override
    public OpenNode createRoot() {
        RemoteRootNode node = new RemoteRootNode();
        node.addService(ContentStore.class, this);
        node.addService(StructureBuilder.class, this);
        node.addService(ContentFinderDelegate.class, this);
        node.setHandle(DefaultNode.HANDLE_MARKER);
        return node;
    }

    protected RemoteNode createNode(String label) {
        return new RemoteNode(label);
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public void completeModules(ModuleQuery lookup, ModuleSearchResult result, Overrides overrides) {
    }

    @Override
    public void completeVersions(ModuleVersionQuery lookup, ModuleVersionResult result, Overrides overrides) {
    }

    @Override
    public void searchModules(ModuleQuery query, ModuleSearchResult result, Overrides overrides) {
    }

    protected static class RemoteRootNode
    extends RemoteNode {
        public RemoteRootNode() {
            super("");
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String getDisplayString() {
            return this.getService(ContentStore.class).getDisplayString();
        }
    }

    protected static class RemoteNode
    extends DefaultNode {
        private String cachedString;

        public RemoteNode(String label) {
            super(label);
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public String toString() {
            if (this.cachedString == null) {
                StringBuilder builder = new StringBuilder("RemoteNode for ");
                builder.append(this.findService(ContentStore.class));
                builder.append(" -> [").append(NodeUtils.getFullPath(this)).append("]");
                this.cachedString = builder.toString();
            }
            return this.cachedString;
        }
    }
}

