/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.ModuleInfoReader;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.JVMModuleUtil;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

public final class BytecodeUtils
extends AbstractDependencyResolver
implements ModuleInfoReader {
    public static BytecodeUtils INSTANCE = new BytecodeUtils();
    private static final DotName MODULE_ANNOTATION = DotName.createSimple("com.redhat.ceylon.compiler.java.metadata.Module");
    private static final DotName PACKAGE_ANNOTATION = DotName.createSimple("com.redhat.ceylon.compiler.java.metadata.Package");
    private static final DotName CEYLON_ANNOTATION = DotName.createSimple("com.redhat.ceylon.compiler.java.metadata.Ceylon");
    private static final DotName IGNORE_ANNOTATION = DotName.createSimple("com.redhat.ceylon.compiler.java.metadata.Ignore");
    private static final DotName LOCAL_CONTAINER_ANNOTATION = DotName.createSimple("com.redhat.ceylon.compiler.java.metadata.LocalContainer");

    private BytecodeUtils() {
    }

    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (context.ignoreInner()) {
            return null;
        }
        ArtifactResult result = context.result();
        return BytecodeUtils.readModuleInformation(result.name(), result.artifact(), overrides);
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .car files");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .car files");
    }

    @Override
    public Node descriptor(Node artifact) {
        return null;
    }

    private static ModuleInfo readModuleInformation(String moduleName, File jarFile, Overrides overrides) {
        Index index = BytecodeUtils.readModuleIndex(moduleName, jarFile, false);
        AnnotationInstance ai = BytecodeUtils.getAnnotation(index, moduleName, MODULE_ANNOTATION);
        if (ai == null) {
            return null;
        }
        AnnotationValue version2 = ai.value("version");
        if (version2 == null) {
            return null;
        }
        AnnotationValue dependencies = ai.value("dependencies");
        if (dependencies == null) {
            return new ModuleInfo(null, Collections.emptySet());
        }
        LinkedHashSet<ModuleDependencyInfo> infos = new LinkedHashSet<ModuleDependencyInfo>();
        AnnotationInstance[] imports = dependencies.asNestedArray();
        if (imports != null) {
            for (AnnotationInstance im : imports) {
                String name = BytecodeUtils.asString(im, "name");
                ModuleDependencyInfo mi = new ModuleDependencyInfo(name, BytecodeUtils.asString(im, "version"), BytecodeUtils.asBoolean(im, "optional"), BytecodeUtils.asBoolean(im, "export"));
                infos.add(mi);
            }
        }
        ModuleInfo ret = new ModuleInfo(null, infos);
        if (overrides != null) {
            ret = overrides.applyOverrides(moduleName, version2.asString(), ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Index readModuleIndex(String moduleName, File jarFile, boolean everything) {
        try (JarFile jar = new JarFile(jarFile);){
            Indexer indexer = new Indexer();
            if (!everything) {
                Object stream;
                if ("default".equals(moduleName)) {
                    Index index = indexer.complete();
                    return index;
                }
                String modulePath = BytecodeUtils.getModulePath(moduleName);
                String name1 = modulePath + "/$module_.class";
                JarEntry entry = jar.getJarEntry(name1);
                if (entry == null) {
                    String name2 = modulePath + "/module_.class";
                    entry = jar.getJarEntry(name2);
                }
                if (entry != null) {
                    stream = jar.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        indexer.index((InputStream)stream);
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (stream != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)stream).close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ((InputStream)stream).close();
                            }
                        }
                    }
                }
                stream = indexer.complete();
                return stream;
            }
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName().toLowerCase();
                if (!everything || !name.endsWith(".class")) continue;
                InputStream stream = jar.getInputStream(entry);
                Throwable throwable = null;
                try {
                    indexer.index(stream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            Index index = indexer.complete();
            return index;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read index for module " + jarFile.getPath(), e);
        }
    }

    private static String getModulePath(String moduleName) {
        String quotedModuleName = JVMModuleUtil.quoteJavaKeywords(moduleName);
        return quotedModuleName.replace('.', '/');
    }

    private static ClassInfo getModuleInfo(Index index, String moduleName) {
        String quotedModuleName = JVMModuleUtil.quoteJavaKeywords(moduleName);
        DotName moduleClassName = DotName.createSimple(quotedModuleName + ".$module_");
        ClassInfo ret = index.getClassByName(moduleClassName);
        if (ret == null) {
            moduleClassName = DotName.createSimple(quotedModuleName + ".module_");
            ret = index.getClassByName(moduleClassName);
        }
        return ret;
    }

    @Override
    public int[] getBinaryVersions(String moduleName, String moduleVersion, File moduleArchive) {
        Index index = BytecodeUtils.readModuleIndex(moduleName, moduleArchive, false);
        AnnotationInstance ceylonAnnotation = BytecodeUtils.getAnnotation(index, moduleName, CEYLON_ANNOTATION);
        if (ceylonAnnotation == null) {
            return null;
        }
        AnnotationValue majorAnnotation = ceylonAnnotation.value("major");
        AnnotationValue minorAnnotation = ceylonAnnotation.value("minor");
        int major = majorAnnotation != null ? majorAnnotation.asInt() : 0;
        int minor = minorAnnotation != null ? minorAnnotation.asInt() : 0;
        return new int[]{major, minor};
    }

    @Override
    public ModuleVersionDetails readModuleInfo(String moduleName, String moduleVersion, File moduleArchive, boolean includeMembers, Overrides overrides) {
        Index index = BytecodeUtils.readModuleIndex(moduleName, moduleArchive, true);
        AnnotationInstance moduleAnnotation = BytecodeUtils.getAnnotation(index, moduleName, MODULE_ANNOTATION);
        if (moduleAnnotation == null) {
            return null;
        }
        AnnotationValue doc = moduleAnnotation.value("doc");
        AnnotationValue license = moduleAnnotation.value("license");
        AnnotationValue by = moduleAnnotation.value("by");
        AnnotationValue dependencies = moduleAnnotation.value("dependencies");
        String type = ArtifactContext.getSuffixFromFilename(moduleArchive.getName());
        AnnotationInstance ceylonAnnotation = BytecodeUtils.getAnnotation(index, moduleName, CEYLON_ANNOTATION);
        if (ceylonAnnotation == null) {
            return null;
        }
        AnnotationValue majorVer = ceylonAnnotation.value("major");
        AnnotationValue minorVer = ceylonAnnotation.value("minor");
        ModuleVersionDetails mvd = new ModuleVersionDetails(moduleName, BytecodeUtils.getVersionFromFilename(moduleName, moduleArchive.getName()));
        mvd.setDoc(doc != null ? doc.asString() : null);
        mvd.setLicense(license != null ? license.asString() : null);
        if (by != null) {
            mvd.getAuthors().addAll(Arrays.asList(by.asStringArray()));
        }
        mvd.getDependencies().addAll(BytecodeUtils.getDependencies(dependencies, moduleName, mvd.getVersion(), overrides));
        ModuleVersionArtifact mva = new ModuleVersionArtifact(type, majorVer != null ? majorVer.asInt() : 0, minorVer != null ? minorVer.asInt() : 0);
        mvd.getArtifactTypes().add(mva);
        if (includeMembers) {
            mvd.setMembers(this.getMembers(index));
        }
        return mvd;
    }

    private Set<String> getMembers(Index index) {
        HashSet<String> members = new HashSet<String>();
        for (ClassInfo cls : index.getKnownClasses()) {
            if (!this.shouldAddMember(cls)) continue;
            members.add(BytecodeUtils.classNameToDeclName(cls.name().toString()));
        }
        return members;
    }

    private boolean shouldAddMember(ClassInfo cls) {
        if (this.getClassAnnotation(cls, IGNORE_ANNOTATION) != null) {
            return false;
        }
        if (this.getClassAnnotation(cls, MODULE_ANNOTATION) != null || this.getClassAnnotation(cls, PACKAGE_ANNOTATION) != null) {
            return false;
        }
        return this.getClassAnnotation(cls, LOCAL_CONTAINER_ANNOTATION) == null;
    }

    private AnnotationInstance getClassAnnotation(ClassInfo cls, DotName annoName) {
        List<AnnotationInstance> annos = cls.annotations().get(annoName);
        if (annos != null) {
            for (AnnotationInstance anno : annos) {
                if (anno.target() != cls) continue;
                return anno;
            }
        }
        return null;
    }

    private static String classNameToDeclName(String clsName) {
        int lastDot = clsName.lastIndexOf(46);
        String packageName = lastDot != -1 ? clsName.substring(0, lastDot) : "";
        String simpleName = lastDot != -1 ? clsName.substring(lastDot + 1) : clsName;
        simpleName = simpleName.replace("$impl$", ".");
        simpleName = simpleName.replace('$', '.');
        return BytecodeUtils.unquotedDeclName(packageName, simpleName);
    }

    private static String unquotedDeclName(String pkg, String member) {
        if (pkg != null && !pkg.isEmpty()) {
            return BytecodeUtils.unquoteName(pkg, false) + "::" + BytecodeUtils.unquoteName(member, true);
        }
        return BytecodeUtils.unquoteName(member, true);
    }

    private static String unquoteName(String s, boolean stripTrailingUnderscore) {
        if (s != null) {
            String[] parts = JVMModuleUtil.unquoteJavaKeywords(s.split("\\."));
            String name = parts[parts.length - 1];
            if (stripTrailingUnderscore && !name.isEmpty() && Character.isLowerCase(name.charAt(0)) && name.charAt(name.length() - 1) == '_') {
                name = name.substring(0, name.length() - 1);
            }
            parts[parts.length - 1] = name;
            s = JVMModuleUtil.join(".", parts);
        }
        return s;
    }

    private static String getVersionFromFilename(String moduleName, String name) {
        if (!ModuleUtil.isDefaultModule(moduleName)) {
            String type = ArtifactContext.getSuffixFromFilename(name);
            return name.substring(moduleName.length() + 1, name.length() - type.length());
        }
        return "";
    }

    private static Set<ModuleDependencyInfo> getDependencies(AnnotationValue dependencies, String module, String version2, Overrides overrides) {
        AnnotationInstance[] deps = dependencies.asNestedArray();
        HashSet<ModuleDependencyInfo> result = new HashSet<ModuleDependencyInfo>(deps.length);
        for (AnnotationInstance dep : deps) {
            AnnotationValue depName = dep.value("name");
            AnnotationValue depVersion = dep.value("version");
            AnnotationValue export = dep.value("export");
            AnnotationValue optional = dep.value("optional");
            result.add(new ModuleDependencyInfo(depName.asString(), depVersion.asString(), optional != null && optional.asBoolean(), export != null && export.asBoolean()));
        }
        if (overrides != null) {
            return overrides.applyOverrides(module, version2, new ModuleInfo(null, result)).getDependencies();
        }
        return result;
    }

    @Override
    public boolean matchesModuleInfo(String moduleName, String moduleVersion, File moduleArchive, String query, Overrides overrides) {
        AnnotationValue dependencies;
        Index index = BytecodeUtils.readModuleIndex(moduleName, moduleArchive, false);
        AnnotationInstance moduleAnnotation = BytecodeUtils.getAnnotation(index, moduleName, MODULE_ANNOTATION);
        if (moduleAnnotation == null) {
            return false;
        }
        AnnotationValue version2 = moduleAnnotation.value("version");
        if (version2 == null) {
            return false;
        }
        AnnotationValue doc = moduleAnnotation.value("doc");
        if (doc != null && BytecodeUtils.matches(doc.asString(), query)) {
            return true;
        }
        AnnotationValue license = moduleAnnotation.value("license");
        if (license != null && BytecodeUtils.matches(license.asString(), query)) {
            return true;
        }
        AnnotationValue by = moduleAnnotation.value("by");
        if (by != null) {
            for (String author : by.asStringArray()) {
                if (!BytecodeUtils.matches(author, query)) continue;
                return true;
            }
        }
        if ((dependencies = moduleAnnotation.value("dependencies")) != null) {
            for (ModuleDependencyInfo dep : BytecodeUtils.getDependencies(dependencies, moduleName, version2.asString(), overrides)) {
                if (!BytecodeUtils.matches(dep.getModuleName(), query)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matches(String string, String query) {
        return string.toLowerCase().contains(query);
    }

    private static String asString(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        if (av == null) {
            throw new IllegalArgumentException("Missing required annotation attribute: " + name);
        }
        return av.asString();
    }

    private static boolean asBoolean(AnnotationInstance ai, String name) {
        AnnotationValue av = ai.value(name);
        return av != null && av.asBoolean();
    }

    private static AnnotationInstance getAnnotation(Index index, String moduleName, DotName annotationName) {
        ClassInfo moduleClass = BytecodeUtils.getModuleInfo(index, moduleName);
        if (moduleClass == null) {
            return null;
        }
        List<AnnotationInstance> annotations = moduleClass.annotations().get(annotationName);
        if (annotations == null || annotations.isEmpty()) {
            return null;
        }
        return annotations.get(0);
    }
}

