/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.DependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyResolvers;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.BytecodeUtils;
import com.redhat.ceylon.cmr.impl.JSUtils;
import com.redhat.ceylon.cmr.impl.MavenRepository;
import com.redhat.ceylon.cmr.impl.OSGiDependencyResolver;
import com.redhat.ceylon.cmr.impl.PropertiesDependencyResolver;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import java.util.logging.Logger;

public class Configuration {
    private static DependencyResolver mavenResolver;
    public static final String MAVEN_RESOLVER_CLASS = "com.redhat.ceylon.cmr.maven.MavenDependencyResolver";

    public static DependencyResolvers getResolvers(RepositoryManager manager) {
        DependencyResolvers resolvers = new DependencyResolvers();
        resolvers.addResolver(BytecodeUtils.INSTANCE);
        resolvers.addResolver(JSUtils.INSTANCE);
        resolvers.addResolver(PropertiesDependencyResolver.INSTANCE);
        resolvers.addResolver(XmlDependencyResolver.INSTANCE);
        resolvers.addResolver(OSGiDependencyResolver.INSTANCE);
        if (Configuration.usesMaven(manager)) {
            if (mavenResolver == null) {
                mavenResolver = Configuration.getResolver(MAVEN_RESOLVER_CLASS);
            }
            if (mavenResolver != null) {
                resolvers.addResolver(mavenResolver);
            }
        }
        return resolvers;
    }

    private static boolean usesMaven(RepositoryManager manager) {
        if (manager != null) {
            for (CmrRepository repo : manager.getRepositories()) {
                if (!(repo instanceof MavenRepository)) continue;
                return true;
            }
        }
        return false;
    }

    private static DependencyResolver getResolver(String className) {
        try {
            ClassLoader cl = Configuration.class.getClassLoader();
            DependencyResolver resolver = (DependencyResolver)cl.loadClass(className).newInstance();
            return resolver;
        }
        catch (Throwable t) {
            Logger.getLogger(Configuration.class.getName()).warning(String.format("Cannot add resolver %s - %s", className, t));
            return null;
        }
    }
}

