/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.RootNode;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.cmr.spi.StructureBuilder;
import com.redhat.ceylon.common.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FileContentStore
implements ContentStore,
StructureBuilder {
    private final File root;
    private final ConcurrentMap<Node, File> cache = new ConcurrentHashMap<Node, File>();

    public FileContentStore(File root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root!");
        }
        this.root = root;
    }

    public String toString() {
        return "FileContentStore: " + this.root;
    }

    @Override
    public String getDisplayString() {
        return this.root.getPath();
    }

    File getFile(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Null node");
        }
        return this.getFileInternal(node);
    }

    private File getFileInternal(Node node) {
        if (node == null) {
            return this.root;
        }
        File file = (File)this.cache.get(node);
        if (file == null) {
            File parent = this.getFileInternal(NodeUtils.firstParent(node));
            file = new File(parent, node.getLabel());
            this.cache.put(node, file);
        }
        return file;
    }

    void removeFile(Node node) {
        File file = (File)this.cache.remove(node);
        if (file == null) {
            file = this.getFile(node);
        }
        this.delete(file, node);
    }

    void clear() {
        this.cache.clear();
    }

    protected ContentHandle createContentHandle(Node owner, File file) {
        return file.isDirectory() ? new FolderContentHandle(owner, file) : new FileContentHandle(owner, file);
    }

    @Override
    public ContentHandle peekContent(Node node) {
        File file = this.getFile(node);
        return file.exists() ? this.createContentHandle(node, file) : null;
    }

    @Override
    public ContentHandle getContent(Node node) throws IOException {
        File file = this.getFile(node);
        if (!file.exists()) {
            throw new IOException("Content doesn't exist: " + file);
        }
        return this.createContentHandle(node, file);
    }

    @Override
    public ContentHandle putContent(Node node, InputStream stream, ContentOptions options) throws IOException {
        File file;
        if (stream == null) {
            throw new IllegalArgumentException("Null stream!");
        }
        if (options == null) {
            throw new IllegalArgumentException("Null options!");
        }
        if (!this.root.exists() && !FileUtil.mkdirs(this.root)) {
            throw new IOException("Cannot create Ceylon repository directory: " + this.root);
        }
        if (!this.root.isDirectory()) {
            throw new IOException("Ceylon repository is not a directory: " + this.root);
        }
        File parent = this.getFile(NodeUtils.firstParent(node));
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IOException("Cannot create dirs: " + parent);
        }
        if (parent.isDirectory()) {
            file = new File(parent, node.getLabel());
        } else {
            String path = parent.getPath();
            file = new File(path + node.getLabel());
        }
        boolean success = false;
        try {
            IOUtils.writeToFile(file, stream);
            success = true;
        }
        catch (SocketTimeoutException ex) {
            SocketTimeoutException newEx = new SocketTimeoutException("Timed out reading " + node.getDisplayString() + " from " + node.getStoreDisplayString());
            newEx.initCause(ex);
            throw newEx;
        }
        finally {
            if (!success) {
                file.delete();
            }
        }
        return new FileContentHandle(node, file);
    }

    @Override
    public OpenNode createRoot() {
        return new RootNode(this, this);
    }

    @Override
    public OpenNode create(Node parent, String child) {
        File pf = this.getFile(parent);
        File file = new File(pf, child);
        DefaultNode node = new DefaultNode(child);
        node.setHandle(new FolderContentHandle(node, file));
        return node;
    }

    @Override
    public OpenNode find(Node parent, String child) {
        File file;
        File pf = this.getFile(parent);
        if (pf.isDirectory()) {
            file = new File(pf, child);
        } else {
            String path = pf.getPath();
            file = new File(path + child);
        }
        if (file.exists()) {
            DefaultNode node = new DefaultNode(child);
            node.setHandle(this.createContentHandle(node, file));
            return node;
        }
        return null;
    }

    @Override
    public Iterable<? extends OpenNode> find(Node parent) {
        File pf = this.getFile(parent);
        if (pf.exists()) {
            ArrayList<DefaultNode> nodes = new ArrayList<DefaultNode>();
            for (File file : pf.listFiles()) {
                DefaultNode node = new DefaultNode(file.getName());
                node.setHandle(this.createContentHandle(node, file));
                nodes.add(node);
            }
            return nodes;
        }
        return Collections.emptyList();
    }

    protected void delete(File file, Node node) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        if (node == null) {
            throw new IllegalArgumentException("Null node");
        }
        if (this.root.equals(file)) {
            return;
        }
        File[] files = file.listFiles();
        if (!(files != null && files.length != 0 || file.exists() && !file.delete())) {
            this.cache.remove(node);
            this.delete(file.getParentFile(), NodeUtils.firstParent(node));
        }
    }

    @Override
    public boolean isOffline() {
        return true;
    }

    @Override
    public int getTimeout() {
        return 0;
    }

    @Override
    public boolean isHerd() {
        return false;
    }

    @Override
    public boolean canHandleFolders() {
        return true;
    }

    private class FolderContentHandle
    extends FileContentHandle {
        private FolderContentHandle(Node owner, File file) {
            super(owner, file);
        }

        @Override
        public boolean hasBinaries() {
            return false;
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clean() {
            try {
                IOUtils.deleteRecursively(this.file);
            }
            finally {
                super.clean();
            }
        }
    }

    private class FileContentHandle
    implements ContentHandle {
        protected Node owner;
        protected File file;

        private FileContentHandle(Node owner, File file) {
            this.owner = owner;
            this.file = file;
        }

        @Override
        public boolean hasBinaries() {
            return true;
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            return new SizedInputStream(this.getBinariesAsStream(), this.file.length());
        }

        @Override
        public File getContentAsFile() throws IOException {
            return this.file;
        }

        @Override
        public long getLastModified() throws IOException {
            return this.file.lastModified();
        }

        @Override
        public long getSize() throws IOException {
            return this.file.length();
        }

        @Override
        public void clean() {
            FileContentStore.this.delete(this.file, this.owner);
        }
    }
}

