/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.ModulesDependencyResolver;
import com.redhat.ceylon.cmr.impl.PropertiesDependencyResolver;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class FlatRepository
extends DefaultRepository {
    public FlatRepository(OpenNode root) {
        super(root);
    }

    @Override
    protected List<String> getDefaultParentPathInternal(ArtifactContext context) {
        return Collections.emptyList();
    }

    @Override
    protected ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        return new FlatArtifactResult(this, manager, node);
    }

    protected static class FlatArtifactResult
    extends DefaultRepository.DefaultArtifactResult {
        public FlatArtifactResult(CmrRepository repository, RepositoryManager manager, Node node) {
            super(repository, manager, node);
        }

        @Override
        protected ModuleInfo resolve() {
            ModuleInfo dependencies = super.resolve();
            if (dependencies == null) {
                Overrides overrides;
                for (CmrRepository repo : this.getManager().getRepositories()) {
                    if (!(repo instanceof FlatRepository)) continue;
                    dependencies = this.getExternalDescriptor(repo, XmlDependencyResolver.INSTANCE);
                    if (dependencies == null) {
                        dependencies = this.getExternalDescriptor(repo, PropertiesDependencyResolver.INSTANCE);
                    }
                    if (dependencies == null) continue;
                    break;
                }
                if (dependencies == null && (overrides = ((CmrRepository)this.repository()).getRoot().getService(Overrides.class)) != null) {
                    dependencies = new ModuleInfo(null, new HashSet<ModuleDependencyInfo>());
                    dependencies = overrides.applyOverrides(this.name(), this.version(), dependencies);
                }
            }
            return dependencies;
        }

        private ModuleInfo getExternalDescriptor(CmrRepository repo, ModulesDependencyResolver resolver) {
            String moduleXml = resolver.getQualifiedToplevelDescriptorName(this.name(), this.version());
            Overrides overrides = repo.getRoot().getService(Overrides.class);
            Node moduleXmlNode = repo.getRoot().getChild(moduleXml);
            if (moduleXmlNode != null) {
                File f = null;
                try {
                    f = moduleXmlNode.getContent(File.class);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (f != null) {
                    return resolver.resolveFromFile(f, this.name(), this.version(), overrides);
                }
            }
            return null;
        }
    }
}

