/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class IOUtils {
    private static final Logger log = Logger.getLogger(IOUtils.class.getName());
    private static final char[] Hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static IOException toIOException(Throwable t) {
        return t instanceof IOException ? (IOException)t : new IOException(t);
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                IOUtils.deleteRecursively(f);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, OutputStream out, boolean closeIn, boolean closeOut) throws IOException {
        try {
            IOUtils.copyStreamNoClose(in, out);
        }
        finally {
            if (closeIn) {
                IOUtils.safeClose(in);
            }
            if (closeOut) {
                IOUtils.safeClose(out);
            }
        }
    }

    private static void copyStreamNoClose(InputStream in, OutputStream out) throws IOException {
        int cnt;
        byte[] bytes = new byte[8192];
        while ((cnt = in.read(bytes)) != -1) {
            out.write(bytes, 0, cnt);
        }
        out.flush();
    }

    static InputStream toInputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    static <T extends Serializable> InputStream toObjectStream(T content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException("Null content");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(content);
        oos.flush();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T> T fromStream(Class<T> contentType, InputStream inputStream) throws IOException {
        if (contentType == null) {
            throw new IllegalArgumentException("Null content type!");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Null input stream!");
        }
        final ClassLoader cl = contentType.getClassLoader();
        try (ObjectInputStream ois = new ObjectInputStream(inputStream){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                return cl.loadClass(desc.getName());
            }
        };){
            Object result = ois.readObject();
            T t = contentType.cast(result);
            return t;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    static void writeToFile(File file, InputStream inputStream) throws IOException {
        IOUtils.copyStream(inputStream, new FileOutputStream(file), false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String sha1(InputStream is) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("Failed to get a SHA-1 message digest, your JRE does not follow the specs. No SHA-1 signature will be made");
            return null;
        }
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = is.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            log.warning("Failed to read input stream, no SHA-1 signature will be made");
            String string = null;
            return string;
        }
        finally {
            IOUtils.safeClose(is);
        }
        return IOUtils.toHexString(digest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readSha1(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String string = reader.readLine();
            return string;
        }
        finally {
            IOUtils.safeClose(reader);
        }
    }

    static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int c = 0;
        for (int b = 0; b < bytes.length; ++b) {
            int v = bytes[b] & 0xFF;
            chars[c++] = Hexadecimal[v / 16];
            chars[c++] = Hexadecimal[v % 16];
        }
        return new String(chars);
    }

    public static File zipFolder(File root) throws IOException {
        return IOUtils.zipFolders(new ZipRoot(root, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zipFolders(ZipRoot ... zipRoots) throws IOException {
        for (ZipRoot zipRoot : zipRoots) {
            if (zipRoot.root.isDirectory()) continue;
            throw new IOException("Zip root must be a folder");
        }
        File zipFile = File.createTempFile("ceylon-zipper-", ".zip");
        try {
            ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));
            try {
                for (ZipRoot zipRoot : zipRoots) {
                    for (File f : zipRoot.root.listFiles()) {
                        IOUtils.zipInternal(zipRoot.prefix, f, os);
                    }
                }
            }
            finally {
                os.flush();
                os.close();
            }
            return zipFile;
        }
        catch (IOException x) {
            zipFile.delete();
            throw x;
        }
    }

    private static void zipInternal(String path, File file, ZipOutputStream os) throws IOException {
        String filePath = path.isEmpty() ? file.getName() : path + "/" + file.getName();
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                IOUtils.zipInternal(filePath, f, os);
            }
        } else {
            ZipEntry entry = new ZipEntry(filePath);
            os.putNextEntry(entry);
            try (FileInputStream in = new FileInputStream(file);){
                IOUtils.copyStreamNoClose(in, os);
            }
            os.closeEntry();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractArchive(File zip, File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new UnzipException(UnzipFailure.DestinationNotDirectory, dir);
            }
        } else {
            IOUtils.mkdirs(dir);
        }
        try (ZipFile zf = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                try {
                    File out = new File(dir, entryName);
                    if (entry.isDirectory()) {
                        IOUtils.mkdirs(out);
                        continue;
                    }
                    IOUtils.mkdirs(out.getParentFile());
                    InputStream zipIn = zf.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(out));
                        Throwable throwable2 = null;
                        try {
                            IOUtils.copyStream(zipIn, fileOut, false, false);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fileOut == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fileOut.close();
                                }
                                catch (Throwable x2) {
                                    throwable2.addSuppressed(x2);
                                }
                                continue;
                            }
                            fileOut.close();
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (zipIn == null) continue;
                        if (throwable != null) {
                            try {
                                zipIn.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        zipIn.close();
                    }
                }
                catch (IOException e) {
                    throw new UnzipException(UnzipFailure.CopyError, entryName, e);
                    return;
                }
            }
        }
    }

    private static File mkdirs(File dir) {
        if (!dir.exists() && !FileUtil.mkdirs(dir)) {
            throw new UnzipException(UnzipFailure.CannotCreateDestination, dir);
        }
        return dir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream findDescriptor(ArtifactResult result, String descriptorPath) {
        try {
            File file = result.artifact();
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry zipEntry = zipFile.getEntry(descriptorPath);
                if (zipEntry != null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copyStream(zipFile.getInputStream(zipEntry), baos, true, true);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    return byteArrayInputStream;
                }
                InputStream inputStream = null;
                return inputStream;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File toTempFile(InputStream inputStream) throws IOException {
        try {
            File tempFile = File.createTempFile("ceylon-ioutils-", ".tmp");
            IOUtils.writeToFile(tempFile, inputStream);
            File file = tempFile;
            return file;
        }
        finally {
            IOUtils.safeClose(inputStream);
        }
    }

    public static class UnzipException
    extends RuntimeException {
        public final UnzipFailure failure;
        public final File dir;
        public final String entryName;

        public UnzipException(UnzipFailure failure, File dir) {
            this.failure = failure;
            this.dir = dir;
            this.entryName = null;
        }

        public UnzipException(UnzipFailure failure, String entryName, IOException e) {
            super(e);
            this.failure = failure;
            this.dir = null;
            this.entryName = entryName;
        }
    }

    public static enum UnzipFailure {
        DestinationNotDirectory,
        CannotCreateDestination,
        CopyError;

    }

    public static class ZipRoot {
        public final File root;
        public final String prefix;

        public ZipRoot(File root, String prefix) {
            this.root = root;
            this.prefix = prefix;
        }
    }
}

