/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.ContentFinderDelegate;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractRepository;
import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class JDKRepository
extends AbstractRepository {
    public static final String JDK_VERSION = "7";
    public static final String JDK_REPOSITORY_DISPLAY_STRING = "JDK modules repository";
    private static final String JAVA_ORIGIN = "Java Runtime";
    private static final SortedSet<String> FixedVersionSet = new TreeSet<String>(){
        {
            this.add(JDKRepository.JDK_VERSION);
        }
    };
    private static final SortedSet<String> EmptySet = new TreeSet<String>();
    private static final SortedSet<ModuleDependencyInfo> EmptyDependencySet = new TreeSet<ModuleDependencyInfo>();
    private static final SortedSet<String> FixedTypeSet = new TreeSet<String>(){
        {
            this.add(".jar");
        }
    };
    public static final Set<String> JDK_MODULES = new TreeSet<String>();

    public JDKRepository() {
        super(new JDKRoot());
    }

    @Override
    protected ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        return null;
    }

    @Override
    public Node findParent(ArtifactContext context) {
        return null;
    }

    @Override
    public OpenNode createParent(ArtifactContext context) {
        return null;
    }

    @Override
    public boolean isMaven() {
        return false;
    }

    static {
        for (String module : JDKUtils.getJDKModuleNames()) {
            JDK_MODULES.add(module);
        }
        for (String module : JDKUtils.getOracleJDKModuleNames()) {
            JDK_MODULES.add(module);
        }
    }

    public static class JDKRoot
    extends DefaultNode
    implements ContentFinderDelegate {
        public JDKRoot() {
            this.addService(ContentFinderDelegate.class, this);
        }

        @Override
        public String getDisplayString() {
            return JDKRepository.JDK_REPOSITORY_DISPLAY_STRING;
        }

        @Override
        public boolean isSearchable() {
            return true;
        }

        @Override
        public void completeModules(ModuleQuery query, ModuleSearchResult result, Overrides overrides) {
            if (!query.getType().includes(".jar")) {
                return;
            }
            if (query.getMemberName() != null && !query.isMemberSearchPackageOnly()) {
                return;
            }
            String name = query.getName();
            if (name == null) {
                name = "";
            }
            for (String module : JDK_MODULES) {
                ModuleVersionDetails mvd;
                if (!module.startsWith(name) || (mvd = this.getResult(module, query)) == null) continue;
                result.addResult(module, mvd);
            }
        }

        private String doc(String module) {
            return "JDK module " + module;
        }

        @Override
        public void completeVersions(ModuleVersionQuery query, ModuleVersionResult result, Overrides overrides) {
            if (!query.getType().includes(".jar")) {
                return;
            }
            if (query.getName() == null || !JDK_MODULES.contains(query.getName())) {
                return;
            }
            if (query.getVersion() != null && !query.getVersion().equals(JDKRepository.JDK_VERSION)) {
                return;
            }
            ModuleVersionDetails newVersion = result.addVersion(query.getName(), JDKRepository.JDK_VERSION);
            newVersion.setDoc(this.doc(query.getName()));
            newVersion.getArtifactTypes().add(new ModuleVersionArtifact(".jar", null, null));
            newVersion.setVersion(JDKRepository.JDK_VERSION);
            newVersion.setRemote(false);
            newVersion.setOrigin(JDKRepository.JAVA_ORIGIN);
        }

        private boolean rightQueryType(ModuleQuery.Type type) {
            if (type == ModuleQuery.Type.ALL) {
                return true;
            }
            for (String suffix : type.getSuffixes()) {
                if (!suffix.equals(".jar")) continue;
                return true;
            }
            return false;
        }

        @Override
        public void searchModules(ModuleQuery query, ModuleSearchResult result, Overrides overrides) {
            if (!query.getType().includes(".jar")) {
                return;
            }
            if (query.getMemberName() != null && !query.isMemberSearchPackageOnly()) {
                return;
            }
            String name = query.getName();
            if (name == null) {
                name = "";
            }
            name = name.toLowerCase();
            boolean stopSearching = false;
            int found = 0;
            for (String module : JDK_MODULES) {
                if (!module.contains(name)) continue;
                if (stopSearching) {
                    result.setHasMoreResults(true);
                    return;
                }
                ModuleVersionDetails mvd = this.getResult(module, query);
                if (mvd == null || query.getStart() != null && (long)found++ < query.getStart()) continue;
                result.addResult(module, mvd);
                if (query.getStart() == null || query.getCount() == null || (long)found < query.getStart() + query.getCount()) continue;
                stopSearching = true;
            }
        }

        private ModuleVersionDetails getResult(String module, ModuleQuery query) {
            ModuleVersionDetails mvd = new ModuleVersionDetails(module, JDKRepository.JDK_VERSION);
            mvd.setDoc(this.doc(module));
            mvd.getArtifactTypes().add(new ModuleVersionArtifact(".jar", null, null));
            mvd.setRemote(false);
            mvd.setOrigin(JDKRepository.JAVA_ORIGIN);
            if (query.getMemberName() != null) {
                Set<String> jdkMembers = JDKUtils.getJDKPackagesByModule(module);
                if (jdkMembers == null && (jdkMembers = JDKUtils.getOracleJDKPackagesByModule(module)) == null) {
                    return null;
                }
                Set<String> matchedMembers = AbstractRepository.matchNames(jdkMembers, query, true);
                if (matchedMembers.isEmpty()) {
                    return null;
                }
                mvd.setMembers(matchedMembers);
            }
            return mvd;
        }
    }
}

