/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.ModuleInfoReader;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import net.minidev.json.JSONValue;

public final class JSUtils
extends AbstractDependencyResolver
implements ModuleInfoReader {
    public static JSUtils INSTANCE = new JSUtils();

    private JSUtils() {
    }

    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (context.ignoreInner()) {
            return null;
        }
        ArtifactResult result = context.result();
        File mod = result.artifact();
        if (mod != null && (mod.getName().toLowerCase().endsWith("-model.js") || mod.getName().toLowerCase().endsWith(".js"))) {
            return JSUtils.readModuleInformation(result.name(), mod, overrides);
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .js files");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .js files");
    }

    @Override
    public Node descriptor(Node artifact) {
        return null;
    }

    public static ModuleInfo readModuleInformation(String moduleName, File jarFile, Overrides overrides) {
        Map<String, Object> model = JSUtils.loadJsonModel(jarFile);
        String version2 = JSUtils.asString(JSUtils.metaModelProperty(model, "$mod-version"));
        return JSUtils.getModuleInfo(model, moduleName, version2, overrides);
    }

    @Override
    public int[] getBinaryVersions(String moduleName, String version2, File moduleArchive) {
        int major = 0;
        int minor = 0;
        ModuleVersionDetails mvd = this.readModuleInfo(moduleName, version2, moduleArchive, false, null);
        ModuleVersionArtifact mva = (ModuleVersionArtifact)mvd.getArtifactTypes().first();
        if (mva.getMajorBinaryVersion() != null) {
            major = mva.getMajorBinaryVersion();
        }
        if (mva.getMinorBinaryVersion() != null) {
            minor = mva.getMinorBinaryVersion();
        }
        return new int[]{major, minor};
    }

    private static ScriptEngine getEngine(File moduleArchive) {
        try {
            ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
            engine.eval("var exports={}");
            engine.eval("var module={}");
            engine.eval("function require() { return { '$addmod$' : function() {} } }");
            engine.eval(new FileReader(moduleArchive));
            return engine;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse module JS file", ex);
        }
    }

    private static ModuleInfo getModuleInfo(Map<String, Object> model, String module, String version2, Overrides overrides) {
        try {
            return JSUtils.getModuleInfo(JSUtils.metaModelProperty(model, "$mod-deps"), module, version2, overrides);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse module JS file", ex);
        }
    }

    @Override
    public ModuleVersionDetails readModuleInfo(String moduleName, String moduleVersion, File moduleArchive, boolean includeMembers, Overrides overrides) {
        Map<String, Object> model = JSUtils.loadJsonModel(moduleArchive);
        String name = JSUtils.asString(JSUtils.metaModelProperty(model, "$mod-name"));
        if (!moduleName.equals(name)) {
            throw new RuntimeException("Incorrect module");
        }
        String version2 = JSUtils.asString(JSUtils.metaModelProperty(model, "$mod-version"));
        Set<ModuleDependencyInfo> dependencies = JSUtils.getModuleInfo(model, moduleName, version2, overrides).getDependencies();
        String type = ArtifactContext.getSuffixFromFilename(moduleArchive.getName());
        Integer major = null;
        Integer minor = null;
        String bin = JSUtils.asString(JSUtils.metaModelProperty(model, "$mod-bin"));
        if (bin != null) {
            int p = bin.indexOf(46);
            if (p >= 0) {
                major = Integer.parseInt(bin.substring(0, p));
                minor = Integer.parseInt(bin.substring(p + 1));
            } else {
                major = Integer.parseInt(bin);
            }
        }
        ModuleVersionDetails mvd = new ModuleVersionDetails(moduleName, version2);
        mvd.getArtifactTypes().add(new ModuleVersionArtifact(type, major, minor));
        mvd.getDependencies().addAll(dependencies);
        Map annotations = (Map)JSUtils.metaModelProperty(model, "$mod-anns");
        if (annotations != null) {
            mvd.setDoc(JSUtils.asString(annotations.get("doc")));
            mvd.setLicense(JSUtils.asString(annotations.get("license")));
            Iterable by = (Iterable)annotations.get("by");
            if (by != null) {
                for (String author : by) {
                    mvd.getAuthors().add(author);
                }
            }
        }
        if (includeMembers) {
            mvd.setMembers(this.getMembers(moduleName, moduleArchive));
        }
        return mvd;
    }

    private Set<String> getMembers(String moduleName, File moduleArchive) {
        throw new RuntimeException("Not implemented yet");
    }

    private static Object metaModelProperty(Map<String, Object> model, String propName) {
        return model.get(propName);
    }

    private static String asString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterable) {
            Iterator iter = ((Iterable)obj).iterator();
            return iter.hasNext() ? (String)iter.next() : null;
        }
        return obj.toString();
    }

    private static ModuleInfo getModuleInfo(Object obj, String moduleName, String version2, Overrides overrides) {
        if (obj == null) {
            return new ModuleInfo(null, Collections.emptySet());
        }
        if (!(obj instanceof Iterable)) {
            throw new RuntimeException("Expected something Iterable");
        }
        Iterable array = (Iterable)obj;
        HashSet<ModuleDependencyInfo> deps = new HashSet<ModuleDependencyInfo>();
        for (Object o : array) {
            String module;
            boolean optional = false;
            boolean exported = false;
            if (o instanceof String) {
                module = JSUtils.asString(o);
            } else {
                Map m = (Map)o;
                module = m.get("path").toString();
                optional = m.containsKey("opt");
                exported = m.containsKey("exp");
            }
            String name = ModuleUtil.moduleName(module);
            deps.add(new ModuleDependencyInfo(name, ModuleUtil.moduleVersion(module), optional, exported));
        }
        ModuleInfo result = new ModuleInfo(null, deps);
        if (overrides != null) {
            result = overrides.applyOverrides(moduleName, version2, result);
        }
        return result;
    }

    @Override
    public boolean matchesModuleInfo(String moduleName, String moduleVersion, File moduleArchive, String query, Overrides overrides) {
        ModuleVersionDetails mvd = this.readModuleInfo(moduleName, moduleVersion, moduleArchive, false, overrides);
        if (mvd.getDoc() != null && JSUtils.matches(mvd.getDoc(), query)) {
            return true;
        }
        if (mvd.getLicense() != null && JSUtils.matches(mvd.getLicense(), query)) {
            return true;
        }
        for (String author : mvd.getAuthors()) {
            if (!JSUtils.matches(author, query)) continue;
            return true;
        }
        for (ModuleDependencyInfo dep : mvd.getDependencies()) {
            if (!JSUtils.matches(dep.getModuleName(), query)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(String string, String query) {
        return string.toLowerCase().contains(query);
    }

    private static Map<String, Object> loadJsonModel(File jsFile) {
        try {
            Map<String, Object> model;
            String name = jsFile.getName().toLowerCase();
            if (!name.endsWith("-model.js") && name.endsWith(".js")) {
                name = jsFile.getName();
                name = name.substring(0, name.length() - 3) + "-model.js";
                File modelFile = new File(jsFile.getParentFile(), name);
                if (modelFile.isFile()) {
                    jsFile = modelFile;
                }
            }
            if ((model = JSUtils.readJsonModel(jsFile)) == null) {
                throw new RuntimeException("Unable to read meta model from file " + jsFile);
            }
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> readJsonModel(File jsFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(jsFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                Map rv;
                if (!line.startsWith("ex$.$CCMM$=") && !line.startsWith("var $CCMM$=") && !line.startsWith("var $$METAMODEL$$=") && !line.startsWith("var $$metamodel$$=") || !line.endsWith("};")) continue;
                line = line.substring(line.indexOf("{"), line.length() - 1);
                Map map = rv = (Map)JSONValue.parse(line);
                return map;
            }
            Map<String, Object> map = null;
            return map;
        }
    }
}

