/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.ModuleInfoReader;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.PropertiesDependencyResolver;
import com.redhat.ceylon.cmr.impl.XmlDependencyResolver;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class JarUtils
extends AbstractDependencyResolver
implements ModuleInfoReader {
    public static JarUtils INSTANCE = new JarUtils();

    private JarUtils() {
    }

    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (context.ignoreExternal()) {
            return null;
        }
        ArtifactResult result = context.result();
        File mod = result.artifact();
        if (mod != null && mod.getName().toLowerCase().endsWith(".jar")) {
            return JarUtils.getDependencies(result.artifact(), result.name(), result.version(), overrides);
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        return JarUtils.getDependenciesFromFile(file, name, version2, overrides);
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Cannot resolve from stream");
    }

    @Override
    public Node descriptor(Node artifact) {
        Node parent = NodeUtils.firstParent(artifact);
        Node descriptor = parent.getChild("module.xml");
        if (descriptor == null) {
            descriptor = parent.getChild("module.properties");
        }
        return descriptor;
    }

    @Override
    public ModuleVersionDetails readModuleInfo(String moduleName, String version2, File moduleArchive, boolean includeMembers, Overrides overrides) {
        ModuleVersionDetails mvd = new ModuleVersionDetails(moduleName, version2);
        mvd.getArtifactTypes().add(new ModuleVersionArtifact(".jar", null, null));
        ModuleInfo info = JarUtils.getDependencies(moduleArchive, moduleName, version2, overrides);
        if (info != null) {
            mvd.getDependencies().addAll(info.getDependencies());
        }
        if (includeMembers) {
            mvd.setMembers(this.getMembers(moduleArchive));
        }
        return mvd;
    }

    private Set<String> getMembers(File moduleArchive) {
        try {
            return JarUtils.gatherCeylonNamesFromJar(moduleArchive);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve members for module " + moduleArchive.getPath(), e);
        }
    }

    private static ModuleInfo getDependencies(File moduleArchive, String name, String version2, Overrides overrides) {
        File xml = new File(moduleArchive.getParentFile(), "module.xml");
        ModuleInfo result = JarUtils.getDependenciesFromFile(xml, name, version2, overrides);
        if (result != null) {
            return result;
        }
        File props = new File(moduleArchive.getParentFile(), "module.properties");
        return JarUtils.getDependenciesFromFile(props, name, version2, overrides);
    }

    private static ModuleInfo getDependenciesFromFile(File descriptorFile, String name, String version2, Overrides overrides) {
        if (!descriptorFile.isFile()) {
            return null;
        }
        if (descriptorFile.getName().equalsIgnoreCase("module.xml")) {
            return XmlDependencyResolver.INSTANCE.resolveFromFile(descriptorFile, name, version2, overrides);
        }
        if (descriptorFile.getName().equalsIgnoreCase("module.properties")) {
            return PropertiesDependencyResolver.INSTANCE.resolveFromFile(descriptorFile, name, version2, overrides);
        }
        return null;
    }

    @Override
    public boolean matchesModuleInfo(String moduleName, String version2, File moduleArchive, String query, Overrides overrides) {
        ModuleInfo deps = JarUtils.getDependencies(moduleArchive, moduleName, version2, overrides);
        if (deps != null) {
            for (ModuleDependencyInfo dep : deps.getDependencies()) {
                if (!JarUtils.matches(dep.getModuleName(), query)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matches(String string, String query) {
        return string.toLowerCase().contains(query);
    }

    @Override
    public int[] getBinaryVersions(String moduleName, String version2, File moduleArchive) {
        return null;
    }

    private static Set<String> gatherCeylonNamesFromJar(File jar) throws IOException {
        HashSet<String> ceylonNames = new HashSet<String>();
        Set<String> classNames = JarUtils.gatherClassnamesFromJar(jar);
        for (String clsName : classNames) {
            int p = clsName.lastIndexOf(46);
            if (p >= 0) {
                String pkg = clsName.substring(0, p);
                String member = clsName.substring(p + 1).replace('$', '.');
                clsName = pkg + "::" + member;
            }
            ceylonNames.add(clsName);
        }
        return ceylonNames;
    }

    public static Set<String> gatherClassnamesFromJar(File jar) throws IOException {
        HashSet<String> names = new HashSet<String>();
        try (JarFile zf = new JarFile(jar);){
            Enumeration<JarEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().endsWith("module-info.class")) continue;
                String name = entry.getName();
                String className = name.substring(0, name.length() - 6).replace('/', '.');
                names.add(className);
            }
        }
        return names;
    }
}

