/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.ImportType;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.util.List;

public class LazyArtifactResult
extends AbstractArtifactResult {
    private ArtifactResult delegate;
    private final ImportType importType;
    private RepositoryManager manager;

    public LazyArtifactResult(RepositoryManager manager, String name, String version2, ImportType importType) {
        super(null, name, version2);
        this.manager = manager;
        this.importType = importType;
    }

    private synchronized ArtifactResult getDelegate() {
        if (this.delegate == null) {
            ArtifactContext context = new ArtifactContext(this.name(), this.version());
            context.setThrowErrorIfMissing(this.importType() != ImportType.OPTIONAL);
            this.delegate = this.manager.getArtifactResult(context);
        }
        return this.delegate;
    }

    @Override
    public Repository repository() {
        return this.getDelegate().repository();
    }

    @Override
    public ImportType importType() {
        return this.importType;
    }

    @Override
    public ArtifactResultType type() {
        return this.getDelegate().type();
    }

    @Override
    protected File artifactInternal() throws RepositoryException {
        return this.getDelegate().artifact();
    }

    @Override
    public List<ArtifactResult> dependencies() throws RepositoryException {
        return this.getDelegate().dependencies();
    }

    @Override
    public String repositoryDisplayString() {
        return this.getDelegate().repositoryDisplayString();
    }

    @Override
    public PathFilter filter() {
        return this.getDelegate().filter();
    }
}

