/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractCeylonArtifactResult;
import com.redhat.ceylon.cmr.impl.AbstractRepository;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MavenRepository
extends AbstractRepository {
    protected MavenRepository(OpenNode root) {
        super(root);
    }

    @Override
    public String[] getArtifactNames(ArtifactContext context) {
        String name = context.getName();
        int p = name.contains(":") ? name.lastIndexOf(":") : name.lastIndexOf(".");
        return MavenRepository.getArtifactNames(p >= 0 ? name.substring(p + 1) : name, context.getVersion(), context.getSuffixes());
    }

    @Override
    protected ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        ArtifactContext context = ArtifactContext.fromNode(node);
        return new MavenArtifactResult(this, manager, context.getName(), context.getVersion(), node);
    }

    @Override
    public String getDisplayString() {
        return "[Maven] " + super.getDisplayString();
    }

    @Override
    public boolean isMaven() {
        return true;
    }

    @Override
    protected List<String> getDefaultParentPathInternal(ArtifactContext context) {
        return MavenRepository.getParentPath(context);
    }

    public static List<String> getParentPath(ArtifactContext context) {
        String name = context.getName();
        int p = name.contains(":") ? name.lastIndexOf(":") : name.lastIndexOf(".");
        ArrayList<String> tokens = new ArrayList<String>();
        if (p == -1) {
            tokens.addAll(Arrays.asList(name.split("\\.")));
        } else {
            tokens.addAll(Arrays.asList(name.substring(0, p).split("\\.")));
            tokens.add(name.substring(p + 1));
        }
        String version2 = context.getVersion();
        if (!"default".equals(name) && version2 != null) {
            tokens.add(version2);
        }
        return tokens;
    }

    private static class MavenArtifactResult
    extends AbstractCeylonArtifactResult {
        private Node node;

        private MavenArtifactResult(CmrRepository repository, RepositoryManager manager, String name, String version2, Node node) {
            super(repository, manager, name, version2);
            this.node = node;
        }

        @Override
        public ArtifactResultType type() {
            return ArtifactResultType.MAVEN;
        }

        @Override
        protected File artifactInternal() throws RepositoryException {
            try {
                return this.node.getContent(File.class);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        @Override
        public List<ArtifactResult> dependencies() throws RepositoryException {
            return Collections.emptyList();
        }

        @Override
        public String repositoryDisplayString() {
            return NodeUtils.getRepositoryDisplayString(this.node);
        }
    }
}

