/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractRepositoryManager;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.ModuleQuery;
import com.redhat.ceylon.cmr.api.ModuleSearchResult;
import com.redhat.ceylon.cmr.api.ModuleVersionQuery;
import com.redhat.ceylon.cmr.api.ModuleVersionResult;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.RootRepositoryManager;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class OutputRepositoryManager
extends AbstractRepositoryManager {
    private final RepositoryManager output;
    private final RepositoryManager manager;

    private static File getOutputDir() {
        return new File("output");
    }

    public OutputRepositoryManager(RepositoryManager manager, Logger log) {
        this(OutputRepositoryManager.getOutputDir(), manager, log);
    }

    public OutputRepositoryManager(File outputDir, RepositoryManager manager, Logger log) {
        this(new RootRepositoryManager(outputDir, log, null), manager, log);
    }

    public OutputRepositoryManager(RepositoryManager output, RepositoryManager manager, Logger log) {
        super(log, null);
        if (output == null) {
            throw new IllegalArgumentException("Output is null!");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Manager is null!");
        }
        this.output = output;
        this.manager = manager;
    }

    @Override
    public List<CmrRepository> getRepositories() {
        ArrayList<CmrRepository> repos = new ArrayList<CmrRepository>();
        repos.addAll(this.output.getRepositories());
        repos.addAll(this.manager.getRepositories());
        return repos;
    }

    @Override
    public List<String> getRepositoriesDisplayString() {
        ArrayList<String> displayStrings = new ArrayList<String>();
        displayStrings.addAll(this.output.getRepositoriesDisplayString());
        displayStrings.addAll(this.manager.getRepositoriesDisplayString());
        return displayStrings;
    }

    @Override
    public ArtifactResult getArtifactResult(ArtifactContext context) throws RepositoryException {
        ArtifactResult result = this.output.getArtifactResult(context);
        if (result != null) {
            return result;
        }
        return this.manager.getArtifactResult(context);
    }

    @Override
    public void putArtifact(ArtifactContext context, InputStream content) throws RepositoryException {
        this.output.putArtifact(context, content);
    }

    @Override
    public void putArtifact(ArtifactContext context, File content) throws RepositoryException {
        this.output.putArtifact(context, content);
    }

    @Override
    public void removeArtifact(ArtifactContext context) throws RepositoryException {
        this.output.removeArtifact(context);
    }

    public String toString() {
        return "OutputRepositoryManager: " + this.output;
    }

    @Override
    public ModuleSearchResult completeModules(ModuleQuery query) {
        return new ModuleSearchResult();
    }

    @Override
    public ModuleVersionResult completeVersions(ModuleVersionQuery query) {
        return new ModuleVersionResult(query.getName());
    }

    @Override
    public ModuleSearchResult searchModules(ModuleQuery query) {
        return new ModuleSearchResult();
    }

    @Override
    public void refresh(boolean recurse) {
        this.output.refresh(recurse);
        this.manager.refresh(recurse);
    }

    @Override
    public ArtifactContext getArtifactOverride(ArtifactContext context) throws RepositoryException {
        return context;
    }
}

