/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.ModulesDependencyResolver;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;

public final class PropertiesDependencyResolver
extends ModulesDependencyResolver {
    public static final PropertiesDependencyResolver INSTANCE = new PropertiesDependencyResolver();

    private PropertiesDependencyResolver() {
        super("module.properties");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String moduleName, String moduleVersion, Overrides overrides) {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            LinkedHashSet<ModuleDependencyInfo> infos = new LinkedHashSet<ModuleDependencyInfo>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String name = entry.getKey().toString();
                String version2 = entry.getValue().toString();
                boolean optional = false;
                boolean shared = false;
                if (name.startsWith("+")) {
                    name = name.substring(1);
                    shared = true;
                }
                if (name.endsWith("?")) {
                    name = name.substring(0, name.length() - 1);
                    optional = true;
                }
                infos.add(new ModuleDependencyInfo(name, version2, optional, shared));
            }
            ModuleInfo ret = new ModuleInfo(null, infos);
            if (overrides != null) {
                ret = overrides.applyOverrides(moduleName, moduleVersion, ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

