/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.FlatRepository;
import com.redhat.ceylon.cmr.impl.JDKRepository;
import com.redhat.ceylon.cmr.impl.RemoteContentStore;
import com.redhat.ceylon.cmr.impl.SecurityActions;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URI;

class RepositoryBuilderImpl
implements RepositoryBuilder {
    private Logger log;
    private boolean offline;
    private int timeout;
    private Proxy proxy;

    RepositoryBuilderImpl(Logger log, boolean offline, int timeout, Proxy proxy) {
        this.log = log;
        this.offline = offline;
        this.timeout = timeout;
        this.proxy = proxy;
    }

    @Override
    public CmrRepository buildRepository(String token) throws Exception {
        ContentStore structureBuilder;
        if (token == null) {
            throw new IllegalArgumentException("Null repository");
        }
        String key = token.startsWith("${") ? token.substring(2, token.length() - 1) : token;
        String temp = SecurityActions.getProperty(key);
        if (temp != null) {
            token = temp;
        }
        if (token.startsWith("http:") || token.startsWith("https:")) {
            structureBuilder = new RemoteContentStore(token, this.log, this.offline, this.timeout, this.proxy);
        } else {
            File file;
            if (token.equals("jdk") || token.equals("jdk:")) {
                return new JDKRepository();
            }
            if (token.equals("aether") || token.equals("aether:") || token.equals("mvn") || token.equals("mvn:")) {
                Class<?> aetherRepositoryClass = Class.forName("com.redhat.ceylon.cmr.maven.AetherRepository");
                Method createRepository = aetherRepositoryClass.getMethod("createRepository", Logger.class, String.class, Boolean.TYPE, Integer.TYPE);
                return (CmrRepository)createRepository.invoke(null, this.log, null, this.offline, this.timeout);
            }
            if (token.startsWith("aether:")) {
                return this.createMavenRepository(token, "aether:");
            }
            if (token.startsWith("mvn:")) {
                return this.createMavenRepository(token, "mvn:");
            }
            if (token.startsWith("flat:")) {
                File file2 = new File(token.substring(5));
                if (!file2.exists()) {
                    throw new IllegalArgumentException("Directory does not exist: " + token);
                }
                if (!file2.isDirectory()) {
                    throw new IllegalArgumentException("Repository exists but is not a directory: " + token);
                }
                FileContentStore structureBuilder2 = new FileContentStore(file2);
                return new FlatRepository(structureBuilder2.createRoot());
            }
            File file3 = file = token.startsWith("file:") ? new File(new URI(token)) : new File(token);
            if (!file.exists()) {
                throw new IllegalArgumentException("Directory does not exist: " + token);
            }
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("Repository exists but is not a directory: " + token);
            }
            structureBuilder = new FileContentStore(file);
        }
        return new DefaultRepository(structureBuilder.createRoot());
    }

    protected CmrRepository createMavenRepository(String token, String prefix) throws Exception {
        String config = token.substring(prefix.length());
        int p = config.indexOf("|");
        String settingsXml = null;
        settingsXml = p < 0 ? config : config.substring(0, p);
        Class<?> aetherRepositoryClass = Class.forName("com.redhat.ceylon.cmr.maven.AetherRepository");
        Method createRepository = aetherRepositoryClass.getMethod("createRepository", Logger.class, String.class, Boolean.TYPE, Integer.TYPE);
        return (CmrRepository)createRepository.invoke(null, this.log, settingsXml, this.offline, this.timeout);
    }
}

