/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.RepositoryManagerBuilder;
import com.redhat.ceylon.cmr.impl.CachingContentTransformer;
import com.redhat.ceylon.cmr.impl.DefaultMergeStrategy;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.RepositoryBuilderImpl;
import com.redhat.ceylon.cmr.impl.RootRepositoryManager;
import com.redhat.ceylon.cmr.spi.ContentTransformer;
import com.redhat.ceylon.cmr.spi.MergeStrategy;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.net.Proxy;
import java.util.List;

public class RepositoryManagerBuilderImpl
extends RepositoryManagerBuilder {
    private final RootRepositoryManager repository;
    private final Logger log;
    private final boolean offline;
    private final int timeout;
    private final Proxy proxy;

    public RepositoryManagerBuilderImpl(Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides) {
        this(log, offline, timeout, proxy, overrides, true);
    }

    public RepositoryManagerBuilderImpl(Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides, boolean upgradeDist) {
        this.repository = new RootRepositoryManager(log, overrides, upgradeDist);
        this.log = log;
        this.offline = offline;
        this.timeout = timeout;
        this.proxy = proxy;
        this.init();
    }

    public RepositoryManagerBuilderImpl(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides) {
        this(mainRepository, log, offline, timeout, proxy, overrides, true);
    }

    public RepositoryManagerBuilderImpl(File mainRepository, Logger log, boolean offline, int timeout, Proxy proxy, Overrides overrides, boolean upgradeDist) {
        this.repository = new RootRepositoryManager(mainRepository, log, overrides, upgradeDist);
        this.log = log;
        this.offline = offline;
        this.timeout = timeout;
        this.proxy = proxy;
        this.init();
    }

    protected void init() {
        if (this.getCache() != null) {
            this.getCache().addService(MergeStrategy.class, new DefaultMergeStrategy());
        }
    }

    private OpenNode getCache() {
        return this.repository.getCache();
    }

    @Override
    public RepositoryBuilder repositoryBuilder() {
        return new RepositoryBuilderImpl(this.log, this.offline, this.timeout, this.proxy);
    }

    @Override
    public RepositoryManagerBuilderImpl mergeStrategy(MergeStrategy strategy) {
        if (this.getCache() != null) {
            this.getCache().addService(MergeStrategy.class, strategy);
        }
        return this;
    }

    @Override
    public RepositoryManagerBuilderImpl contentTransformer(ContentTransformer transformer) {
        if (this.getCache() != null) {
            this.getCache().addService(ContentTransformer.class, transformer);
        }
        return this;
    }

    @Override
    public RepositoryManagerBuilderImpl cacheContent() {
        if (this.getCache() != null) {
            this.getCache().addService(ContentTransformer.class, new CachingContentTransformer());
        }
        return this;
    }

    protected RepositoryManagerBuilderImpl addExternalRoot(OpenNode externalRoot) {
        this.repository.addRepository(new DefaultRepository(externalRoot));
        return this;
    }

    @Override
    public RepositoryManagerBuilderImpl addRepository(CmrRepository externalRoot) {
        this.repository.addRepository(externalRoot);
        return this;
    }

    @Override
    public List<String> getRepositoriesDisplayString() {
        return this.repository.getRepositoriesDisplayString();
    }

    @Override
    public RepositoryManager buildRepository() {
        return this.repository;
    }

    @Override
    public boolean hasMavenRepository() {
        return this.repository.hasMavenRepository();
    }
}

