/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactCallback;
import com.redhat.ceylon.cmr.api.ArtifactCallbackStream;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.AbstractNodeRepositoryManager;
import com.redhat.ceylon.cmr.impl.Configuration;
import com.redhat.ceylon.cmr.impl.DefaultRepository;
import com.redhat.ceylon.cmr.impl.FileArtifactResult;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.RootNode;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.ContentStore;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.Repositories;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class RootRepositoryManager
extends AbstractNodeRepositoryManager {
    private final FileContentStore fileContentStore;

    private static File getRootDir() {
        Repositories.Repository rootRepo = Repositories.get().getCacheRepository();
        return new File(rootRepo.getUrl());
    }

    public RootRepositoryManager(Logger log, Overrides overrides) {
        this(RootRepositoryManager.getRootDir(), log, overrides);
    }

    public RootRepositoryManager(Logger log, Overrides overrides, boolean upgradeDist) {
        this(RootRepositoryManager.getRootDir(), log, overrides, upgradeDist);
    }

    public RootRepositoryManager(File rootDir, Logger log, Overrides overrides) {
        this(rootDir, log, overrides, true);
    }

    public RootRepositoryManager(File rootDir, Logger log, Overrides overrides, boolean upgradeDist) {
        super(log, overrides, upgradeDist);
        if (rootDir != null) {
            this.fileContentStore = new FileContentStore(rootDir);
            DefaultRepository aaca = new DefaultRepository(new RootNode(this.fileContentStore, this.fileContentStore));
            this.setCache(aaca);
        } else {
            this.fileContentStore = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArtifactResult getArtifactResult(ArtifactContext context, Node node) throws RepositoryException {
        if (node.isRemote()) {
            boolean forceOp = context.isForceOperation();
            try {
                FileArtifactResult fileArtifactResult;
                context.setForceOperation(true);
                this.log.debug("Looking up artifact " + context + " from " + node + " to cache it");
                SizedInputStream sizedInputStream = node.getSizedInputStream();
                if (sizedInputStream == null) {
                    throw new RepositoryException("Node " + node + " for repository " + this + " returned a null stream");
                }
                try {
                    this.log.debug(" -> Found it, now caching it");
                    File file = this.putContent(context, node, sizedInputStream.inputStream, sizedInputStream.size);
                    this.log.debug("    Caching done: " + file);
                    String repositoryDisplayString = NodeUtils.getRepositoryDisplayString(node);
                    File originalRepoFile = new File(file.getParentFile(), file.getName().concat(".origin"));
                    FileWriter writer = new FileWriter(originalRepoFile, false);
                    try {
                        writer.write(repositoryDisplayString);
                        writer.close();
                    }
                    catch (IOException e) {
                        this.log.error(e.toString());
                    }
                    fileArtifactResult = new FileArtifactResult(NodeUtils.getRepository(node), this, context.getName(), context.getVersion(), file, repositoryDisplayString);
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.safeClose(sizedInputStream.inputStream);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RepositoryException(e);
                    }
                }
                IOUtils.safeClose(sizedInputStream.inputStream);
                return fileArtifactResult;
            }
            finally {
                context.setForceOperation(forceOp);
            }
        }
        return this.toArtifactResult(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ArtifactResult artifactNotFound(ArtifactContext context) throws RepositoryException {
        block21: {
            Node parent;
            boolean hasRemote = false;
            StringBuilder reps = new StringBuilder();
            for (CmrRepository rep : this.getRepositories()) {
                if (!rep.getRoot().isRemote() || this.isOffline(rep)) continue;
                hasRemote = true;
                reps.append(rep.getDisplayString());
                reps.append('\n');
            }
            if (hasRemote && this.cache != null && (parent = this.cache.findParent(context)) != null) {
                context.toNode(parent);
                try {
                    File parentDir = this.fileContentStore.getFile(parent);
                    String[] names = this.cache.getArtifactNames(context);
                    File missingFile = new File(parentDir, names[0].concat(".missing"));
                    if (missingFile.exists()) break block21;
                    if (context.getSearchRepository() == this.cache) {
                        ArtifactContext unpreferred = new ArtifactContext(context.getName(), context.getVersion(), context.getSuffixes());
                        unpreferred.copySettingsFrom(context);
                        ArtifactResult artifactResult = this.getArtifactResult(unpreferred);
                        return artifactResult;
                    }
                    FileUtil.mkdirs(parentDir);
                    try (FileWriter writer = new FileWriter(missingFile, false);){
                        writer.write(reps.toString());
                    }
                    catch (IOException e) {
                        this.log.error(e.toString());
                    }
                }
                finally {
                    ArtifactContext.removeNode(parent);
                }
            }
        }
        return super.artifactNotFound(context);
    }

    private boolean isOffline(CmrRepository repo) {
        ContentStore cs = repo.getRoot().getService(ContentStore.class);
        return cs != null && cs.isOffline();
    }

    private File putContent(ArtifactContext context, Node node, InputStream stream, long length) throws IOException {
        Node descriptor;
        Object shaStream;
        File file;
        this.log.debug("Creating local copy of external node: " + node + " at repo: " + (this.fileContentStore != null ? this.fileContentStore.getDisplayString() : null));
        if (this.fileContentStore == null) {
            throw new IOException("No location to place node at: fileContentStore is null");
        }
        ArtifactCallback callback = context.getCallback();
        if (callback == null) {
            callback = ArtifactCallbackStream.getCallback();
        }
        try {
            if (callback != null) {
                callback.start(NodeUtils.getFullPath(node), length != -1L ? length : node.getSize(), node.getStoreDisplayString());
                stream = new ArtifactCallbackStream(callback, stream);
            }
            this.fileContentStore.putContent(node, stream, context);
            file = this.fileContentStore.getFile(node);
            if (callback != null) {
                callback.done(file);
            }
        }
        catch (Throwable t) {
            if (callback != null) {
                callback.error(this.fileContentStore.getFile(node), t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw IOUtils.toIOException(t);
        }
        if (!context.isIgnoreSHA() && node instanceof OpenNode) {
            OpenNode on = (OpenNode)node;
            String sha1 = IOUtils.sha1(new FileInputStream(file));
            if (sha1 != null) {
                String existingSha1;
                shaStream = new ByteArrayInputStream(sha1.getBytes("ASCII"));
                Node parent = NodeUtils.firstParent(node);
                if (parent == null) {
                    throw new IllegalArgumentException("Parent should not be null: " + node);
                }
                Node sha = parent.getChild(on.getLabel() + ".sha1");
                if (sha == null) {
                    on.addContent(".sha1", (InputStream)shaStream, (ContentOptions)context);
                    ((ByteArrayInputStream)shaStream).reset();
                } else if (sha.hasBinaries() && !sha1.equals(existingSha1 = IOUtils.readSha1(sha.getInputStream()))) {
                    try {
                        this.fileContentStore.delete(file, node);
                    }
                    catch (Exception e) {
                        this.log.warning("Error removing new content: " + file);
                    }
                    throw new IOException("Bad SHA1 - file: " + sha1 + " != " + existingSha1);
                }
                OpenNode sl = ((OpenNode)parent).addNode(on.getLabel() + ".sha1" + ".local");
                this.fileContentStore.putContent(sl, (InputStream)shaStream, context);
            }
        }
        if ((".jar".equals(context.getSingleSuffix()) || context.forceDescriptorCheck()) && (descriptor = Configuration.getResolvers(this).descriptor(node)) != null && descriptor.hasBinaries()) {
            InputStream is = descriptor.getInputStream();
            shaStream = null;
            try {
                this.fileContentStore.putContent(descriptor, is, context);
            }
            catch (Throwable x2) {
                shaStream = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (shaStream != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)shaStream).addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        if (this.getCache() != null) {
            List<String> paths = NodeUtils.toLabelPath(node);
            OpenNode current = this.getCache();
            for (String path : paths) {
                if (current == null) break;
                current.refresh(false);
                OpenNode tmp = current.peekChild(path);
                current = tmp instanceof OpenNode ? (OpenNode)OpenNode.class.cast(tmp) : null;
            }
        }
        return file;
    }

    @Override
    protected void addContent(ArtifactContext context, Node parent, String label, InputStream content) throws IOException {
        Node child;
        if (parent instanceof OpenNode) {
            OpenNode on = (OpenNode)parent;
            child = on.peekChild(label);
            if (child == null) {
                child = on.addNode(label);
            }
        } else {
            child = parent.getChild(label);
        }
        if (child == null) {
            throw new IOException("Cannot add child [" + label + "] content [" + content + "] on parent node: " + parent);
        }
        this.putContent(context, child, content, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNode(Node parent, String child) throws IOException {
        Node node = parent.getChild(child);
        if (this.fileContentStore != null) {
            try {
                if (node != null) {
                    Node descriptor;
                    Node origin;
                    Node sl = parent.getChild(child + ".sha1" + ".local");
                    if (sl != null) {
                        this.fileContentStore.removeFile(sl);
                    }
                    if ((origin = parent.getChild(child + ".origin")) != null) {
                        this.fileContentStore.removeFile(origin);
                    }
                    if ((descriptor = Configuration.getResolvers(this).descriptor(node)) != null) {
                        this.fileContentStore.removeFile(descriptor);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            super.removeNode(parent, child);
        }
        finally {
            if (node != null) {
                this.fileContentStore.removeFile(node);
            }
        }
    }

    @Override
    protected Boolean checkSHA(Node artifact) throws IOException {
        File shaFile;
        Node sha;
        Boolean result = super.checkSHA(artifact);
        if (result == null && !artifact.isRemote() && this.getCache() != null && NodeUtils.isAncestor(this.getCache(), artifact) && (sha = artifact.getChild(".sha1.local")) != null && (shaFile = this.fileContentStore.getFile(sha)).exists()) {
            return this.checkSHA(artifact, IOUtils.toInputStream(shaFile));
        }
        return result;
    }

    public String toString() {
        return "RootRepositoryManager: " + this.fileContentStore;
    }

    public boolean hasMavenRepository() {
        for (CmrRepository root : this.getRepositories()) {
            if (!root.isMaven()) continue;
            return true;
        }
        return false;
    }
}

