/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ShaSigner {
    private static Logger NULL_LOGGER = new NullLogger();
    static final char[] Hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static File sign(File file, Logger log, boolean verbose) {
        String sha1 = ShaSigner.hash(file, "SHA-1", log);
        if (sha1 == null) {
            return null;
        }
        File sha1File = new File(file.getPath() + ".sha1");
        if (verbose) {
            log.info("[signing jar " + file.getPath() + " into: " + sha1File.getPath() + "]");
        }
        ShaSigner.writeSha1(sha1File, sha1, log);
        return sha1File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeSha1(File sha1Path, String sha1, Logger log) {
        FileOutputStream os;
        try {
            os = new FileOutputStream(sha1Path);
        }
        catch (FileNotFoundException e) {
            log.warning("Failed to open archive file " + sha1Path + " for writing, no SHA-1 signature will be made");
            return;
        }
        try {
            ((OutputStream)os).write(sha1.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            log.warning("Failed to get an ASCII charset, your JRE does not follow the specs. No SHA-1 signature will be made");
            return;
        }
        catch (IOException e) {
            log.warning("Failed to write to " + sha1Path + ", no SHA-1 signature will be made");
            return;
        }
        finally {
            try {
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String sha1(File file) {
        return ShaSigner.hash(file, "SHA-1", NULL_LOGGER);
    }

    public static String md5(File file) {
        return ShaSigner.hash(file, "MD5", NULL_LOGGER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String hash(File file, String hashAlgo, Logger log) {
        FileInputStream is;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(hashAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("Failed to get a " + hashAlgo + " message digest, your JRE does not follow the specs. " + "No " + hashAlgo + " signature will be made");
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.warning("Failed to open archive file " + file.getPath() + ", no " + hashAlgo + " signature will be made");
            return null;
        }
        byte[] buffer = new byte[1024];
        int read = 0;
        try {
            while ((read = is.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        catch (IOException e) {
            log.warning("Failed to read archive file " + file.getPath() + ", no " + hashAlgo + " signature will be made");
            String string = null;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return ShaSigner.toHexString(digest.digest());
    }

    private static String toHexString(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int c = 0;
        for (int b = 0; b < bytes.length; ++b) {
            int v = bytes[b] & 0xFF;
            chars[c++] = Hexadecimal[v / 16];
            chars[c++] = Hexadecimal[v % 16];
        }
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signArtifact(RepositoryManager repoman, ArtifactContext context, File jarFile, Logger log) {
        ArtifactContext sha1Context = context.getSha1Context();
        if (sha1Context != null) {
            sha1Context.setForceOperation(true);
            File shaFile = ShaSigner.sign(jarFile, log, false);
            if (shaFile != null) {
                try {
                    repoman.putArtifact(sha1Context, shaFile);
                }
                finally {
                    shaFile.delete();
                }
            }
        }
    }

    private static class NullLogger
    implements Logger {
        private NullLogger() {
        }

        @Override
        public void error(String str) {
        }

        @Override
        public void warning(String str) {
        }

        @Override
        public void info(String str) {
        }

        @Override
        public void debug(String str) {
        }
    }
}

